<?php
header('Content-Type: application/json');

// ▼▼▼ TU API KEY YA ESTÁ INCLUIDA AQUÍ ▼▼▼
$apiKey = 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw'; 

// --- Verificación y lectura de datos ---
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!$data || !isset($data['service']) || !isset($data['client_desc'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud.']);
    exit;
}

// --- PROMPT MAESTRO (v2.2 - Con Contexto del Curso) ---
$prompt = "Actúa como un coach de marketing experto para negocios locales, basándote en la siguiente filosofía y principios del curso 'Estrategia Para Atraer Clientes Locales En 3 Pasos'.

--- CONTEXTO Y FILOSOFÍA DEL CURSO (Módulo 2) ---
Principio Clave: No se le habla a todo el mundo. El objetivo es definir un cliente ideal específico que valora el servicio y puede pagarlo.
El Proceso de Definición se basa en 4 Pasos:
1.  **Perfil del Cliente (Quién es):** Una descripción de la persona real. (Ej: Dueño de casa grande, trabaja todo el día).
2.  **Problema (Dolor):** La situación que le causa estrés o molestia. (Ej: Llega cansado y le molesta ver todo desordenado).
3.  **Deseo (Beneficio Emocional):** Lo que realmente quiere sentir o lograr. No es el servicio, es la emoción. (Ej: Paz mental y tiempo libre para su familia).
4.  **Conexión Emocional:** La clave es conectar con las emociones (cansancio, frustración, inseguridad) para presentar el servicio como el alivio a ese sentir.

--- TU TAREA ---
Un estudiante ha proporcionado esta información básica:
- Su Servicio: {$data['service']}
- Descripción simple de sus clientes: {$data['client_desc']}

Usando el CONTEXTO DEL CURSO que te he proporcionado, analiza la información del estudiante y genera un 'Perfil de Cliente Ideal' estratégico y detallado. Debes deducir el problema y el deseo basándote en los principios.

La respuesta DEBE ser un objeto JSON válido con la siguiente estructura:
- 'titulo_perfil': Un nombre creativo para este perfil.
- 'problema': Un párrafo describiendo el 'Problema Urgente' (el dolor).
- 'deseo': Un párrafo describiendo el 'Deseo Profundo' (el beneficio emocional).
- 'frase_marketing': Una frase potente que conecte el servicio con el deseo.
- 'sugerencias': Un array de 2-3 sugerencias prácticas para anuncios.
- 'resumen_copiar': Un texto formateado para copiar, con saltos de línea '\\n' y las etiquetas 'Perfil:', 'Problema:', 'Deseo:', y 'Frase Clave:'.";

// --- Llamada a la API de Google ---
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// --- Procesamiento y envío de la respuesta ---
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'No se pudo obtener una respuesta de la IA.']);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'];
$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null) {
    http_response_code(500);
    echo json_encode(['error' => 'La IA devolvió un formato de JSON inválido.']);
    exit;
}

echo json_encode($final_data);
?>
