<?php include 'GuardianKey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Analista De Resultados Publicitarios - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { font-family: 'Barlow', sans-serif; }
        #result-container { opacity: 0; transform: scale(0.95); animation: fade-in 0.5s ease-out forwards; }
        @keyframes fade-in { to { opacity: 1; transform: scale(1); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-3xl">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-4xl font-black text-brand-blue-dark">ANALISTA DE RESULTADOS PUBLICITARIOS</h1>
            <p class="text-gray-600 mt-2 text-xl">Analiza Tus Anuncios Y Recibe Ideas Claras Para Mejorar Resultados</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="analyzer-form" class="space-y-6">
                
                <h2 class="text-2xl font-bold text-brand-blue-dark border-b pb-2">Tipo De Campaña Publicitaria</h2>
                    <div>
                        <label for="campaign_objective" class="block font-semibold text-gray-700 mb-2">¿Cuál Fue El Objetivo Principal De Tu Anuncio?</label>
                        <select id="campaign_objective" class="w-full p-3 border-2 border-brand-yellow rounded-md bg-gray-50" required>
                            <option value="Recibir Mensajes">Recibir Mensajes (Recomendado En El Curso)</option>
                            <option value="Tráfico a la Página Web">Tráfico A Tu Página Web</option>
                            <option value="Generación de Clientes Potenciales">Generación De Clientes Potenciales (Formulario)</option>
                            <option value="Interacción con la Publicación">Interacción Con La Publicación (Likes, Comentarios)</option>
                        </select>
                    </div>


                <h2 class="text-2xl font-bold text-brand-blue-dark border-b pb-2 pt-4">Métricas Del Negocio (Resultados Finales)</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="investment" class="block font-semibold text-gray-700 mb-2">Inversión Total ($)</label>
                        <input type="number" step="0.01" id="investment" placeholder="Ej: 50" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                     <div>
                        <label for="service_price" class="block font-semibold text-gray-700 mb-2">Precio Del Servicio</label>
                        <input type="number" step="0.01" id="service_price" placeholder="Ej: 150" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                    <div>
                        <label for="messages" class="block font-semibold text-gray-700 mb-2">Nº De Mensajes O Leads</label>
                        <input type="number" id="messages" placeholder="Ej: 10" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                     <div>
                        <label for="closed_clients" class="block font-semibold text-gray-700 mb-2">¿Cuántos Clientes Cerraste?</label>
                        <input type="number" id="closed_clients" placeholder="Ej: 3" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                </div>
                
                <h2 class="text-2xl font-bold text-brand-blue-dark border-b pb-2 pt-4">Métricas De Diagnóstico</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="impressions" class="block font-semibold text-gray-700 mb-2">Visualizaciones</label>
                        <input type="number" id="impressions" placeholder="Ej: 10000" class="w-full p-3 border border-gray-300 rounded-md">
                    </div>
                     <div>
                        <label for="clicks" class="block font-semibold text-gray-700 mb-2">Clics En El Enlace</label>
                        <input type="number" id="clicks" placeholder="Ej: 100" class="w-full p-3 border border-gray-300 rounded-md">
                    </div>
                </div>

                <h2 class="text-2xl font-bold text-brand-blue-dark border-b pb-2 pt-4">¿Quién y Dónde Respondió Mejor?</h2>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="demographics" class="block font-semibold text-gray-700 mb-2">Mejor Edad y Género</label>
                        <input type="text" id="demographics" placeholder="Ej: Mujeres de 35-44 años" class="w-full p-3 border border-gray-300 rounded-md" required>
                    </div>
                    <div>
                        <label for="platform" class="block font-semibold text-gray-700 mb-2">Mejor Plataforma</label>
                         <select id="platform" class="w-full p-3 border border-gray-300 rounded-md" required>
                             <option value="Facebook">Facebook</option>
                             <option value="Instagram">Instagram</option>
                             <option value="Ambas por igual">Ambas Por Igual</option>
                         </select>
                    </div>
                </div>
                <div>
                    <label for="locations" class="block font-semibold text-gray-700 mb-2">Mejores Ubicaciones</label>
                    <textarea id="locations" placeholder="Ej:&#10;Seattle&#10;Kent&#10;Renton" class="w-full p-3 border border-gray-300 rounded-md" rows="4" required></textarea>
                </div>
                
                <button id="generateBtn" type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center mt-6">
                    <span id="btn-text">Generar Análisis De Anuncios</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
    
        <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
    
   <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('analyzer-form');
    const resultContainer = document.getElementById('result-container');
    
    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        const generateBtn = document.getElementById('generateBtn');
        const btnText = document.getElementById('btn-text');
        const loader = document.getElementById('loader');

        btnText.textContent = 'Analizando Datos Publicitarios...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        
        const formData = {
            campaign_objective: document.getElementById('campaign_objective').value,
            investment: document.getElementById('investment').value,
            messages: document.getElementById('messages').value,
            closed_clients: document.getElementById('closed_clients').value,
            service_price: document.getElementById('service_price').value,
            impressions: document.getElementById('impressions').value || 'N/A',
            clicks: document.getElementById('clicks').value || 'N/A',
            demographics: document.getElementById('demographics').value,
            locations: document.getElementById('locations').value,
            platform: document.getElementById('platform').value
        };

        try {
            const response = await fetch('API-Analista-De-Resultados-Publicitarios.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) { throw new Error('Error en la respuesta del servidor.'); }

            const data = await response.json();
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            resultContainer.innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudo generar el análisis.</p></div>`;
        } finally {
            btnText.textContent = 'Generar Análisis De Negocio';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.style.opacity = '0';
        resultContainer.innerHTML = `
            <div class="bg-white p-8 rounded-2xl shadow-lg border-t-8 border-brand-red space-y-8">
                <div>
                    <h2 class="text-3xl font-black text-center text-brand-blue-dark">${data.diagnostico_general.titulo}</h2>
                    <p class="text-center text-gray-600 mt-2">${data.diagnostico_general.subtitulo}</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-center">
                    <div class="bg-gray-100 p-4 rounded-lg">
                        <span class="text-3xl font-bold text-brand-blue-dark">${data.metricas_clave.cac}</span>
                        <p class="text-sm text-gray-600">Costo por Cliente Nuevo</p>
                    </div>
                    <div class="bg-gray-100 p-4 rounded-lg">
                        <span class="text-3xl font-bold text-brand-blue-dark">${data.metricas_clave.roi}</span>
                        <p class="text-sm text-gray-600">Retorno de Inversión (ROI)</p>
                    </div>
                    <div class="bg-brand-yellow p-4 rounded-lg">
                        <span class="text-3xl font-bold text-brand-blue-dark">${data.metricas_clave.tasa_cierre}</span>
                        <p class="text-sm text-brand-blue-dark/80">Tasa de Cierre (Eficiencia)</p>
                    </div>
                </div>

                <div class="border-t pt-6">
                    <h3 class="text-xl font-bold text-brand-blue-dark"><i class="fas fa-search-dollar mr-2 text-brand-red"></i>Análisis Financiero</h3>
                    <p class="text-gray-700 mt-2">${data.analisis_financiero}</p>
                </div>
                
                <div class="border-t pt-6">
                    <h3 class="text-xl font-bold text-brand-blue-dark"><i class="fas fa-bullseye mr-2 text-brand-red"></i>Diagnóstico Del Anuncio</h3>
                    <p class="text-gray-700 mt-2">${data.diagnostico_anuncio}</p>
                </div>
                
                <div class="border-t pt-6 bg-gray-100 p-6 rounded-lg">
                    <h3 class="text-2xl font-bold text-brand-red"><i class="fas fa-arrow-up-right-from-square mr-2"></i>Plan De Acción Próxima Campaña</h3>
                    <ul class="list-decimal list-inside text-gray-800 mt-4 space-y-2 text-lg">
                        ${data.plan_de_accion.map(s => `<li>${s}</li>`).join('')}
                    </ul>
                </div>
            </div>
        `;
        
        setTimeout(() => { resultContainer.style.opacity = '1'; }, 100);
    }
});
</script>
</body>
</html>