<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Copiloto De Seguimiento Y Ventas - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { font-family: 'Barlow', sans-serif; }
        .result-card, .client-message-card { opacity: 0; transform: translateY(20px); animation: slide-in 0.5s ease-out forwards; }
        @keyframes slide-in { to { opacity: 1; transform: translateY(0); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        /* El estilo para el contexto bloqueado ya usa el rojo de la marca, lo cual es correcto. Se mantiene. */
        .context-locked { background-color: #f8f9fa; border-left: 4px solid #9e1428; }
        .context-locked input, .context-locked textarea { background-color: #e9ecef; cursor: not-allowed; }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-4xl font-black text-brand-blue-dark">ASISTENTE INTELIGENTE DE VENTAS</h1>
            <p class="text-gray-600 mt-2 text-xl">Tu Copiloto De IA Que Te Dice Qué Responder Para Cerrar Más Ventas</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="copilot-form">
                <div id="context-section" class="space-y-6 transition-all duration-500">
                    <h2 class="text-2xl font-bold text-brand-blue-dark border-b pb-2">Paso 1: Contexto Inicial De La Conversación</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="client_name" class="block text-lg font-semibold text-brand-blue-dark mb-2">Nombre Del Cliente</label>
                            <input type="text" id="client_name" placeholder="Ej: Sebastian" class="w-full p-3 border border-gray-300 rounded-md" required>
                        </div>
                         <div>
                            <label for="ad_copy" class="block text-lg font-semibold text-brand-blue-dark mb-2">Copy Del Anuncio Utilizado</label>
                            <textarea id="ad_copy" placeholder="Pega el texto del anuncio que vio el cliente..." class="w-full p-3 border border-gray-300 rounded-md" rows="3" required></textarea>
                        </div>
                    </div>
                     <div>
                        <label for="ideal_client_summary" class="block text-lg font-semibold text-brand-blue-dark mb-2">Resumen Del Cliente Ideal</label>
                        <textarea id="ideal_client_summary" placeholder="Pega aquí el resumen de la Herramienta 1..." class="w-full p-3 border border-gray-300 rounded-md" rows="5" required></textarea>
                    </div>
                </div>

                <hr class="my-6"/>
                
                <div id="conversation-section" class="space-y-6">
                     <h2 class="text-2xl font-bold text-brand-blue-dark border-b pb-2">Paso 2: Inicia La Conversación</h2>
                    <div>
                        <label for="client_message" class="block text-lg font-semibold text-brand-blue-dark mb-2">Primer Mensaje Del Cliente</label>
                        <textarea id="client_message" placeholder="Pega aquí la primera objeción o pregunta del cliente..." class="w-full p-3 border border-gray-300 rounded-md" rows="4" required></textarea>
                    </div>
                </div>
                
                <button id="generateBtn" type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center mt-6">
                    <span id="btn-text">Generar Respuestas Estratégicas</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
    
        <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
    
   <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('copilot-form');
    let conversationHistory = [];

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        const generateBtn = document.getElementById('generateBtn');
        const btnText = document.getElementById('btn-text');
        const loader = document.getElementById('loader');

        btnText.textContent = 'Pensando Como Un Experto En Ventas...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;

        const clientMessageInput = document.getElementById('client_message');
        const currentClientMessage = clientMessageInput.value;

        addClientMessageToUI(currentClientMessage);
        
        const payload = {
            client_name: document.getElementById('client_name').value,
            ad_copy: document.getElementById('ad_copy').value,
            ideal_client_summary: document.getElementById('ideal_client_summary').value,
            conversation_history: conversationHistory,
            current_client_message: currentClientMessage,
        };
        
        try {
            const response = await fetch('API-Asistente-Inteligente-De-Ventas.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload)
            });

            if (!response.ok) { throw new Error('Error en el servidor.'); }

            const data = await response.json();
            
            lockContext();
            
            conversationHistory.push({ role: 'user', text: currentClientMessage });
            conversationHistory.push({ role: 'model', text: data.sugerencias[0].respuesta.es });

            displayResult(data.sugerencias);
            clientMessageInput.value = '';

        } catch (error) {
            console.error("Error:", error);
            const resultContainer = document.getElementById('result-container');
            resultContainer.innerHTML += `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudieron generar las sugerencias.</p></div>`;
        } finally {
            btnText.textContent = 'Generar Nuevas Respuestas';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function addClientMessageToUI(message) {
        const resultContainer = document.getElementById('result-container');
        const messageCard = document.createElement('div');
        // CAMBIO: Se reemplazó "bg-blue-100" por un gris neutro para alinear con el branding.
        messageCard.className = 'client-message-card bg-gray-100 p-4 rounded-lg ml-auto max-w-xl text-right my-4';
        messageCard.innerHTML = `<p class="font-semibold text-brand-blue-dark">Mensaje del Cliente:</p><p class="text-gray-800">${message}</p>`;
        resultContainer.appendChild(messageCard);
        window.scrollTo(0, document.body.scrollHeight);
    }

    function lockContext() {
        const contextSection = document.getElementById('context-section');
        if (!contextSection.classList.contains('context-locked')) {
            contextSection.classList.add('context-locked');
            contextSection.querySelectorAll('input, textarea').forEach(el => el.disabled = true);
            const clientMessageLabel = document.querySelector('label[for="client_message"]');
            if (clientMessageLabel) clientMessageLabel.textContent = "Siguiente Mensaje Del Cliente";
        }
    }

    function displayResult(sugerencias) {
        const resultContainer = document.getElementById('result-container');
        sugerencias.forEach((sug, index) => {
            resultContainer.appendChild(createSuggestionCard(sug, index));
        });
        
        document.querySelectorAll('.copy-btn').forEach(button => {
            button.addEventListener('click', function() {
                const textToCopy = unescape(this.dataset.copyText);
                navigator.clipboard.writeText(textToCopy).then(() => {
                    const originalText = this.innerHTML;
                    this.innerHTML = '<i class="fas fa-check"></i> Copiado';
                    setTimeout(() => { this.innerHTML = originalText; }, 2000);
                });
            });
        });
        window.scrollTo(0, document.body.scrollHeight);
    }

    function createSuggestionCard(sug, index) {
        const card = document.createElement('div');
        card.className = 'result-card bg-white p-6 rounded-2xl shadow-lg border-t-8 border-brand-red mb-6';
        card.style.animationDelay = `${index * 150}ms`;
        card.innerHTML = `
            <h2 class="text-2xl font-bold text-brand-blue-dark">${sug.titulo_estrategia}</h2>
            <p class="text-sm text-gray-600 mt-2 bg-gray-100 p-3 rounded-md"><i class="fas fa-info-circle mr-2 text-brand-red"></i><strong>Por qué funciona:</strong> ${sug.explicacion}</p>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                <div>
                    <h3 class="font-semibold text-gray-700 mb-2">🇪🇸 Respuesta Sugerida (Español)</h3>
                    <div class="relative"><textarea readonly class="w-full h-40 p-3 bg-gray-100 text-gray-800 rounded-md">${sug.respuesta.es}</textarea><button class="copy-btn absolute top-3 right-3 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md" data-copy-text="${escape(sug.respuesta.es)}"><i class="fas fa-copy"></i> Copiar</button></div>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-700 mb-2">🇺🇸 Suggested Reply (English)</h3>
                    <div class="relative"><textarea readonly class="w-full h-40 p-3 bg-gray-100 text-gray-800 rounded-md">${sug.respuesta.en}</textarea><button class="copy-btn absolute top-3 right-3 bg-brand-red text-white font-bold text-xs py-1 px-2 rounded-md" data-copy-text="${escape(sug.respuesta.en)}"><i class="fas fa-copy"></i> Copy</button></div>
                </div>
            </div>`;
        return card;
    }

    function escape(str) { return str.replace(/"/g, '&quot;').replace(/'/g, '&#39;'); }
    function unescape(str) { return str.replace(/&quot;/g, '"').replace(/&#39;/g, "'"); }
});
</script>
</body>
</html>