<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Planificador De Objetivos Estratégicos - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { 
            font-family: 'Barlow', sans-serif; 
        }
        #result-container { opacity: 0; transform: scale(0.95); animation: fade-in 0.5s ease-out forwards; }
        @keyframes fade-in { to { opacity: 1; transform: scale(1); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-4xl">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-5xl font-black text-brand-blue-dark">PLANIFICADOR DE OBJETIVOS</h1>
            <p class="text-gray-600 mt-2 text-xl">Crea Un Plan Semanal, Mensual O Trimestral Paso A Paso</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="objectives-form" class="space-y-8">
                
                <div>
                    <h2 class="text-3xl font-bold text-brand-blue-dark border-b-2 border-brand-red pb-2 mb-6">Paso 1: Define Tus Metas</h2>
                    <div class="space-y-6">
                        <div>
                            <label for="main-goal" class="font-bold text-lg text-brand-blue-dark">¿Qué Te Gustaría Lograr Al Aplicar Este Sistema?</label>
                            <input id="main-goal" type="text" placeholder="Ej: Conseguir 5 clientes nuevos este mes..." class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                        </div>
                        <div>
                            <label for="short-term-goal" class="font-bold text-lg text-brand-blue-dark">Objetivo A Corto Plazo (Esta Semana)</label>
                            <input id="short-term-goal" type="text" placeholder="Ej: Dejar lista mi página y lanzar mi primer anuncio." class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                        </div>
                        <div>
                            <label for="medium-term-goal" class="font-bold text-lg text-brand-blue-dark">Objetivo A Mediano Plazo (Este Mes)</label>
                            <input id="medium-term-goal" type="text" placeholder="Ej: Recibir mis primeros mensajes de clientes." class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                        </div>
                        <div>
                            <label for="long-term-goal" class="font-bold text-lg text-brand-blue-dark">Objetivo A Largo Plazo (En 3 Meses)</label>
                            <input id="long-term-goal" type="text" placeholder="Ej: Tener un sistema que atrae clientes de forma constante." class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                        </div>
                    </div>
                </div>

                <div>
                    <h2 class="text-3xl font-bold text-brand-blue-dark border-b-2 border-brand-red pb-2 mb-6">Paso 2: Define Tu Experiencia y Estrategia</h2>
                    <div class="space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="prior_experience" class="font-bold text-lg text-brand-blue-dark">¿Has Invertido En Publicidad Antes?</label>
                                <select id="prior_experience" class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                                    <option value="No, nunca he invertido">No, nunca he invertido</option>
                                    <option value="Sí, pero sin resultados claros">Sí, pero sin resultados claros</option>
                                    <option value="Sí, con buenos resultados">Sí, con buenos resultados</option>
                                </select>
                            </div>
                            <div>
                                <label for="campaign_objective" class="font-bold text-lg text-brand-blue-dark">Objetivo De Campaña Principal</label>
                                <select id="campaign_objective" class="w-full mt-2 p-3 border-2 border-brand-yellow rounded-md bg-gray-50 text-base" required>
                                    <option value="Recibir Mensajes">Recibir Mensajes (Recomendado)</option>
                                    <option value="Tráfico a la Página Web">Tráfico a la Página Web</option>
                                    <option value="Generación de Clientes Potenciales">Generación de Leads (Formulario)</option>
                                </select>
                            </div>
                        </div>
                        <div>
                            <label for="has_website" class="font-bold text-lg text-brand-blue-dark">¿Tienes Página Web Que Venda Por Ti 24/7?</label>
                            <select id="has_website" class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                                <option value="No, todavía no">No, todavía no</option>
                                <option value="Sí, pero es solo informativa">Sí, pero es solo informativa</option>
                                <option value="Sí, y está optimizada para vender">Sí, y está optimizada para vender</option>
                            </select>
                        </div>
                        <div>
                            <label for="other_strategies" class="font-bold text-lg text-brand-blue-dark">¿Qué Otras Estrategias Has Utilizado?</label>
                            <textarea id="other_strategies" placeholder="Ej: Repartir tarjetas, pedir recomendaciones, publicar en grupos..." class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" rows="3" required></textarea>
                        </div>
                    </div>
                </div>

                <div>
                    <h2 class="text-3xl font-bold text-brand-blue-dark border-b-2 border-brand-red pb-2 mb-6">Paso 3: Define Tu Inversión Publicitaria</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="budget" class="font-bold text-lg text-brand-blue-dark">Presupuesto Mensual Para Anuncios</label>
                            <input id="budget" type="number" step="1" placeholder="Ej: 150" class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                        </div>
                        <div>
                            <label for="service-price" class="font-bold text-lg text-brand-blue-dark">Precio Promedio De Tu Servicio</label>
                            <input id="service-price" type="number" step="1" placeholder="Ej: 300" class="w-full mt-2 p-3 border border-gray-300 rounded-md text-base" required>
                        </div>
                    </div>
                </div>

                 <button id="generateBtn" type="submit" class="!mt-10 w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center">
                    <span id="btn-text">Generar Tu Plan Estratégico</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
    
        <!-- CAMBIO: Se ajustó el color a "text-brand-yellow" para consistencia con las otras herramientas. -->
        <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
    
   <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('objectives-form');
    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        const generateBtn = document.getElementById('generateBtn');
        const btnText = document.getElementById('btn-text');
        const loader = document.getElementById('loader');

        btnText.textContent = 'Creando Tu Plan Publicitario...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        
        const payload = {
            main_goal: document.getElementById('main-goal').value,
            short_term_goal: document.getElementById('short-term-goal').value,
            medium_term_goal: document.getElementById('medium-term-goal').value,
            long_term_goal: document.getElementById('long-term-goal').value,
            prior_experience: document.getElementById('prior_experience').value,
            campaign_objective: document.getElementById('campaign_objective').value,
            has_website: document.getElementById('has_website').value,
            other_strategies: document.getElementById('other_strategies').value,
            budget: document.getElementById('budget').value,
            service_price: document.getElementById('service-price').value
        };

        try {
            const response = await fetch('API-Planificador-De-Objetivos.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload)
            });

            if (!response.ok) { throw new Error('Error en la respuesta del servidor.'); }
            const data = await response.json();
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            document.getElementById('result-container').innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudo generar el análisis.</p></div>`;
        } finally {
            btnText.textContent = 'Generar mi Plan Estratégico';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        const resultContainer = document.getElementById('result-container');
        resultContainer.style.opacity = '0';
        // MEJORA TOTAL: El plan de acción fue rediseñado para ser más visual y claro.
        resultContainer.innerHTML = `
            <div class="bg-white p-8 rounded-2xl shadow-lg border-t-8 border-brand-red space-y-8">
                <div class="text-center">
                    <h2 class="text-3xl font-black text-brand-blue-dark">Tu Reporte Estratégico CLIENT3</h2>
                </div>

                <div class="border-t pt-6">
                    <h3 class="text-2xl font-bold text-brand-blue-dark"><i class="fas fa-bullseye mr-2"></i>Análisis De Tu Situación y Metas</h3>
                    <p class="text-gray-700 mt-2 text-lg">${data.analisis_objetivos}</p>
                </div>

                <div class="border-t pt-6">
                    <h3 class="text-2xl font-bold text-brand-blue-dark"><i class="fas fa-calculator mr-2"></i>Análisis De Viabilidad Financiera</h3>
                    <p class="text-gray-700 mt-2 text-lg">${data.analisis_viabilidad}</p>
                </div>
                
                <div class="border-t pt-6 bg-gray-100 p-6 rounded-lg">
                    <h3 class="text-2xl font-bold text-brand-red"><i class="fas fa-rocket mr-2"></i>Tu Plan De Acción Personalizado</h3>
                    <div class="mt-6 space-y-8">
                        <div class="flex items-start">
                            <div class="flex-shrink-0 flex items-center justify-center h-10 w-10 rounded-full bg-brand-red text-white font-bold text-xl"><i class="fas fa-flag-checkered"></i></div>
                            <div class="ml-4">
                                <h4 class="font-bold text-xl text-brand-blue-dark">Primer Paso Inmediato</h4>
                                <p class="text-gray-700 text-lg mt-1">${data.plan_de_accion.primer_paso}</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 flex items-center justify-center h-10 w-10 rounded-full bg-brand-red text-white font-bold text-xl"><i class="fas fa-calendar-week"></i></div>
                            <div class="ml-4">
                                <h4 class="font-bold text-xl text-brand-blue-dark">Enfoque a Corto Plazo (Esta Semana)</h4>
                                <p class="text-gray-700 text-lg mt-1">${data.plan_de_accion.corto_plazo}</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 flex items-center justify-center h-10 w-10 rounded-full bg-brand-red text-white font-bold text-xl"><i class="fas fa-calendar-alt"></i></div>
                            <div class="ml-4">
                                <h4 class="font-bold text-xl text-brand-blue-dark">Enfoque a Mediano Plazo (Este Mes)</h4>
                                <p class="text-gray-700 text-lg mt-1">${data.plan_de_accion.mediano_plazo}</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="flex-shrink-0 flex items-center justify-center h-10 w-10 rounded-full bg-brand-red text-white font-bold text-xl"><i class="fas fa-calendar-check"></i></div>
                            <div class="ml-4">
                                <h4 class="font-bold text-xl text-brand-blue-dark">Enfoque a Largo Plazo (3 Meses)</h4>
                                <p class="text-gray-700 text-lg mt-1">${data.plan_de_accion.largo_plazo}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `;
        setTimeout(() => { 
            resultContainer.style.opacity = '1'; 
            resultContainer.scrollIntoView({ behavior: 'smooth' });
        }, 100);
    }
});
</script>
</body>
</html>