<?php
session_start();
include 'ConectAPI.php';

$token = $_GET['token'] ?? '';
$message = '';
$email = '';
$token_valido = false;

// 1. Validar que el token exista en la URL
if (empty($token)) {
    $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Error:</strong> El enlace de registro no es válido o ha expirado.</div>';
} else {
    // 2. Buscar el token en la base de datos y asegurarse de que no haya expirado (es válido por 24 horas)
    $stmt = $conn->prepare("SELECT email FROM registro_tokens WHERE token = ? AND fecha_creacion >= NOW() - INTERVAL 1 DAY");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        // Si el token es válido, obtenemos el email y preparamos el formulario
        $token_data = $result->fetch_assoc();
        $email = $token_data['email'];
        $token_valido = true;
    } else {
        $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Error:</strong> El enlace de registro no es válido o ha expirado.</div>';
    }
    $stmt->close();
}

// 3. Procesar el formulario cuando el usuario envía sus datos
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $token_valido) {
    $nombre = trim($_POST['nombre']);
    $password = $_POST['password'];

    if (empty($nombre) || empty($password)) {
        $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Error:</strong> Por favor, completa todos los campos.</div>';
    } else {
        // 4. Crear la cuenta del estudiante
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $fecha_registro = date('Y-m-d H:i:s');
        $fecha_expiracion = date('Y-m-d', strtotime('+1 month'));
        $producto_comprado = "Acceso Estandar";

        $stmt_insert = $conn->prepare("INSERT INTO estudiantes (nombre, email, password, producto_comprado, fecha_registro, fecha_expiracion) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt_insert->bind_param("ssssss", $nombre, $email, $hashed_password, $producto_comprado, $fecha_registro, $fecha_expiracion);
        
        if ($stmt_insert->execute()) {
            // 5. Eliminar el token para que no se pueda volver a usar
            $stmt_delete = $conn->prepare("DELETE FROM registro_tokens WHERE email = ?");
            $stmt_delete->bind_param("s", $email);
            $stmt_delete->execute();
            $stmt_delete->close();

            // 6. Redirigir al usuario a la página de éxito
            header('Location: Gracias-Registro-Exitoso.php');
            exit;
        } else {
            $message = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert"><strong>Error:</strong> No se pudo crear tu cuenta. Inténtalo de nuevo.</div>';
        }
        $stmt_insert->close();
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Finaliza tu Registro - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --color-primary: #07162d;
            --color-secondary: #9e1428;
            --color-highlight: #ffc857;
            --color-white: #ffffff;
        }
        body {
            font-family: 'Barlow', sans-serif;
            background-color: var(--color-primary);
            margin: 0;
            padding: 2rem 1rem;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
    </style>
</head>
<body>
    <div class="container mx-auto p-4 flex min-h-screen items-center justify-center">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-0 max-w-5xl rounded-2xl shadow-2xl overflow-hidden">
            <!-- Columna de la imagen -->
            <div class="hidden md:block">
                 <img src="Portada.jpg" alt="Portada Recurso" class="w-full h-full object-contain">
            </div>
            
            <!-- Contenedor del formulario -->
            <div class="bg-white p-8 md:p-12 flex flex-col justify-center">
                <header class="text-center mb-6">
                    <img src="LogoPlataformaNegro.png" alt="Logo Plataforma" class="mx-auto h-20 w-auto mb-4">
                    <h1 class="text-3xl font-black">
                        <span class="text-[var(--color-primary)]">FINALIZA TU</span> <span class="text-[var(--color-secondary)]">REGISTRO</span>
                    </h1>
                    <p class="text-gray-600 mt-2">¡Ya casi estás! Solo un paso más para acceder.</p>
                </header>
                
                <?php echo $message; ?>
                
                <?php if ($token_valido): ?>
                <form action="crear-cuenta.php?token=<?php echo htmlspecialchars($token); ?>" method="POST" class="space-y-6">
                    <div>
                        <label for="email" class="block text-left text-gray-700 font-semibold mb-1">Correo Electrónico (Verificado)</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fas fa-envelope text-gray-400"></i>
                            </span>
                            <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($email); ?>"
                                   class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg bg-gray-100 cursor-not-allowed" readonly>
                        </div>
                    </div>
                    <div>
                        <label for="nombre" class="block text-left text-gray-700 font-semibold mb-1">Nombre Completo</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fas fa-user text-gray-400"></i>
                            </span>
                            <input type="text" id="nombre" name="nombre" 
                                   class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-[var(--color-highlight)] focus:border-[var(--color-highlight)]" 
                                   placeholder="Tu Nombre Completo" required>
                        </div>
                    </div>
                    <div>
                        <label for="password" class="block text-left text-gray-700 font-semibold mb-1">Crea tu Contraseña</label>
                        <div class="relative">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <i class="fas fa-lock text-gray-400"></i>
                            </span>
                            <input type="password" id="password" name="password" 
                                   class="w-full pl-10 pr-10 py-3 border border-gray-300 rounded-lg focus:ring-[var(--color-highlight)] focus:border-[var(--color-highlight)]" 
                                   placeholder="Crea una contraseña segura" required>
                            <span class="absolute inset-y-0 right-0 flex items-center pr-3 cursor-pointer" id="togglePassword">
                                <i class="fas fa-eye text-gray-400" id="eyeIcon"></i>
                            </span>
                        </div>
                    </div>
                    <button type="submit" class="w-full bg-[var(--color-primary)] text-white font-bold py-3 px-8 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg">
                        COMPLETAR REGISTRO Y ACCEDER
                    </button>
                </form>
                <?php endif; ?>
                
                <div class="mt-8">
                    <?php include 'FooterBK.php'; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        const togglePassword = document.querySelector('#togglePassword');
        if (togglePassword) {
            const passwordInput = document.querySelector('#password');
            const eyeIcon = document.querySelector('#eyeIcon');
            togglePassword.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                eyeIcon.classList.toggle('fa-eye');
                eyeIcon.classList.toggle('fa-eye-slash');
            });
        }
    </script>
</body>
</html>
