<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CLIENT3 | Traductor Inteligente de Anuncios - Academia De Publicidad</title>
    <?php include 'gtm-header.php'; ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { font-family: 'Barlow', sans-serif; }
        #result-container { opacity: 0; transform: scale(0.95); animation: fade-in 0.5s ease-out forwards; }
        @keyframes fade-in { to { opacity: 1; transform: scale(1); } }
        .loader { border: 4px solid #f3f3f3; border-top: 4px solid #07162d; border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Barlow', 'sans-serif'], },
                    colors: { 
                        'brand-blue-dark': '#07162d', 
                        'brand-red': '#9e1428',
                        'brand-white': '#f5f5f5',
                        'brand-yellow': '#ffc857'
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-brand-white">
    <div class="container mx-auto p-4 md:p-8 max-w-3xl">
        
        <div class="text-center mb-6">
            <img src="LogoClient3Black.png" alt="Logo CLIENT3" class="mx-auto h-24 w-auto">
        </div>

        <header class="text-center mb-8">
            <h1 class="text-4xl font-black text-brand-blue-dark">TRADUCTOR AL INGLÉS INTELIGENTE</h1>
            <p class="text-gray-600 mt-2 text-xl">Traduce Textos A Inglés Con Enfoque En Marketing Y Ventas</p>
        </header>

        <div class="bg-white p-6 md:p-8 rounded-2xl shadow-lg">
            <form id="translator-form" class="space-y-6">
                <div>
                    <label for="ad_text_es" class="block text-lg font-semibold text-brand-blue-dark mb-2">Pega Aquí El Texto En Español</label>
                    <textarea id="ad_text_es" placeholder="Escribe o pega el texto completo de tu anuncio aquí..." class="w-full p-3 border border-gray-300 rounded-md text-base" rows="8" required></textarea>
                </div>
                
                <button id="generateBtn" type="submit" class="w-full bg-brand-red text-white font-bold py-3 px-4 rounded-lg hover:opacity-90 transition-opacity shadow-lg text-lg flex items-center justify-center">
                    <span id="btn-text">Traducir Textos Con Estrategia</span>
                    <div id="loader" class="loader hidden ml-3"></div>
                </button>
            </form>
        </div>
        
        <div id="result-container" class="mt-8"></div>
    </div>
        <div class="text-center mt-8 mb-8">
        <a href="index.php" class="text-brand-blue-dark text-xl md:text-2xl font-extrabold flex items-center justify-center">
            <i class="fas fa-arrow-left mr-2"></i> REGRESAR AL PORTAL
        </a>
    </div>
  <?php include 'FooterBK.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('translator-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loader = document.getElementById('loader');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Traduciendo Textos Con Estrategia...';
        loader.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        
        const formData = {
            ad_text_es: document.getElementById('ad_text_es').value,
        };

        try {
            const response = await fetch('API-Traductor-Al-Ingles-Inteligente.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) { throw new Error('Error en la respuesta del servidor.'); }

            const data = await response.json();
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            resultContainer.innerHTML = `<div class="text-center p-4 bg-red-100 text-red-700 rounded-lg"><p><strong>Error:</strong> No se pudo generar la traducción.</p></div>`;
        } finally {
            btnText.textContent = 'Traducir con Estrategia';
            loader.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.style.opacity = '0';
        
        resultContainer.innerHTML = `
            <div class="bg-white p-8 rounded-2xl shadow-lg border-t-8 border-brand-red space-y-8">
                <div>
                    <h2 class="text-2xl font-bold text-brand-blue-dark">🇺🇸 Versión Estratégica En Inglés</h2>
                     <div class="relative mt-4">
                        <textarea readonly class="w-full h-64 p-4 bg-brand-blue-dark text-white font-medium rounded-md resize-none leading-relaxed text-lg">${data.traduccion}</textarea>
                        
                        <button class="copy-btn absolute bottom-4 right-4 bg-brand-red text-white font-bold text-sm py-2 px-4 rounded-md hover:opacity-90" data-copy-text="${escape(data.traduccion)}"><i class="fas fa-copy mr-2"></i>Copiar</button>
                    </div>
                </div>

                <div>
                    <h3 class="font-bold text-xl text-brand-blue-dark"><i class="fas fa-lightbulb mr-2 text-brand-yellow"></i>Notas Del Traductor Inteligente</h3>
                    <div class="mt-3 pl-4 text-gray-700 space-y-3 border-l-4 border-brand-red/30">
                        ${data.notas.map(n => `<p class="text-lg leading-relaxed"><i class="fas fa-check-circle text-brand-red mr-3"></i>${n}</p>`).join('')}
                    </div>
                </div>
            </div>
        `;
        
        resultContainer.querySelector('.copy-btn').addEventListener('click', function() {
            const textToCopy = unescape(this.dataset.copyText);
            navigator.clipboard.writeText(textToCopy).then(() => {
                const originalText = this.innerHTML;
                this.innerHTML = '<i class="fas fa-check"></i> Copiado';
                setTimeout(() => { this.innerHTML = originalText; }, 2000);
            });
        });

        setTimeout(() => { resultContainer.style.opacity = '1'; }, 100);
    }
    
    function escape(str) { return str.replace(/"/g, '&quot;').replace(/'/g, '&#39;'); }
    function unescape(str) { return str.replace(/&quot;/g, '"').replace(/&#39;/g, "'"); }
});
</script>
</body>
</html>