<?php
session_start();
header('Content-Type: application/json');

// --- VERIFICACIÓN DE SEGURIDAD ---
// Se asegura que solo un administrador logueado pueda ejecutar este código.
if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
    exit;
}

// Incluir la conexión a la base de datos
include '../ConectAPI.php';

// Leer el cuerpo de la petición (enviado como JSON)
$data = json_decode(file_get_contents('php://input'), true);
$id = $data['id'] ?? null;

if ($id) {
    // Usamos sentencias preparadas para seguridad
    $stmt = $conn->prepare("DELETE FROM estudiantes WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Estudiante eliminado con éxito.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al eliminar el estudiante: ' . $stmt->error]);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'No se proporcionó un ID válido.']);
}

$conn->close();
?>