<?php
session_start();
header('Content-Type: application/json');

// VERIFICACIÓN DE SEGURIDAD
if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Acceso no autorizado.']);
    exit;
}

// La ruta es '../' porque este archivo está en la carpeta /api
include '../ConectAPI.php'; 

$response = ['success' => false, 'message' => 'Petición inválida.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $precio = $_POST['precio'] ?? null;

    if (is_numeric($precio) && $precio >= 0) {
        // Esta consulta actualiza el precio si ya existe, o lo crea si es la primera vez.
        $sql = "INSERT INTO configuracion (clave, valor) VALUES ('precio_producto', ?) ON DUPLICATE KEY UPDATE valor = ?";
        $stmt = $conn->prepare($sql);
        // Usamos 'd' para indicar que el valor es un decimal.
        $stmt->bind_param('dd', $precio, $precio); 

        if ($stmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Precio actualizado con éxito.';
        } else {
            $response['message'] = 'Error al actualizar el precio: ' . $stmt->error;
        }
        $stmt->close();
    } else {
        $response['message'] = 'El precio proporcionado no es válido.';
    }
}

$conn->close();
echo json_encode($response);
?>
