<?php
// Incluye tu archivo de conexión a la base de datos
include 'ConectAPI.php';

// --- 1. RECIBIR Y DECODIFICAR LOS DATOS DEL WEBHOOK ---
// El webhook envía los datos en formato JSON. Lo leemos y decodificamos.
$json_payload = file_get_contents('php://input');
$data = json_decode($json_payload, true);

// --- 2. VALIDACIÓN BÁSICA DE DATOS ---
// Verificamos que los datos esenciales (evento, email, nombre) existan.
if (!$data || !isset($data['event_type']) || !isset($data['customer_details']['email'])) {
    // Si los datos no son válidos, detenemos el script.
    http_response_code(400); // Bad Request
    exit('Datos no válidos.');
}

// --- 3. PROCESAR SOLO PAGOS EXITOSOS ---
// Nos aseguramos de que el evento sea una compra completada.
// **IMPORTANTE**: Reemplaza 'payment.successful' con el nombre real del evento de Dodo Payments.
if ($data['event_type'] === 'payment.successful') {

    $customer_email = trim($data['customer_details']['email']);
    // Usamos el nombre del cliente si está disponible, si no, usamos una parte del email.
    $customer_name = trim($data['customer_details']['name'] ?? explode('@', $customer_email)[0]);

    // --- 4. VERIFICAR SI EL USUARIO YA EXISTE ---
    $stmt_check = $conn->prepare("SELECT id FROM estudiantes WHERE email = ?");
    $stmt_check->bind_param("s", $customer_email);
    $stmt_check->execute();
    $stmt_check->store_result();

    if ($stmt_check->num_rows > 0) {
        // Si el usuario ya existe, no hacemos nada más.
        $stmt_check->close();
        exit('El usuario ya existe.');
    }
    $stmt_check->close();

    // --- 5. GENERAR UN TOKEN DE REGISTRO SEGURO ---
    // Creamos un código único y seguro que no se puede adivinar.
    $token = bin2hex(random_bytes(32));

    // --- 6. GUARDAR EL TOKEN EN LA BASE DE DATOS ---
    $stmt_token = $conn->prepare("INSERT INTO registro_tokens (email, token) VALUES (?, ?)");
    $stmt_token->bind_param("ss", $customer_email, $token);
    $stmt_token->execute();
    $stmt_token->close();

    // --- 7. ENVIAR EL CORREO DE BIENVENIDA CON EL ENLACE DE REGISTRO ---
    $to = $customer_email;
    $subject = "¡Gracias por tu compra! Crea tu cuenta en Academia De Publicidad";
    
    // **IMPORTANTE**: Reemplaza 'https://tuacademia.com' con tu dominio real.
    $registration_link = "https://tuacademia.com/crear-cuenta.php?token=" . $token;

    // Contenido del correo en formato HTML.
    $message = "
    <html>
    <head>
        <title>$subject</title>
    </head>
    <body style='font-family: Arial, sans-serif; color: #333;'>
        <h2>¡Hola, $customer_name!</h2>
        <p>Muchas gracias por tu compra. Estamos emocionados de tenerte con nosotros.</p>
        <p>Para completar tu registro y acceder a la plataforma, solo necesitas crear tu contraseña haciendo clic en el siguiente botón:</p>
        <a href='$registration_link' style='background-color: #9e1428; color: white; padding: 15px 25px; text-decoration: none; border-radius: 8px; font-weight: bold; display: inline-block;'>Crear mi Contraseña y Acceder</a>
        <p style='margin-top: 20px;'>Si el botón no funciona, copia y pega el siguiente enlace en tu navegador:</p>
        <p><a href='$registration_link'>$registration_link</a></p>
        <p>¡Nos vemos dentro!</p>
        <p><strong>El equipo de Academia De Publicidad</strong></p>
    </body>
    </html>
    ";

    // Cabeceras para enviar correo HTML.
    // **IMPORTANTE**: Reemplaza 'noreply@tuacademia.com' con tu correo.
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: Academia De Publicidad <noreply@tuacademia.com>' . "\r\n";

    // Enviamos el correo.
    mail($to, $subject, $message, $headers);
}

// Respondemos a Dodo Payments que todo se recibió correctamente.
http_response_code(200);
echo 'Webhook procesado.';
?>
