<?php
ob_start(); // Iniciar el búfer de salida al inicio del script
session_start();

// ***** IMPORTANTE: ESTAS LÍNEAS ESTÁN AQUÍ PARA DEPURAR. *****
// UNA VEZ QUE FUNCIONE, CÁMBIALAS A: error_reporting(0); ini_set('display_errors', 0);
error_reporting(E_ALL); // Reporta todos los errores
ini_set('display_errors', 1); // Muestra los errores en la pantalla
// *************************************************************

// Incluir la conexión a la base de datos
include_once 'db/db_connection.php';
include_once 'files/GuardianKey.php'; // Incluir si se usa para seguridad adicional

// --- Lógica PHP para obtener datos de clientes desde la base de datos ---
$clients_data_from_db = [];
$available_services_data = [];
$total_clients_count = 0;
$monthly_clients_count = 0;
$months_with_clients_data = [];
$selected_month_php = isset($_GET['month']) ? (int)$_GET['month'] : date('n');
$selected_year_php = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');

try {
    // Construir la URL del endpoint de lectura de clientes
    // Se usa realpath() para obtener la ruta absoluta y str_replace() para hacerla relativa a la raíz del servidor
    $read_url_path = str_replace($_SERVER['DOCUMENT_ROOT'], '', realpath(__DIR__ . '/db/clients-read.php'));
    // Asegurarse de que la URL sea correcta para la llamada cURL
    $full_read_url = "http://" . $_SERVER['HTTP_HOST'] . $read_url_path . "?year=" . $selected_year_php . "&month=" . $selected_month_php;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $full_read_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $read_response = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception(curl_error($ch));
    }
    curl_close($ch);

    $result = json_decode($read_response, true);

    if ($result['success']) {
        $clients_data_from_db = $result['data'];
        $available_services_data = $result['available_services'];
        $total_clients_count = $result['total_clients_count'];
        $monthly_clients_count = $result['monthly_clients_count'];
        $months_with_clients_data = $result['months_with_clients'];
        $selected_month_php = $result['selected_month'];
        $selected_year_php = $result['selected_year'];
    } else {
        error_log("Error al cargar clientes desde db/clients-read.php: " . ($result['message'] ?? 'Error desconocido'));
        $_SESSION['notification'] = ['message' => 'Error al cargar clientes: ' . ($result['message'] ?? 'Error desconocido'), 'type' => 'error'];
    }

} catch (Exception $e) {
    error_log("Excepción al cargar clientes en clients.php: " . $e->getMessage());
    $_SESSION['notification'] = ['message' => 'Error crítico al cargar clientes: ' . $e->getMessage(), 'type' => 'error'];
}


// Nombres de los meses en español para la visualización inicial
$month_names_php = [
    1 => "ENERO", 2 => "FEBRERO", 3 => "MARZO", 4 => "ABRIL", 5 => "MAYO", 6 => "JUNIO",
    7 => "JULIO", 8 => "AGOSTO", 9 => "SEPTIEMBRE", 10 => "OCTUBRE", 11 => "NOVIEMBRE", 12 => "DICIEMBRE"
];
$initial_monthly_period_display = $month_names_php[$selected_month_php] . ' ' . $selected_year_php;


// Codificar los datos a JSON para pasarlos a JavaScript
$clients_json = json_encode($clients_data_from_db);
$available_services_json = json_encode($available_services_data);
$months_with_clients_json = json_encode($months_with_clients_data);
$total_clients_count_json = json_encode($total_clients_count);
$monthly_clients_count_json = json_encode($monthly_clients_count);
$selected_month_js = json_encode($selected_month_php);
$selected_year_js = json_encode($selected_year_php);


// Manejo de notificaciones de sesión
$notification_message = '';
$notification_type = '';
if (isset($_SESSION['notification'])) {
    $notification_message = $_SESSION['notification']['message'];
    $notification_type = $_SESSION['notification']['type'];
    unset($_SESSION['notification']);
}
ob_end_clean();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard De Administrador - Clientes</title>
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script> 
    
</head>
 
<body data-page-title="PANEL DE ADMINISTRADOR"
      data-page-subtitle="GESTIÓN DE CLIENTES"
      data-page-icon="users">

<div id="toastNotification" class="toast-notification">
    <i id="toastIcon" class="fas"></i>
    <span id="toastMessage"></span>
    <button id="toastCloseBtn" class="toast-close-btn">×</button>
</div>
<style>
.toast-notification {
    visibility: hidden;
    min-width: 250px;
    background-color: #333;
    color: #fff;
    text-align: center;
    border-radius: 8px;
    padding: 16px;
    position: fixed;
    z-index: 1000;
    left: 50%;
    transform: translateX(-50%);
    bottom: 30px;
    font-size: 17px;
    display: flex;
    align-items: center;
    gap: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    opacity: 0;
    transition: opacity 0.5s, bottom 0.5s;
}

.toast-notification.show {
    visibility: visible;
    opacity: 1;
    bottom: 50px;
}

.toast-notification.success { background-color: #4CAF50; }
.toast-notification.error { background-color: #f44336; }
.toast-notification.info { background-color: #2196F3; }

.toast-notification .toast-close-btn {
    background: none;
    border: none;
    color: white;
    font-size: 20px;
    cursor: pointer;
    margin-left: auto;
}
</style>


<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">
            <section id="clientes-content" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="user-check" class="w-7 h-7 text-[var(--color-primary)]"></i> BASE DE DATOS DE CLIENTES ACTIVOS
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">ACCESO RÁPIDO A FICHA Y SERVICIOS CONTRATADOS.</p>
                        </div>
                        <div class="flex items-center gap-4 w-full md:w-auto">
                            <button class="btn-secondary font-bold py-2 px-4 rounded-lg flex items-center w-full md:w-auto justify-center uppercase" onclick="openPanel('addClientePanel')">
                                <i data-lucide="plus" class="w-5 h-5 mr-2"></i> AGREGAR CLIENTE
                            </button>
                            <button id="download-clientes-btn" class="btn-primary font-bold py-2 px-4 rounded-lg flex items-center w-full md:w-auto justify-center uppercase text-sm">
                                <i data-lucide="download" class="w-4 h-4 mr-2"></i> DESCARGAR
                            </button>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-primary)]">
                            <i data-lucide="users" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">TOTAL DE CLIENTES</h3>
                                <p id="total-clients-count" class="text-5xl font-bold text-[var(--color-secondary)]">0</p>
                                <p class="text-sm text-gray-400 mt-1">ACTIVOS EN LA BASE DE DATOS</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-red-500">
                            <i data-lucide="user-plus" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">CLIENTES NUEVOS EN <span id="monthly-period-display"><?php echo $initial_monthly_period_display; ?></span></h3>
                                <p id="monthly-clients-count" class="text-5xl font-bold text-red-700">0</p>
                                <p class="text-sm text-gray-400 mt-1 uppercase">CLIENTES AGREGADOS EN EL PERIODO SELECCIONADO</p>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end mb-6">
                        <select id="monthly-filter-select" class="w-full md:w-64 p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)] bg-white">
                        </select>
                    </div>

                    <h3 class="text-xl font-extrabold text-gray-800 mb-4 flex items-center gap-2 mt-8">
                        <i data-lucide="history" class="w-6 h-6 text-[var(--color-primary)]"></i> ÚLTIMOS CLIENTES
                    </h3>
                    <div id="recent-clients-grid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                    </div>

                    <div class="flex flex-col md:flex-row gap-4 mb-6">
                        <div class="relative flex-grow">
                            <input type="text" id="client-search" placeholder="Buscar Por Nombre o Servicio..." class="w-full p-3 pl-10 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]">
                            <i data-lucide="search" class="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400"></i>
                        </div>
                        <select id="client-filter-apellido-letter" class="w-full md:w-48 p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)] bg-white">
                            <option value="all">TODAS LAS LETRAS</option>
                        </select>
                        <select id="client-filter-service" class="w-full md:w-48 p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)] bg-white">
                            <option value="all">TODOS LOS SERVICIOS</option>
                        </select>
                        <div class="view-toggle inline-flex bg-gray-200 rounded-lg p-1">
                            <button id="grid-view-btn" class="px-3 py-1 rounded-md text-sm font-semibold transition-colors duration-200 active uppercase" title="Vista de Cuadrícula">
                                <i data-lucide="layout-grid" class="w-5 h-5"></i>
                            </button>
                            <button id="list-view-btn" class="px-3 py-1 rounded-md text-sm font-semibold transition-colors duration-200 uppercase" title="Vista de Lista">
                                <i data-lucide="list" class="w-5 h-5"></i>
                            </button>
                        </div>
                    </div>

                    <div id="client-grid-view" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    </div>

                    <div id="client-list-view" class="overflow-x-auto hidden">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-50">
                                <tr class="text-left text-gray-500 uppercase text-sm">
                                    <th class="py-3 px-6 font-semibold">NOMBRE</th>
                                    <th class="py-3 px-6 font-semibold hidden md:table-cell">EMAIL</th>
                                    <th class="py-3 px-6 font-semibold hidden lg:table-cell">TELÉFONO</th>
                                    <th class="py-3 px-6 font-semibold">SERVICIOS ACTIVOS</th>
                                    <th class="py-3 px-6 font-semibold text-center">ACCIONES</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-700 text-sm" id="clientsTableBody">
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<div id="addClientePanel" class="fixed inset-y-0 right-0 w-full md:w-1/2 bg-white shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out z-50 overflow-y-auto">
    <div class="p-8 flex flex-col h-full">
        <div class="flex justify-between items-center mb-6 flex-shrink-0">
            <h3 class="text-2xl font-bold text-[var(--color-primary)]">AGREGAR NUEVO CLIENTE</h3>
            <button onclick="closePanel('addClientePanel')" class="text-gray-400 hover:text-gray-600"><i data-lucide="x" class="w-6 h-6"></i></button>
        </div>
        <form id="add-cliente-form" class="flex-grow overflow-y-auto pr-2 -mr-2">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                <div>
                    <label for="cliente-first-name" class="block text-gray-700 text-sm font-bold mb-2 uppercase">NOMBRE</label>
                    <input type="text" id="cliente-first-name" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Primer Nombre" required>
                </div>
                <div>
                    <label for="cliente-last-name" class="block text-gray-700 text-sm font-bold mb-2 uppercase">APELLIDO</label>
                    <input type="text" id="cliente-last-name" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Apellido" required>
                </div>
                <div class="md:col-span-2">
                    <label for="cliente-email" class="block text-gray-700 text-sm font-bold mb-2 uppercase">EMAIL</label>
                    <input type="email" id="cliente-email" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="email@ejemplo.com">
                </div>
                <div>
                    <label for="cliente-phone" class="block text-gray-700 text-sm font-bold mb-2 uppercase">TELÉFONO FIJO</label>
                    <input type="tel" id="cliente-phone" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="(XXX) XXX-XXXX">
                </div>
                <div>
                    <label for="cliente-mobile" class="block text-gray-700 text-sm font-bold mb-2 uppercase">CELULAR</label>
                    <input type="tel" id="cliente-mobile" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="(XXX) XXX-XXXX">
                </div>

                <div class="md:col-span-2 mb-4">
                    <label for="cliente-servicio-search" class="block text-gray-700 text-sm font-bold mb-2 uppercase">AÑADIR SERVICIO</label>
                    <div class="relative">
                        <input type="text" id="cliente-servicio-search" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Buscar Servicio...">
                        <div id="service-search-results" class="absolute z-10 w-full bg-white border border-gray-300 rounded-lg shadow-lg mt-1 max-h-40 overflow-y-auto hidden">
                        </div>
                    </div>
                    <div id="selected-services-container" class="mt-2 flex flex-wrap gap-2">
                        <p class="text-gray-500 text-sm italic">Ningún servicio seleccionado.</p>
                    </div>
                    <input type="hidden" id="cliente-servicios" name="servicios_seleccionados" value="">
                </div>
                <div class="col-span-1">
                    <label for="cliente-ciudad" class="block text-gray-700 text-sm font-bold mb-2 uppercase">CIUDAD</label>
                    <input type="text" id="cliente-ciudad" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. Springfield">
                </div>
                <div class="col-span-1">
                    <label for="cliente-estado-field" class="block text-gray-700 text-sm font-bold mb-2 uppercase">ESTADO</label>
                    <input type="text" id="cliente-estado-field" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. IL">
                </div>
            </div>
        </form>
        <div class="flex justify-end space-x-4 pt-6 flex-shrink-0">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closePanel('addClientePanel')">CANCELAR</button>
            <button type="submit" form="add-cliente-form" class="btn-secondary font-bold py-2 px-4 rounded-lg uppercase">GUARDAR CLIENTE</button>
        </div>
    </div>
</div>

<div id="viewClienteReadOnlyPanel" class="fixed inset-y-0 right-0 w-full md:w-1/2 bg-white shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out z-50 overflow-y-auto">
    <div class="p-8 flex flex-col h-full">
        <div class="flex justify-between items-center mb-6 flex-shrink-0">
            <h3 class="text-2xl font-bold text-[var(--color-primary)] text-center w-full flex items-center justify-center gap-2 uppercase">
                <i data-lucide="user-circle" class="w-6 h-6 text-[var(--color-primary)]"></i> FICHA DEL CLIENTE
            </h3>
            <button onclick="closePanel('viewClienteReadOnlyPanel')" class="text-gray-400 hover:text-gray-600"><i data-lucide="x" class="w-6 h-6"></i></button>
        </div>

        <div class="flex-grow overflow-y-auto pr-2 -mr-2">
            <h2 id="readonly-cliente-full-name" class="text-4xl font-extrabold text-gray-900 mb-6 text-center uppercase"></h2>
            
            <div class="bg-gray-50 p-6 rounded-lg mb-6">
                <h3 class="text-lg font-bold text-gray-700 mb-4 flex items-center gap-2 uppercase">
                    <i data-lucide="contact" class="w-6 h-6 text-[var(--color-primary)]"></i> INFORMACIÓN DE CONTACTO
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div id="readonly-cliente-email-group" class="flex items-center text-gray-700 text-base">
                        <i data-lucide="mail" class="w-5 h-5 text-gray-500 mr-2 flex-shrink-0"></i>
                        <p id="readonly-cliente-email" class="font-medium break-all"></p>
                    </div>
                    <div id="readonly-cliente-phone-group" class="flex items-center text-gray-700 text-base">
                        <i data-lucide="phone" class="w-5 h-5 text-gray-500 mr-2 flex-shrink-0"></i>
                        <p id="readonly-cliente-phone" class="font-medium"></p>
                    </div>
                    <div id="readonly-cliente-mobile-group" class="flex items-center text-gray-700 text-base">
                        <i data-lucide="smartphone" class="w-5 h-5 text-gray-500 mr-2 flex-shrink-0"></i>
                        <p id="readonly-cliente-mobile" class="font-medium"></p>
                    </div>
                    <div id="readonly-cliente-address-group" class="md:col-span-2 flex items-start text-gray-700 text-base">
                        <i data-lucide="map-pin" class="w-5 h-5 text-gray-500 mr-2 flex-shrink-0 mt-1"></i>
                        <p id="readonly-cliente-full-address" class="font-medium"></p>
                    </div>
                </div>
            </div>

            <div class="bg-gray-50 p-6 rounded-lg mb-6">
                <h3 class="text-lg font-bold text-gray-700 mb-4 flex items-center gap-2 uppercase">
                    <i data-lucide="package" class="w-6 h-6 text-[var(--color-primary)]"></i> SERVICIOS CONTRATADOS
                </h3>
                <div id="readonly-cliente-services-display" class="flex flex-wrap gap-2 text-gray-700 text-base">
                    <p class="text-gray-500 text-sm italic">Ningún Servicio Asignado.</p>
                </div>
            </div>
            <div class="h-4"></div>
        </div>

        <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6 flex-shrink-0">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" id="edit-client-from-readonly-btn">EDITAR CLIENTE</button>
            <button type="button" class="btn-primary font-bold py-2 px-4 rounded-lg uppercase" onclick="closePanel('viewClienteReadOnlyPanel')">CERRAR</button>
        </div>
    </div>
</div>

<div id="viewClientePanel" class="fixed inset-y-0 right-0 w-full md:w-1/2 bg-white shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out z-50 overflow-y-auto">
    <div class="p-8 flex flex-col h-full">
        <div class="flex justify-between items-center mb-6 flex-shrink-0">
            <h3 class="text-2xl font-bold text-[var(--color-primary)]">EDITAR CLIENTE</h3>
            <button onclick="closePanel('viewClientePanel')" class="text-gray-400 hover:text-gray-600"><i data-lucide="x" class="w-6 h-6"></i></button>
        </div>
        <form id="view-cliente-form" class="flex-grow overflow-y-auto pr-2 -mr-2">
            <input type="hidden" id="view-cliente-id">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-4">
                <div>
                    <label for="view-cliente-first-name" class="block text-gray-700 text-sm font-bold mb-2 uppercase">NOMBRE</label>
                    <input type="text" id="view-cliente-first-name" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Primer Nombre">
                </div>
                <div>
                    <label for="view-cliente-last-name" class="block text-gray-700 text-sm font-bold mb-2 uppercase">APELLIDO</label>
                    <input type="text" id="view-cliente-last-name" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Apellido">
                </div>
                <div class="md:col-span-2">
                    <label for="view-cliente-email" class="block text-gray-700 text-sm font-bold mb-2 uppercase">EMAIL</label>
                    <input type="email" id="view-cliente-email" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="email@ejemplo.com">
                </div>
                <div>
                    <label for="view-cliente-phone" class="block text-gray-700 text-sm font-bold mb-2 uppercase">TELÉFONO FIJO</label>
                    <input type="tel" id="view-cliente-phone" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="(XXX) XXX-XXXX">
                </div>
                <div>
                    <label for="view-cliente-mobile" class="block text-gray-700 text-sm font-bold mb-2 uppercase">CELULAR</label>
                    <input type="tel" id="view-cliente-mobile" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="(XXX) XXX-XXXX">
                </div>

                <div class="md:col-span-2 mb-4">
                    <label for="view-cliente-servicio-search" class="block text-gray-700 text-sm font-bold mb-2 uppercase">EDITAR SERVICIOS</label>
                    <div class="relative">
                        <input type="text" id="view-cliente-servicio-search" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Buscar Servicio...">
                        <div id="view-service-search-results" class="absolute z-10 w-full bg-white border border-gray-300 rounded-lg shadow-lg mt-1 max-h-40 overflow-y-auto hidden">
                        </div>
                    </div>
                    <div id="view-selected-services-container" class="mt-2 flex flex-wrap gap-2">
                        <p class="text-gray-500 text-sm italic">Ningún Servicio Seleccionado</p>
                    </div>
                    <input type="hidden" id="view-cliente-servicios" name="servicios_seleccionados" value="">
                </div>
                <div class="col-span-1">
                    <label for="view-cliente-ciudad" class="block text-gray-700 text-sm font-bold mb-2 uppercase">CIUDAD</label>
                    <input type="text" id="view-cliente-ciudad" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. Springfield">
                </div>
                <div class="col-span-1">
                    <label for="view-cliente-estado-field" class="block text-gray-700 text-sm font-bold mb-2 uppercase">ESTADO</label>
                    <input type="text" id="view-cliente-estado-field" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. IL">
                </div>
            </div>
        </form>
        <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6 flex-shrink-0">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closePanel('viewClientePanel')">CANCELAR</button>
            <button type="submit" form="view-cliente-form" class="btn-primary font-bold py-2 px-4 rounded-lg uppercase">GUARDAR CAMBIOS</button>
        </div>
    </div>
</div>

<div id="confirmDeleteModal" class="fixed inset-0 bg-gray-900 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white p-8 rounded-xl shadow-2xl w-full max-w-sm m-4 transform transition-all duration-300 scale-95 opacity-0 =">
        <div class="flex justify-center mb-4">
            <i data-lucide="alert-triangle" class="w-16 h-16 text-red-500"></i>
        </div>
        <h3 class="text-2xl font-bold text-[var(--color-primary)] mb-4 uppercase">CONFIRMAR ELIMINACIÓN</h3>
        <p class="text-gray-700 mb-6 uppercase">¿ESTÁS SEGURO DE QUE DESEAS ELIMINAR ESTE <span id="confirm-item-type" class="font-semibold">ELEMENTO</span>? ESTA ACCIÓN NO SE PUEDE DESHACER.</p>
        <div class="flex justify-center space-x-4">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closeModal('confirmDeleteModal')">CANCELAR</button>
            <button type="button" class="btn-secondary font-bold py-2 px-4 rounded-lg uppercase" id="confirm-delete-button">CONFIRMAR</button>
        </div>
    </div>
</div>

<script>
// Variables globales para los datos (ahora cargados de la DB vía PHP inicial)
let clientsFromDB = <?php echo $clients_json; ?>;
let availableServices = <?php echo $available_services_json; ?>;

// Nuevas variables para los contadores de clientes (inicializadas con datos de PHP)
let totalClientsCount = <?php echo $total_clients_count_json; ?>;
let monthlyClientsCount = <?php echo $monthly_clients_count_json; ?>;
// Datos de meses con clientes para el filtro
const monthsWithClients = <?php echo $months_with_clients_json; ?>;
// Mes y año actualmente seleccionados (o por defecto el actual)
let selectedMonth = <?php echo $selected_month_js; ?>;
let selectedYear = <?php echo $selected_year_js; ?>;


// Referencias a elementos DOM
const mobileMenuButton = document.getElementById('mobile-menu-button');    
const sidebar = document.getElementById('sidebar'); // ¡IMPORTANTE! Asegúrate de que tu menu.php contenga un <aside id="sidebar">
const sidebarOverlay = document.getElementById('sidebar-overlay');
const clientSearch = document.getElementById('client-search');
const clientFilterApellidoLetter = document.getElementById('client-filter-apellido-letter');
const clientFilterService = document.getElementById('client-filter-service');
const recentClientsGrid = document.getElementById('recent-clients-grid');
const clientGridView = document.getElementById('client-grid-view');
const clientListView = document.getElementById('client-list-view');
const clientsTableBody = document.getElementById('clientsTableBody');

const gridViewBtn = document.getElementById('grid-view-btn');
const listViewBtn = document.getElementById('list-view-btn');
const downloadClientesBtn = document.getElementById('download-clientes-btn');
const confirmDeleteButton = document.getElementById('confirm-delete-button');
const confirmItemTypeSpan = document.getElementById('confirm-item-type');

// Referencia a los nuevos paneles
const addClientePanel = document.getElementById('addClientePanel');
const viewClienteReadOnlyPanel = document.getElementById('viewClienteReadOnlyPanel');
const viewClientePanel = document.getElementById('viewClientePanel');


const addClienteForm = document.getElementById('add-cliente-form');
const viewClienteForm = document.getElementById('view-cliente-form');

// Botón para editar desde el modal de solo lectura
const editClientFromReadonlyBtn = document.getElementById('edit-client-from-readonly-btn');

// Nuevas constantes para el buscador de servicios (autocomplete) en el panel de AÑADIR
const clienteServicioSearchInput = document.getElementById('cliente-servicio-search');
const serviceSearchResultsDiv = document.getElementById('service-search-results');
const selectedServicesContainer = document.getElementById('selected-services-container');
const clienteServiciosHiddenInput = document.getElementById('cliente-servicios'); // Hidden input para enviar los IDs

let selectedServiceIds = new Set(); // Para mantener un seguimiento de los IDs de servicios seleccionados en el panel de AÑADIR

// Nuevas constantes para el buscador de servicios (autocomplete) en el panel de EDITAR
const viewClienteServicioSearchInput = document.getElementById('view-cliente-servicio-search');
const viewServiceSearchResultsDiv = document.getElementById('view-service-search-results');
const viewSelectedServicesContainer = document.getElementById('view-selected-services-container');
const viewClienteServiciosHiddenInput = document.getElementById('view-cliente-servicios'); // Hidden input para enviar los IDs

let viewSelectedServiceIds = new Set(); // Para mantener un seguimiento de los IDs de servicios seleccionados en el panel de EDITAR


// Referencias a los nuevos elementos de conteo y el nuevo filtro mensual
const totalClientsCountElement = document.getElementById('total-clients-count');
const monthlyClientsCountElement = document.getElementById('monthly-clients-count');
const monthlyPeriodDisplay = document.getElementById('monthly-period-display'); // Para el nombre del mes/año
const monthlyFilterSelect = document.getElementById('monthly-filter-select'); // El nuevo select

let currentClientView = 'grid'; // Define la vista predeterminada

// Variable para guardar el ID del cliente actual abierto en el panel de solo lectura
let currentReadOnlyClientId = null;

// Elemento de overlay para los paneles laterales (creado dinámicamente si no existe)
let panelOverlay = document.getElementById('panel-overlay');
if (!panelOverlay) {
    panelOverlay = document.createElement('div');
    panelOverlay.id = 'panel-overlay';
    panelOverlay.className = 'fixed inset-0 bg-black bg-opacity-50 z-40 hidden'; // z-40 para estar sobre el contenido principal
    document.body.appendChild(panelOverlay);
}

// --- FUNCIONES HELPER GLOBALES ---

// Define una paleta de colores para las etiquetas de servicio
const serviceTagColors = [
    { bg: 'bg-blue-100', text: 'text-blue-800' },
    { bg: 'bg-green-100', text: 'text-green-800' },
    { bg: 'bg-purple-100', text: 'text-purple-800' },
    { bg: 'bg-yellow-100', text: 'text-yellow-800' },
    { bg: 'bg-pink-100', text: 'text-pink-800' },
    { bg: 'bg-indigo-100', text: 'text-indigo-800' },
    { bg: 'bg-red-100', text: 'text-red-800' },
    { bg: 'bg-gray-100', text: 'text-gray-800' }
];

// Función para obtener colores consistentes para las etiquetas de servicio
function getServiceTagColors(serviceName) {
    let hash = 0;
    for (let i = 0; i < serviceName.length; i++) {
        hash = serviceName.charCodeAt(i) + ((hash << 5) - hash);
    }
    const index = Math.abs(hash) % serviceTagColors.length;
    return serviceTagColors[index];
}

// Muestra una notificación temporal en la pantalla (como un "toast")
window.showCustomNotification = function(message, type = 'info', duration = 3000) {
    const notificationElement = document.getElementById('toastNotification');
    const notificationMessage = document.getElementById('toastMessage');
    const notificationIcon = document.getElementById('toastIcon');
    const notificationCloseBtn = document.getElementById('toastCloseBtn');
    let notificationTimeout;

    if (!notificationElement || !notificationMessage || !notificationIcon || !notificationCloseBtn) {
        console.error('Elementos de notificación no encontrados para showCustomNotification. No se puede mostrar/registrar.');
        console.log(`[NOTIFICACION - FALLBACK] ${type}: ${message}`);
        return;
    }

    clearTimeout(notificationTimeout); // Limpiar cualquier temporizador existente
    notificationElement.className = 'toast-notification'; // Resetear clases
    notificationIcon.className = 'fas'; // Resetear icono base

    notificationMessage.textContent = message;
    notificationElement.classList.add(type === 'success' ? 'success' : 'error'); // Asumiendo solo 'success'/'error' para el color del toast

    // Configurar icono según el tipo (Font Awesome)
    if (type === 'success') {
        notificationIcon.classList.add('fa-check-circle');
    } else {
        notificationIcon.classList.add('fa-exclamation-circle');
    }

    notificationElement.classList.add('show');
    notificationTimeout = setTimeout(() => {
        notificationElement.classList.remove('show');
    }, duration);

    // Asegurarse de que el listener de cierre esté siempre activo
    notificationCloseBtn.onclick = () => {
        clearTimeout(notificationTimeout);
        notificationElement.classList.remove('show');
    };

    // Registrar en consola también
    if (type === 'error') { console.error(`[NOTIFICACION - ERROR] ${message}`); }
    else if (type === 'warning') { console.warn(`[NOTIFICACION - ALERTA] ${message}`); }
    else { console.log(`[NOTIFICACION - INFO] ${message}`); }
};

// Abre un panel lateral (incluye lógica de inicialización para formularios y gestión de overlays)
window.openPanel = function(panelId) {
    const panel = document.getElementById(panelId);
    if (!panel) { console.error(`Error: Panel con ID "${panelId}" no encontrado.`); return; }
    
    // Cierra cualquier otro panel que pueda estar abierto para evitar superposición
    ['addClientePanel', 'viewClientePanel', 'viewClienteReadOnlyPanel'].forEach(id => {
        const otherPanel = document.getElementById(id);
        if (otherPanel && id !== panelId && !otherPanel.classList.contains('hidden')) {
            otherPanel.classList.add('translate-x-full');
            setTimeout(() => otherPanel.classList.add('hidden'), 300); // Ocultar después de la transición
        }
    });
    
    // Asegúrate de cerrar el sidebar si está abierto al abrir un panel
    if (sidebar && !sidebar.classList.contains('-translate-x-full')) {
        sidebar.classList.add('-translate-x-full');
    }
    sidebarOverlay.classList.add('hidden'); // Siempre ocultar el overlay del sidebar si un panel se abre

    panel.classList.remove('hidden'); // Asegura que el panel sea visible para la transición
    setTimeout(() => { // Pequeño delay para que la transición funcione
        panel.classList.remove('translate-x-full');
        panelOverlay.classList.remove('hidden'); // Muestra el overlay para el panel
    }, 50);
    
    console.log(`[clients.php] Panel ${panelId} abierto.`);

    // Lógica específica para el panel de agregar cliente
    if (panelId === 'addClientePanel') {
        addClienteForm.reset(); // Asegura que el formulario esté limpio al abrir
        clienteServicioSearchInput.value = '';
        serviceSearchResultsDiv.innerHTML = '';
        serviceSearchResultsDiv.classList.add('hidden');
        selectedServiceIds.clear(); // Limpiar servicios seleccionados
        renderSelectedServices(selectedServiceIds, selectedServicesContainer, clienteServiciosHiddenInput); // Restaurar mensaje
        applyPhoneFormatToInputs(); // Aplica el formato a los inputs del nuevo panel
    }
    lucide.createIcons({ container: panel }); // Re-render Lucide icons inside the opened panel
};

// Cierra un panel lateral
window.closePanel = function(panelId) {
    const panel = document.getElementById(panelId);
    if (!panel) { console.error(`Error: Panel con ID "${panelId}" no encontrado para cerrar.`); return; }
    panel.classList.add('translate-x-full');
    // Oculta el overlay si no hay otros paneles visibles (después de la transición)
    setTimeout(() => {
        panel.classList.add('hidden');
        // Comprobar si *todos* los paneles están cerrados antes de ocultar el overlay
        const anyPanelOpen = ['addClientePanel', 'viewClientePanel', 'viewClienteReadOnlyPanel'].some(id => {
            const p = document.getElementById(id);
            return p && !p.classList.contains('hidden');
        });
        if (!anyPanelOpen) {
            panelOverlay.classList.add('hidden');
        }
    }, 300); // Duración de la transición
    console.log(`[clients.php] Panel ${panelId} cerrado.`);
};

// Abre un modal (solo para confirmDeleteModal)
window.openModal = function(modalId) {
    const modal = document.getElementById(modalId);
    if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado.`); return; }
    const modalBox = modal.querySelector('div:first-of-type');
    modal.classList.remove('hidden');
    setTimeout(() => { modalBox.classList.remove('scale-95', 'opacity-0'); }, 50);
    console.log(`[clients.php] Modal ${modalId} abierto.`);
    lucide.createIcons({ container: modal });
};

// Cierra un modal (solo para confirmDeleteModal)
window.closeModal = function(modalId) {
    const modal = document.getElementById(modalId);
    if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado para cerrar.`); return; }
    const modalBox = modal.querySelector('div:first-of-type');
    modalBox.classList.add('scale-95', 'opacity-0');
    setTimeout(() => { modal.classList.add('hidden'); }, 300);
    console.log(`[clients.php] Modal ${modalId} cerrado.`);
};

// Abre el modal de confirmación de eliminación (sin cambios)
window.openConfirmDeleteModal = function(itemId, itemType) {
    if (!confirmDeleteButton || !confirmItemTypeSpan) { console.error("Error: Elementos del modal de confirmación de eliminación no encontrados."); return; }
    confirmDeleteButton.dataset.itemId = itemId; confirmDeleteButton.dataset.itemType = itemType;
    confirmItemTypeSpan.textContent = itemType.toUpperCase();
    openModal('confirmDeleteModal');
};

// RENOMBRADA Y MODIFICADA: Esta función ahora abre el PANEL de edición
window.openEditClienteModal = function(clientId) {
    const client = clientsFromDB[`client-${clientId}`]; // Acceder por la clave de string
    if (!client) { console.error('Cliente no encontrado:', clientId); return; }

    const fields = [
        { id: 'view-cliente-id', prop: 'id' },
        { id: 'view-cliente-first-name', prop: 'nombre' },
        { id: 'view-cliente-last-name', prop: 'apellido' },
        { id: 'view-cliente-email', prop: 'email' },
        { id: 'view-cliente-phone', prop: 'phone' },
        { id: 'view-cliente-mobile', prop: 'mobile' },
        { id: 'view-cliente-ciudad', prop: 'ciudad' },
        { id: 'view-cliente-estado-field', prop: 'estado' }, // Propiedad cambiada a 'estado'
    ];

    fields.forEach(field => {
        const element = document.getElementById(field.id);
        if (element) {
            // Si el valor es null, establecerlo como cadena vacía para el input
            element.value = client[field.prop] === null ? '' : client[field.prop];
        } else {
            console.error(`ERROR: Elemento DOM con ID "${field.id}" (propiedad: ${field.prop}) no encontrado al abrir panel de EDICIÓN. La página HTML podría estar incompleta o mal formada.`);
        }
    });

    // Cargar y renderizar los servicios seleccionados para el panel de edición
    viewSelectedServiceIds.clear(); // Limpiar selecciones anteriores
    // Asegurarse de que client.service_ids es un array antes de iterar
    if (client.service_ids && Array.isArray(client.service_ids)) {
        client.service_ids.forEach(id => viewSelectedServiceIds.add(id));
    }
    renderSelectedServices(viewSelectedServiceIds, viewSelectedServicesContainer, viewClienteServiciosHiddenInput); // Reutilizar la función de renderizado

    // Al abrir el panel de edición, cierra el panel de solo lectura si está abierto
    closePanel('viewClienteReadOnlyPanel');
    openPanel('viewClientePanel');
    // Aplicar el formato a los inputs del panel de edición
    setTimeout(applyPhoneFormatToInputs, 100);
    console.log(`[clients.php] Abriendo panel de edición para cliente ID: ${clientId}.`);
};

// MODIFICADO: Ahora abre un PANEL de detalles de cliente (Solo Lectura)
window.openClientDetailsModal = function(clientId) {
    const client = clientsFromDB[`client-${clientId}`]; // Acceder por la clave de string
    if (!client) { console.error('Cliente no encontrado:', clientId); return; }

    currentReadOnlyClientId = clientId; // Guarda el ID para el botón de editar

    // Set Full Name
    const fullNameElement = document.getElementById('readonly-cliente-full-name');
    if (fullNameElement) {
        fullNameElement.textContent = `${client.nombre || ''} ${client.apellido || ''}`.trim().toUpperCase();
    } else {
        console.error(`ERROR: Elemento DOM con ID "readonly-cliente-full-name" no encontrado.`);
    }

    // Set Email
    const emailElement = document.getElementById('readonly-cliente-email');
    const emailGroup = document.getElementById('readonly-cliente-email-group');
    if (emailElement && emailGroup) {
        if (client.email) {
            emailElement.textContent = client.email;
            emailGroup.classList.remove('hidden');
        } else {
            emailGroup.classList.add('hidden');
        }
    }

    // Set Phone (Fixed) - formateado para visualización
    const phoneElement = document.getElementById('readonly-cliente-phone');
    const phoneGroup = document.getElementById('readonly-cliente-phone-group');
    if (phoneElement && phoneGroup) {
        if (client.phone) {
            phoneElement.textContent = formatPhoneNumber(client.phone); // Aplica formato
            phoneGroup.classList.remove('hidden');
        } else {
            phoneGroup.classList.add('hidden');
        }
    }

    // Set Mobile Phone - formateado para visualización
    const mobileElement = document.getElementById('readonly-cliente-mobile');
    const mobileGroup = document.getElementById('readonly-cliente-mobile-group');
    if (mobileElement && mobileGroup) {
        if (client.mobile) {
            mobileElement.textContent = formatPhoneNumber(client.mobile); // Aplica formato
            mobileGroup.classList.remove('hidden');
        } else {
            mobileGroup.classList.add('hidden');
        }
    }

    // Set Full Address (Modificado)
    const fullAddressElement = document.getElementById('readonly-cliente-full-address');
    const addressGroup = document.getElementById('readonly-cliente-address-group');
    if (fullAddressElement && addressGroup) {
        const addressParts = [];
        // Solo añadir a las partes si el valor no es null o vacío
        if (client.ciudad) addressParts.push(client.ciudad);
        if (client.estado) addressParts.push(client.estado); // Usa 'estado'

        if (addressParts.length > 0) {
            fullAddressElement.textContent = addressParts.join(', ').toUpperCase();
            addressGroup.classList.remove('hidden');
        } else {
            addressGroup.classList.add('hidden');
        }
    }

    // Mostrar servicios contratados en el panel de solo lectura
    const readonlyServicesDisplay = document.getElementById('readonly-cliente-services-display');
    if (readonlyServicesDisplay) {
        readonlyServicesDisplay.innerHTML = ''; // Limpiar anteriores
        // Asegurarse de que client.service_ids es un array antes de iterar
        if (client.service_ids && Array.isArray(client.service_ids) && client.service_ids.length > 0) {
            client.service_ids.forEach(serviceId => {
                const service = availableServices.find(s => s.id === serviceId);
                if (service) {
                    const serviceTag = document.createElement('span');
                    serviceTag.className = 'inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-indigo-100 text-indigo-800';
                    serviceTag.textContent = service.name.toUpperCase();
                    readonlyServicesDisplay.appendChild(serviceTag);
                }
            });
        } else {
            readonlyServicesDisplay.innerHTML = '<p class="text-gray-500 text-sm italic">Ningún Servicio Asignado.</p>';
        }
    }

    lucide.createIcons({ container: viewClienteReadOnlyPanel }); // Asegura que los íconos del panel se muestren
    openPanel('viewClienteReadOnlyPanel');
    console.log(`[clients.php] Abriendo panel de detalles (solo lectura) para cliente ID: ${clientId}.`);
};


// Configura los listeners para botones de eliminar
function setupDeleteListeners() {
    document.querySelectorAll('.delete-btn').forEach(button => {
        button.removeEventListener('click', handleDeleteButtonClick); // Evita duplicados
        button.addEventListener('click', handleDeleteButtonClick);
    });
    console.log("[clients.php] Listeners de eliminar configurados.");
}
function handleDeleteButtonClick(e) {
    e.stopPropagation();
    const itemId = this.dataset.itemId; const itemType = this.dataset.itemType;
    openConfirmDeleteModal(itemId, itemType);
    console.log(`[clients.php] Click en botón eliminar: ${itemType} ID: ${itemId}.`);
}

// Configura los listeners para botones de ver/editar
function setupDetailAndEditListeners() {
    // Para tarjetas (vista de cuadrícula) y el nombre en la lista
    document.querySelectorAll('.edit-client-btn').forEach(button => {
        button.removeEventListener('click', handleClientDetailsClick); // Evita duplicados
        button.addEventListener('click', handleClientDetailsClick);
    });
    document.querySelectorAll('.client-name-link').forEach(link => {
        link.removeEventListener('click', handleClientDetailsClick); // Evita duplicados
        link.addEventListener('click', handleClientDetailsClick);
    });
    console.log("[clients.php] Listeners de detalles/edición configurados.");
}

// Manejador para abrir el panel de solo lectura
function handleClientDetailsClick(e) {
    e.stopPropagation();
    const clientId = this.dataset.clientId || this.closest('[data-client-id]').dataset.clientId;
    openClientDetailsModal(clientId); // Llama a la nueva función de solo lectura (que abre el panel)
    console.log(`[clients.php] Click en elemento de detalles para cliente ID: ${clientId}.`);
}


// Alterna la visibilidad de la barra lateral (MODIFICADO PARA MANEJAR Z-INDEX Y OVERLAYS CORRECTAMENTE)
function toggleSidebar() {
    if (sidebar) {
        sidebar.classList.toggle('-translate-x-full');
        if (!sidebar.classList.contains('-translate-x-full')) {
            // Sidebar se está abriendo
            sidebarOverlay.classList.remove('hidden');
            // Ocultar panelOverlay si el sidebar se superpone
            panelOverlay.classList.add('hidden'); 
        } else {
            // Sidebar se está cerrando
            sidebarOverlay.classList.add('hidden');
            // Restaurar panelOverlay si hay un panel abierto
            const anyPanelOpen = ['addClientePanel', 'viewClientePanel', 'viewClienteReadOnlyPanel'].some(id => {
                const p = document.getElementById(id);
                return p && !p.classList.contains('hidden');
            });
            if (anyPanelOpen) {
                panelOverlay.classList.remove('hidden');
            }
        }
    }
    console.log(`[clients.php] Sidebar toggled. Hidden: ${sidebar.classList.contains('-translate-x-full')}`);
}


// Obtiene la inicial del apellido para los avatares
function getLastNameInitial(fullName) {
    const parts = fullName.trim().split(' ');
    if (parts.length > 1) {
        let lastName = parts[parts.length - 1];
        if (['jr.', 'sr.', 'ii', 'iii', 'iv', 'v'].includes(lastName.toLowerCase().replace('.', ''))) {
            lastName = parts[parts.length - 2] || lastName;
        }
        return lastName.charAt(0).toUpperCase();
    }
    return fullName.charAt(0).toUpperCase();
}

// Renderiza una tarjeta de cliente para la vista de cuadrícula
function renderClientCard(client) {
    const card = document.createElement('div');
    card.className = 'client-card bg-white rounded-xl p-6 flex flex-col items-center text-center shadow-sm';
    card.dataset.clientId = client.id;
    card.dataset.itemId = client.id;

    const displayFirstName = client.nombre || '';
    const displayLastName = client.apellido || '';
    const initial = (displayFirstName.charAt(0) || '').toUpperCase();
    const fullName = `${displayFirstName} ${displayLastName}`.trim();

    // Generar las etiquetas de servicio para la tarjeta
    // Usar ?? [] para asegurar que service_ids es un array si es null/undefined
    const servicesList = (client.service_ids && Array.isArray(client.service_ids)) ?
        client.service_ids.map(id => availableServices.find(s => s.id === id)?.name).filter(Boolean) : [];
    let servicesHtml = '';
    if (servicesList.length > 0) {
        servicesList.forEach(serviceName => {
            const colors = getServiceTagColors(serviceName);
            servicesHtml += `<span class="inline-block ${colors.bg} ${colors.text} py-0.5 px-2 rounded-full text-xs font-semibold uppercase mr-1 mb-1">${serviceName}</span>`;
        });
    } else {
        servicesHtml = '<p class="text-gray-500 text-sm italic">SIN SERVICIOS</p>';
    }

    card.innerHTML = `
        <div class="client-avatar rounded-full flex items-center justify-center mb-4">
            <span>${initial}</span>
        </div>
        <h4 class="font-bold text-lg text-gray-800 uppercase">${fullName}</h4>
        <p class="text-xs text-gray-500 mb-2 uppercase">${client.email || 'N/A'}</p>
        <div class="mb-4 flex flex-wrap justify-center">
            ${servicesHtml}
        </div>
        <div class="flex space-x-3 mt-auto w-full">
            <button class="flex-1 bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-3 rounded-lg text-xs edit-client-btn uppercase" data-client-id="${client.id}">VER DETALLES</button>
            <button class="p-2 bg-red-100 hover:bg-red-200 text-red-600 rounded-lg delete-btn" data-item-type="cliente" data-item-id="${client.id}" title="ELIMINAR CLIENTE"><i data-lucide="trash-2" class="w-4 h-4"></i></button>
        </div>
    `;
    return card;
}

// Renderiza una fila de tabla para la vista de lista
function renderClientTableRow(client) {
    const row = document.createElement('tr');
    row.className = 'border-b border-gray-200 hover:bg-gray-50';
    row.dataset.clientId = client.id;
    row.dataset.itemId = client.id;

    const displayFirstName = client.nombre || '';
    const displayLastName = client.apellido || '';
    const fullName = `${displayFirstName} ${displayLastName}`.trim();

    // Muestra el teléfono o el celular formateado
    const displayPhone = formatPhoneNumber(client.phone) || formatPhoneNumber(client.mobile) || 'N/A';

    // Generar las etiquetas de servicio para la fila de tabla
    const servicesList = (client.service_ids && Array.isArray(client.service_ids)) ?
        client.service_ids.map(id => availableServices.find(s => s.id === id)?.name).filter(Boolean) : [];
    let servicesHtml = '';
    if (servicesList.length > 0) {
        servicesList.forEach(serviceName => {
            const colors = getServiceTagColors(serviceName);
            servicesHtml += `<span class="inline-block ${colors.bg} ${colors.text} py-0.5 px-2 rounded-full text-xs font-semibold uppercase mr-1 mb-1">${serviceName}</span>`;
        });
    } else {
        servicesHtml = '<p class="text-gray-500 text-sm italic">SIN SERVICIOS</p>';
    }

    row.innerHTML = `
        <td class="py-4 px-6 whitespace-nowrap">
            <span class="text-blue-600 hover:text-blue-800 cursor-pointer font-semibold uppercase client-name-link" data-client-id="${client.id}">${fullName}</span>
        </td>
        <td class="py-4 px-6 hidden md:table-cell uppercase">${client.email || 'N/A'}</td>
        <td class="py-4 px-6 hidden lg:table-cell uppercase">${displayPhone}</td>
        <td class="py-4 px-6 flex flex-wrap">${servicesHtml}</td>
        <td class="py-4 px-6 text-center">
            <button class="text-blue-600 hover:text-blue-800 mr-3 edit-client-btn" data-client-id="${client.id}" title="VER DETALLES"><i data-lucide="eye" class="w-5 h-5"></i></button>
            <button class="text-red-600 hover:text-red-800 delete-btn" data-item-type="cliente" data-item-id="${client.id}" title="ELIMINAR CLIENTE"><i data-lucide="trash-2" class="w-4 h-4"></i></button>
        </td>
    `;
    return row;
}

// Popula el filtro por la primera letra del apellido
function populateApellidoLetterFilter() {
    const initials = new Set();
    // Usar Object.values para iterar sobre los objetos de clientes
    Object.values(clientsFromDB).forEach(client => { 
        if (client.apellido) {
            initials.add(client.apellido.charAt(0).toUpperCase());
        } else if (client.nombre) { 
            initials.add(client.nombre.charAt(0).toUpperCase());
        }
    });
    const sortedInitials = Array.from(initials).sort();

    clientFilterApellidoLetter.innerHTML = '<option value="all">TODAS LAS LETRAS</option>';
    sortedInitials.forEach(initial => {
        const option = document.createElement('option');
        option.value = initial;
        option.textContent = initial;
        clientFilterApellidoLetter.appendChild(option);
    });
    console.log("[clients.php] Filtro por letra de apellido poblado.");
}

// Popula el filtro de servicio
function populateServiceFilter() {
    clientFilterService.innerHTML = '<option value="all">TODOS LOS SERVICIOS</option>';
    availableServices.forEach(service => {
        const option = document.createElement('option');
        option.value = service.id;
        option.textContent = service.name.toUpperCase();
        clientFilterService.appendChild(option);
    });
    console.log("[clients.php] Filtro por servicio poblado con servicios reales.");
}

// Actualiza el contador total de clientes
function updateTotalClientsDisplay() {
    if (totalClientsCountElement) {
        totalClientsCountElement.textContent = Object.keys(clientsFromDB).length.toString(); // Contar clientes desde el objeto global
        console.log(`[clients.php] Total de clientes actualizado: ${totalClientsCountElement.textContent}`);
    } else {
        console.warn("[clients.php] Elemento #total-clients-count no encontrado.");
    }
}

// Actualiza el contador de clientes mensuales y el display del periodo
function updateMonthlyClientsDisplay() {
    if (monthlyClientsCountElement && monthlyPeriodDisplay) {
        let countThisMonth = 0;
        const currentMonthYear = `${selectedYear}-${String(selectedMonth).padStart(2, '0')}`;
        Object.values(clientsFromDB).forEach(client => {
            if (client.created_at) {
                const clientCreatedMonthYear = new Date(client.created_at).toISOString().slice(0, 7);
                if (clientCreatedMonthYear === currentMonthYear) {
                    countThisMonth++;
                }
            }
        });
        monthlyClientsCountElement.textContent = countThisMonth.toString();

        const monthNames = ["ENERO", "FEBRERO", "MARZO", "ABRIL", "MAYO", "JUNIO",
                             "JULIO", "AGOSTO", "SEPTIEMBRE", "OCTUBRE", "NOVIEMBRE", "DICIEMBRE"];
        if (selectedMonth >= 1 && selectedMonth <= 12) {
            monthlyPeriodDisplay.textContent = `${monthNames[selectedMonth - 1]} ${selectedYear}`;
        } else {
            monthlyPeriodDisplay.textContent = `PERIODO DESCONOCIDO`;
        }

        console.log(`[clients.php] Clientes mensuales actualizados: ${monthlyClientsCountElement.textContent} para ${monthlyPeriodDisplay.textContent}`);
    } else {
        console.warn("[clients.php] Elementos de contador mensual no encontrados.");
    }
}

// Función para poblar el nuevo filtro mensual/anual
function populateMonthlyFilter() {
    if (!monthlyFilterSelect) {
        console.warn("[clients.php] Elemento #monthly-filter-select no encontrado.");
        return;
    }

    const now = new Date();
    const currentMonthNum = now.getMonth() + 1;
    const currentYearNum = now.getFullYear();

    const uniqueMonths = new Set();
    uniqueMonths.add(`${currentYearNum}-${String(currentMonthNum).padStart(2, '0')}`);

    monthsWithClients.forEach(data => {
        // Asegurarse de que los datos de meses con clientes se agreguen correctamente
        if (data.year && data.month) {
            uniqueMonths.add(`${data.year}-${String(data.month).padStart(2, '0')}`);
        }
    });

    const sortedMonths = Array.from(uniqueMonths)
        .map(dateStr => {
            const [year, month] = dateStr.split('-').map(Number);
            return { year: year, month: month, dateObj: new Date(year, month - 1, 1) };
        })
        .sort((a, b) => {
            return b.dateObj.getTime() - a.dateObj.getTime();
        });

    monthlyFilterSelect.innerHTML = '';
    const monthNames = ["ENERO", "FEBRERO", "MARZO", "ABRIL", "MAYO", "JUNIO",
                                     "JULIO", "AGOSTO", "SEPTIEMBRE", "OCTUBRE", "NOVIEMBRE", "DICIEMBRE"];

    sortedMonths.forEach(data => {
        const option = document.createElement('option');
        option.value = `${data.year}-${String(data.month).padStart(2, '0')}`;
        option.textContent = `${monthNames[data.month - 1]} ${data.year}`;
        if (data.year === selectedYear && data.month === selectedMonth) {
            option.selected = true;
        }
        monthlyFilterSelect.appendChild(option);
    });
    console.log("[clients.php] Filtro mensual poblado.");
}

// Función para recargar los datos desde la base de datos (después de una operación CRUD)
const fetchClients = async () => {
    try {
        const response = await fetch(`db/clients-read.php?year=${selectedYear}&month=${selectedMonth}`);
        const result = await response.json();

        if (result.success && result.data) {
            clientsFromDB = result.data;
            availableServices = result.available_services; // Actualizar servicios disponibles también
            totalClientsCount = result.total_clients_count;
            monthlyClientsCount = result.monthly_clients_count;
            // No es necesario actualizar monthsWithClients aquí si la página se recarga para el filtro mensual
            // pero si fuera AJAX puro, necesitarías un mecanismo para actualizar el dropdown de meses.
            
            updateTotalClientsDisplay();
            updateMonthlyClientsDisplay();
            populateApellidoLetterFilter(); // Actualizar el filtro de apellidos
            populateServiceFilter(); // Actualizar el filtro de servicios
            renderClients(currentClientView);
        } else {
            showCustomNotification(result.message || 'Error al cargar los clientes desde la base de datos.', 'error');
            clientsFromDB = {}; // Vaciar si hay error
            updateTotalClientsDisplay();
            updateMonthlyClientsDisplay();
            renderClients(currentClientView);
        }
    } catch (error) {
        showCustomNotification('Error de conexión al cargar los clientes.', 'error');
        console.error('Error fetching clients:', error);
        clientsFromDB = {}; // Vaciar si hay error
        updateTotalClientsDisplay();
        updateMonthlyClientsDisplay();
        renderClients(currentClientView);
    }
};


// Renderiza la lista de clientes según la vista y filtros
function renderClients(viewType = currentClientView) {
    console.log(`[clients.php] renderClients() iniciado para vista: ${viewType}.`);

    const clientGridViewElement = document.getElementById('client-grid-view');
    const clientListViewElement = document.getElementById('client-list-view');
    const clientsTableBodyElement = document.getElementById('clientsTableBody');

    if (!recentClientsGrid || !clientGridViewElement || !clientListViewElement || !clientsTableBodyElement || !clientSearch || !gridViewBtn || !listViewBtn || !clientFilterApellidoLetter || !clientFilterService) {
        console.error("[clients.php] ERROR: Algunos elementos DOM de Clientes no encontrados para renderizado. Verifique IDs."); return;
    }

    const searchTerm = clientSearch.value.toLowerCase();
    const selectedLetter = clientFilterApellidoLetter.value;
    const selectedServiceId = parseInt(clientFilterService.value);

    const allClientsArray = Object.values(clientsFromDB);

    // 1. Renderizar la sección de Últimos Clientes (siempre visible, sin filtros)
    recentClientsGrid.innerHTML = '';
    const sortedClientsByDate = [...allClientsArray].sort((a, b) => {
        const dateA = new Date(a.created_at);
        const dateB = new Date(b.created_at);
        return isNaN(dateA) ? 1 : (isNaN(dateB) ? -1 : dateB - dateA);
    });
    const recentClients = sortedClientsByDate.slice(0, 4);

    if (recentClients.length === 0) {
        recentClientsGrid.innerHTML = `<p class="text-gray-500 col-span-full text-center uppercase">NO HAY CLIENTES RECIENTES PARA MOSTRAR.</p>`;
    } else {
        recentClients.forEach(client => {
            recentClientsGrid.appendChild(renderClientCard(client));
        });
    }
    lucide.createIcons({ container: recentClientsGrid }); // Renderizar iconos específicos para esta sección

    // 2. Filtrar clientes para las vistas completas
    const filteredClients = allClientsArray.filter(c => {
        const fullName = `${c.nombre || ''} ${c.apellido || ''}`.trim().toLowerCase();
        const email = (c.email || '').toLowerCase();
        const phone = (c.phone || '').toLowerCase();
        const mobile = (c.mobile || '').toLowerCase();
        // Asegúrate de que c.servicios sea una cadena antes de llamar a toLowerCase()
        const servicesText = (c.servicios || '').toLowerCase(); 

        const matchesSearch = fullName.includes(searchTerm) || email.includes(searchTerm) || phone.includes(searchTerm) || mobile.includes(searchTerm) || servicesText.includes(searchTerm);

        const matchesLetter = selectedLetter === 'all' ||
                                         (c.apellido && c.apellido.charAt(0).toUpperCase() === selectedLetter) ||
                                         (selectedLetter === (c.nombre && c.nombre.charAt(0).toUpperCase()) && (!c.apellido || c.apellido === ''));

        const matchesService = (isNaN(selectedServiceId) || clientFilterService.value === 'all') ? true :
                                         (c.service_ids && c.service_ids.includes(selectedServiceId));

        return matchesSearch && matchesLetter && matchesService;
    });

    // 3. Renderizar la vista activa (Cuadrícula o Lista)
    clientGridViewElement.innerHTML = '';
    clientsTableBodyElement.innerHTML = '';

    if (filteredClients.length === 0) {
        const message = `<p class="text-gray-500 md:col-span-2 lg:col-span-3 text-center uppercase">NO SE ENCONTRARON CLIENTES CON LOS CRITERIOS DE BÚSQUEDA.</p>`;
        if (viewType === 'grid') {
            clientGridViewElement.innerHTML = message;
        } else { // list view
            clientsTableBodyElement.innerHTML = `<tr><td colspan="5" class="py-4 px-6 text-center text-gray-500 uppercase">NO SE ENCONTRARON CLIENTES CON LOS CRITERIOS DE BÚSQUEDA.</td></tr>`;
        }
    } else {
        if (viewType === 'grid') {
            filteredClients.forEach(client => clientGridViewElement.appendChild(renderClientCard(client)));
        } else { // list view
            filteredClients.forEach(client => clientsTableBodyElement.appendChild(renderClientTableRow(client)));
        }
    }

    if (viewType === 'grid') {
        clientGridViewElement.classList.remove('hidden');
        clientListViewElement.classList.add('hidden');
        gridViewBtn.classList.add('active');
        listViewBtn.classList.remove('active');
    } else {
        clientGridViewElement.classList.add('hidden');
        clientListViewElement.classList.remove('hidden');
        gridViewBtn.classList.remove('active');
        listViewBtn.classList.add('active');
    }

    lucide.createIcons({ container: clientGridViewElement }); // Renderizar iconos para la vista de cuadrícula
    lucide.createIcons({ container: clientsTableBodyElement }); // Renderizar iconos para la vista de lista
    setupDeleteListeners();
    setupDetailAndEditListeners();
}

// Función para renderizar los servicios que ya han sido seleccionados como "tags"
function renderSelectedServices(selectedIdsSet, containerElement, hiddenInputElement) {
    containerElement.innerHTML = '';
    const servicesArray = Array.from(selectedIdsSet);
    // Actualiza el valor del input oculto para que PHP lo reciba
    hiddenInputElement.value = servicesArray.join(',');
    if (servicesArray.length === 0) {
        containerElement.innerHTML = '<p class="text-gray-500 text-sm italic">NINGÚN SERVICIO SELECCIONADO</p>';
    } else {
        servicesArray.forEach(serviceId => {
            const service = availableServices.find(s => s.id == serviceId);
            if (service) {
                const serviceTag = document.createElement('span');
                serviceTag.className = 'inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-[var(--color-primary)] text-white gap-1';
                serviceTag.innerHTML = `
                    <span>${service.name.toUpperCase()}</span>
                    <button type="button" class="remove-service-btn text-white hover:text-gray-200 ml-1" data-service-id="${service.id}" title="Eliminar Servicio">
                        <i data-lucide="x" class="w-4 h-4"></i>
                    </button>
                `;
                containerElement.appendChild(serviceTag);
            }
        });
        lucide.createIcons({ container: containerElement }); // Re-render Lucide icons for the 'x' button
        containerElement.querySelectorAll('.remove-service-btn').forEach(button => {
            button.removeEventListener('click', handleRemoveServiceClick); // Evita duplicados
            button.addEventListener('click', handleRemoveServiceClick);
        });
    }
    console.log("[Buscador Servicios] Servicios seleccionados renderizados:", Array.from(selectedIdsSet));
}

// Manejador para eliminar un servicio de la lista de seleccionados
const handleRemoveServiceClick = (e) => {
    const serviceIdToRemove = parseInt(e.currentTarget.dataset.serviceId);
    // Determinar qué Set de IDs usar (añadir o editar)
    if (e.currentTarget.closest('#selected-services-container')) {
        selectedServiceIds.delete(serviceIdToRemove);
        renderSelectedServices(selectedServiceIds, selectedServicesContainer, clienteServiciosHiddenInput);
    } else if (e.currentTarget.closest('#view-selected-services-container')) {
        viewSelectedServiceIds.delete(serviceIdToRemove);
        renderSelectedServices(viewSelectedServiceIds, viewSelectedServicesContainer, viewClienteServiciosHiddenInput);
    }
    console.log(`[Buscador Servicios] Servicio ID ${serviceIdToRemove} eliminado.`);
};


// Función principal de búsqueda para el autocompletado de servicios
function setupServiceSearch(searchInput, resultsDiv, selectedIdsSet, containerElement, hiddenInputElement) {
    console.log(`[Buscador Servicios] Iniciando configuración del buscador para ${searchInput.id}.`);
    if (!searchInput || !resultsDiv || !availableServices) {
        console.warn(`[Buscador Servicios] Elementos del buscador de servicios o datos de servicios (availableServices) no encontrados para ${searchInput.id}. Saltando configuración.`);
        return;
    }

    const searchAndRenderResults = (query) => {
        resultsDiv.innerHTML = ''; // Limpiar resultados anteriores
        if (query.length < 1) {
            resultsDiv.classList.add('hidden');
            return;
        }

        const lowerCaseQuery = query.toLowerCase();
        // Filtrar servicios que coincidan con la búsqueda y que no estén ya seleccionados
        const filteredResults = availableServices.filter(s =>
            s.name.toLowerCase().includes(lowerCaseQuery) && !selectedIdsSet.has(s.id)
        );

        if (filteredResults.length > 0) {
            filteredResults.forEach(service => {
                const resultItem = document.createElement('div');
                resultItem.className = 'p-2 cursor-pointer hover:bg-gray-100 border-b border-gray-200 last:border-b-0 uppercase text-gray-700 text-sm';
                resultItem.textContent = service.name;
                resultItem.dataset.serviceId = service.id;
                resultItem.addEventListener('mousedown', (e) => {
                    e.preventDefault();
                    selectedIdsSet.add(service.id);
                    searchInput.value = '';
                    resultsDiv.classList.add('hidden');
                    renderSelectedServices(selectedIdsSet, containerElement, hiddenInputElement);
                    console.log(`[Buscador Servicios] Servicio seleccionado: ${service.name} (ID: ${service.id})`);
                });
                resultsDiv.appendChild(resultItem);
            });
            resultsDiv.classList.remove('hidden');
            console.log("[Buscador Servicios] Resultados mostrados.");
        } else {
            resultsDiv.classList.add('hidden');
            const noResults = document.createElement('div');
            noResults.className = 'p-2 text-gray-500 text-sm italic';
            noResults.textContent = 'No se encontraron servicios o ya están seleccionados.';
            resultsDiv.appendChild(noResults);
            resultsDiv.classList.remove('hidden');
        }
    };

    // Event Listeners para el input de búsqueda de servicios
    searchInput.addEventListener('input', (e) => {
        searchAndRenderResults(e.target.value);
    });

    searchInput.addEventListener('focus', (e) => {
        if (e.target.value.length >= 1) {
            searchAndRenderResults(e.target.value);
        }
    });

    searchInput.addEventListener('blur', () => {
        setTimeout(() => {
            resultsDiv.classList.add('hidden');
        }, 150);
    });

    // Al inicio, renderiza los servicios seleccionados
    renderSelectedServices(selectedIdsSet, containerElement, hiddenInputElement);
    console.log(`[Buscador Servicios] Buscador de servicios configurado y eventos adjuntados para ${searchInput.id}.`);
}


// Función para formatear el número de teléfono (JavaScript puro)
function formatPhoneNumber(value) {
    if (!value) return '';
    const cleaned = ('' + value).replace(/\D/g, ''); // Elimina todo lo que no sea dígito
    const match = cleaned.match(/^(\d{3})(\d{3})(\d{4})$/);
    if (match) {
        return `(${match[1]}) ${match[2]}-${match[3]}`;
    }
    return cleaned;
}

// Función para aplicar la lógica de formateo a un input específico
function applyInputPhoneFormat(inputElement) {
    if (!inputElement) return;

    // Formatea el valor inicial al cargar
    inputElement.value = formatPhoneNumber(inputElement.value);

    inputElement.addEventListener('input', (e) => {
        let value = e.target.value.replace(/\D/g, '');
        e.target.value = formatPhoneNumber(value);
    });

    inputElement.addEventListener('blur', (e) => {
        e.target.value = formatPhoneNumber(e.target.value);
    });
}

// Función para aplicar el formateo a todos los inputs de teléfono relevantes
function applyPhoneFormatToInputs() {
    applyInputPhoneFormat(document.getElementById('cliente-phone'));
    applyInputPhoneFormat(document.getElementById('cliente-mobile'));
    applyInputPhoneFormat(document.getElementById('view-cliente-phone'));
    applyInputPhoneFormat(document.getElementById('view-cliente-mobile'));
}


// --- INICIALIZACIÓN PRINCIPAL DEL DOCUMENTO ---
document.addEventListener('DOMContentLoaded', function() {
    console.log("[clients.php] DOMContentLoaded: Inicializando página de clientes.");

    // Eventos de la barra lateral (menú móvil)
    const sidebarCloseBtn = document.getElementById('sidebarCloseBtn');

    if (mobileMenuButton) mobileMenuButton.addEventListener('click', toggleSidebar);
    if (sidebarOverlay) sidebarOverlay.addEventListener('click', () => {
        toggleSidebar(); // Cierra el sidebar
        // Asegúrate de cerrar también los paneles si el overlay del sidebar los cubre
        closePanel('addClientePanel');
        closePanel('viewClientePanel');
        closePanel('viewClienteReadOnlyPanel');
    });
    
    // Listener para el overlay de los paneles (ahora maneja todos los paneles)
    // Este overlay es para los paneles laterales (agregar, ver, editar), NO para el sidebar
    if (panelOverlay) {
        panelOverlay.addEventListener('click', () => {
            closePanel('addClientePanel');
            closePanel('viewClientePanel');
            closePanel('viewClienteReadOnlyPanel');
        });
    }
    
    if (sidebarCloseBtn) sidebarCloseBtn.addEventListener('click', toggleSidebar);

    // Inicializar filtros y contadores
    populateApellidoLetterFilter();
    populateServiceFilter();
    updateTotalClientsDisplay();
    populateMonthlyFilter();
    updateMonthlyClientsDisplay();

    // Listener para el cambio del filtro mensual
    if (monthlyFilterSelect) {
        monthlyFilterSelect.addEventListener('change', function() {
            const [year, month] = this.value.split('-').map(Number);
            // Esto recargará la página con los nuevos parámetros, simulando una nueva carga de datos
            window.location.href = `clients.php?year=${year}&month=${month}`;
        });
    }

    setupServiceSearch(clienteServicioSearchInput, serviceSearchResultsDiv, selectedServiceIds, selectedServicesContainer, clienteServiciosHiddenInput);
    setupServiceSearch(viewClienteServicioSearchInput, viewServiceSearchResultsDiv, viewSelectedServiceIds, viewSelectedServicesContainer, viewClienteServiciosHiddenInput);

    renderClients(currentClientView);
    console.log("[clients.php] Clientes renderizados.");

    // Listeners para filtros y búsqueda principal
    if (clientSearch) clientSearch.addEventListener('input', () => renderClients(currentClientView));
    if (clientFilterApellidoLetter) clientFilterApellidoLetter.addEventListener('change', () => renderClients(currentClientView));
    if (clientFilterService) clientFilterService.addEventListener('change', () => renderClients(currentClientView));

    // Listener para el botón de descarga CSV
    if(downloadClientesBtn) {
        downloadClientesBtn.addEventListener('click', () => {
            console.log('Preparando descarga de clientes...');
            // Convertir el objeto de clientes a un array para la descarga
            descargarComoCSV(Object.values(clientsFromDB), 'clientes.csv');
        });
    }

    // --- Función para descargar como CSV (adaptada para clientes) ---
    function descargarComoCSV(data, filename) {
        let csvContent = "data:text/csv;charset=utf-8,";

        if (data.length > 0) {
            // Definir los encabezados en el orden deseado
            const headers = [
                'id', 'nombre', 'apellido', 'email', 'phone', 'mobile',
                'ciudad', 'estado', 'created_at', 'servicios', 'service_ids'
            ];
            csvContent += headers.map(header => {
                // Mapear nombres internos a nombres legibles para el CSV
                if (header === 'id') return 'ID Cliente';
                if (header === 'nombre') return 'Nombre';
                if (header === 'apellido') return 'Apellido';
                if (header === 'email') return 'Email';
                if (header === 'phone') return 'Teléfono Fijo';
                if (header === 'mobile') return 'Teléfono Móvil';
                if (header === 'ciudad') return 'Ciudad';
                if (header === 'estado') return 'Estado';
                if (header === 'created_at') return 'Fecha de Creación';
                if (header === 'servicios') return 'Servicios Contratados (Nombres)'; // Nombres de servicios
                if (header === 'service_ids') return 'Servicios Contratados (IDs)'; // IDs de servicios
                return header; // En caso de que haya otros headers no mapeados
            }).join(",") + "\n";
        }

        data.forEach(function(rowObject) {
            // Iterar sobre los headers definidos para asegurar el orden y la manipulación de valores
            let rowValues = [
                'id', 'nombre', 'apellido', 'email', 'phone', 'mobile',
                'ciudad', 'estado', 'created_at', 'servicios', 'service_ids'
            ].map(key => {
                let value = rowObject[key];
                // Si es service_ids y es un array, conviértelo a una cadena de IDs separados por ;
                if (key === 'service_ids' && Array.isArray(value)) {
                    value = value.join(';');
                }
                // Si es 'servicios' y es un array, conviértelo a cadena
                if (key === 'servicios' && Array.isArray(value)) {
                    value = value.join(';');
                }
                // Convertir null a cadena vacía
                let cell = String(value === null || value === undefined ? '' : value);
                // Escapar comillas dobles y encerrar en comillas si contiene caracteres especiales
                if (cell.includes(',') || cell.includes('\n') || cell.includes('"')) {
                    cell = '"' + cell.replace(/"/g, '""') + '"';
                }
                return cell;
            });
            csvContent += rowValues.join(",") + "\n";
        });

        const encodedUri = encodeURI(csvContent);
        const link = document.createElement("a");
        link.setAttribute("href", encodedUri);
        link.setAttribute("download", filename);
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        showCustomNotification(`Archivo "${filename}" descargado con éxito.`, 'success');
        console.log(`[clients.php] Archivo ${filename} descargado (simulado).`);
    }
    // --- Fin función descargarComoCSV ---


    // Listener para el botón de confirmación de eliminación
    if (confirmDeleteButton) {
        confirmDeleteButton.addEventListener('click', async function() {
            const itemId = this.dataset.itemId;
            const itemType = this.dataset.itemType;
            console.log(`[clients.php] Click en Confirmar Eliminación para ${itemType} ID: ${itemId}.`);

            try {
                const response = await fetch('db/clients-delete.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ id: itemId })
                });
                const result = await response.json();


                if (result.success) {
                    closeModal('confirmDeleteModal');
                    showCustomNotification('Cliente eliminado con éxito.', 'success');
                    console.log('Cliente eliminado con éxito.');
                    fetchClients(); // Recargar datos para actualizar la UI
                } else {
                    showCustomNotification(result.message || 'Error al eliminar.', 'error');
                    console.error('Error al eliminar: ' + result.message);
                    closeModal('confirmDeleteModal');
                }
            } catch (error) {
                showCustomNotification('Hubo un problema de conexión al eliminar.', 'error');
                console.error('Error de red al eliminar:', error);
            }
        });
    }

    // Listeners para botones de vista (cuadrícula/lista)
    if (gridViewBtn) {
        gridViewBtn.addEventListener('click', () => {
            currentClientView = 'grid';
            renderClients('grid');
        });
    }
    if (listViewBtn) {
        listViewBtn.addEventListener('click', () => {
            currentClientView = 'list';
            renderClients('list');
        });
    }

    // Listener para el botón "Editar Cliente" dentro del panel de solo lectura
    if (editClientFromReadonlyBtn) {
        editClientFromReadonlyBtn.addEventListener('click', () => {
            if (currentReadOnlyClientId) {
                openEditClienteModal(currentReadOnlyClientId);
            } else {
                console.error("No hay un cliente seleccionado en el panel de solo lectura para editar.");
            }
        });
    }


    // Listener para el envío del formulario de AÑADIR CLIENTE
    if (addClienteForm) {
        addClienteForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            console.log("[clients.php] Formulario de Agregar Cliente enviado.");

            const serviciosSeleccionados = Array.from(selectedServiceIds).map(Number); // Convertir a números
            const newClientData = {
                first_name: document.getElementById('cliente-first-name').value,
                last_name: document.getElementById('cliente-last-name').value,
                email: document.getElementById('cliente-email').value || null,
                phone: document.getElementById('cliente-phone').value.replace(/\D/g, '') || null,
                mobile: document.getElementById('cliente-mobile').value.replace(/\D/g, '') || null,
                ciudad: document.getElementById('cliente-ciudad').value || null, // Se envía como 'ciudad'
                estado: document.getElementById('cliente-estado-field').value || null, // Se envía como 'estado'
                assigned_service_ids: serviciosSeleccionados
            };

            try {
                const response = await fetch('db/clients-create.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(newClientData)
                });
                const result = await response.json();

                if (result.success) {
                    closePanel('addClientePanel');
                    addClienteForm.reset();
                    showCustomNotification('Cliente agregado con éxito.', 'success');
                    console.log('Cliente agregado con éxito.');
                    fetchClients(); // Recargar datos para actualizar la UI
                } else {
                    showCustomNotification(result.message || 'Error al agregar cliente.', 'error');
                    console.error(result.message);
                }
            } catch (error) {
                showCustomNotification('Hubo un problema de conexión al guardar el cliente.', 'error');
                console.error('Error al enviar el formulario:', error);
            }
        });
    }

    // Listener para el envío del formulario de EDITAR CLIENTE
    if (viewClienteForm) {
        viewClienteForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            console.log("[clients.php] Formulario de Editar Cliente enviado.");

            const clientId = document.getElementById('view-cliente-id').value;
            const serviciosSeleccionadosEdit = Array.from(viewSelectedServiceIds).map(Number); // Convertir a números

            const updatedClientData = {
                id: clientId,
                first_name: document.getElementById('view-cliente-first-name').value,
                last_name: document.getElementById('view-cliente-last-name').value,
                email: document.getElementById('view-cliente-email').value || null,
                phone: document.getElementById('view-cliente-phone').value.replace(/\D/g, '') || null,
                mobile: document.getElementById('view-cliente-mobile').value.replace(/\D/g, '') || null,
                ciudad: document.getElementById('view-cliente-ciudad').value || null, // Se envía como 'ciudad'
                estado: document.getElementById('view-cliente-estado-field').value || null, // Se envía como 'estado'
                assigned_service_ids: serviciosSeleccionadosEdit,
            };

            try {
                const response = await fetch('db/clients-update.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(updatedClientData)
                });
                const result = await response.json();

                if (result.success) {
                    closePanel('viewClientePanel');
                    showCustomNotification('Cambios guardados con éxito.', 'success');
                    console.log('Cambios guardados con éxito.');
                    fetchClients(); // Recargar datos para actualizar la UI
                } else {
                    showCustomNotification(result.message || 'Error al guardar cambios.', 'error');
                    console.error(result.message);
                }
            } catch (error) {
                showCustomNotification('Hubo un problema de conexión al guardar cambios.', 'error');
                console.error('Error al enviar el formulario:', error);
            }
        });
    }
});
</script>
</body>
</html>