<?php
// db/clients-delete.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en clients-delete.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }

    $id = (int)($input['id'] ?? 0);

    if (empty($id)) {
        $response['message'] = 'ID de cliente es obligatorio para eliminar.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        // La cláusula ON DELETE CASCADE en client_services se encargará de eliminar
        // los registros relacionados en esa tabla automáticamente.
        $stmt = $pdo->prepare("DELETE FROM clients WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Cliente eliminado con éxito.';
        } else {
            $response['message'] = 'Error al eliminar el cliente de la base de datos.';
        }
        $pdo->commit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al eliminar cliente: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al eliminar cliente: ' . $e->getMessage();
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al eliminar cliente: " . $e->getMessage());
        $response['message'] = 'Error inesperado al eliminar cliente: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script