<?php
// db/services-update.php
ob_start(); // Iniciar el búfer de salida
error_reporting(0); // Desactivar la muestra de errores en producción
ini_set('display_errors', 0); // Desactivar la muestra de errores en producción

include_once 'db_connection.php'; // Incluir el archivo de conexión a la base de datos

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log("Error de JSON en services-update.php: " . json_last_error_msg());
        $response['message'] = 'Error al decodificar datos de solicitud.';
        echo json_encode($response);
        exit();
    }
    if (empty($input) || empty($input['id'])) {
        $response['message'] = 'ID del servicio es obligatorio.';
        echo json_encode($response);
        exit();
    }

    $id = (int)($input['id'] ?? 0); // ID de la base de datos
    $name = trim($input['name'] ?? '');
    $price = (float)($input['price'] ?? 0.0);
    $category = trim($input['category'] ?? '') ?: null;
    $description = trim($input['description'] ?? '') ?: null;

    if (empty($name) || $price <= 0) {
        $response['message'] = 'Nombre del servicio y precio válido son obligatorios.';
        echo json_encode($response);
        exit();
    }

    try {
        $pdo->beginTransaction();

        $stmt = $pdo->prepare("UPDATE services SET name = :name, price = :price, category = :category, description = :description WHERE id = :id");
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':price', $price);
        $stmt->bindParam(':category', $category);
        $stmt->bindParam(':description', $description);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $response['success'] = true;
            $response['message'] = 'Servicio actualizado con éxito.';
        } else {
            $response['message'] = 'Error al actualizar el servicio en la base de datos.';
        }
        $pdo->commit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Error PDO al actualizar servicio: " . $e->getMessage());
        $response['message'] = 'Error de Base de Datos al actualizar servicio: ' . $e->getMessage();
        if ($e->getCode() == 23000) { // Código de error SQL para violación de unicidad
            $response['message'] = 'Ya existe otro servicio con este nombre.';
        }
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error general al actualizar servicio: " . $e->getMessage());
        $response['message'] = 'Error inesperado al actualizar servicio: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

ob_end_clean(); // Limpiar el búfer de salida
header('Content-Type: application/json'); // Establecer el tipo de contenido a JSON
echo json_encode($response); // Enviar la respuesta JSON
exit; // Terminar la ejecución del script