<?php
// ==========================================================
// ARCHIVO: localcrm/login.php
// Propósito: Punto de entrada para el recurso, muestra el formulario de acceso
//            o redirige al contenido si el acceso es concedido.
// ==========================================================

// Iniciar la sesión de PHP si aún no está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Incluir la conexión a la base de datos
// Asegúrate que esta ruta es correcta desde la ubicación de login.php
include_once 'db/db_connection.php';

$error_mensaje = '';
$usuario_logueado_general = false;
$acceso_concedido_al_recurso = false;
$nombre_producto_actual = 'AdminLocalCRMToolKit'; // Puedes ajustar esto si el nombre real es diferente
$nombre_usuario = 'Invitado';

// Define el nombre del archivo del contenido real del recurso (tu dashboard).
// Asegúrate que esta ruta es correcta.
$archivo_contenido = 'dashboardKLSMPN3721.php'; // O el archivo principal de tu panel de control

// --- LÓGICA DE PROCESAMIENTO DEL FORMULARIO DE INICIO DE SESIÓN ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($email) || empty($password)) {
        $error_mensaje = 'Por favor, introduce tu correo y contraseña.';
    } else {
        try {
            // Prepara la consulta para buscar al usuario por email en la tabla user_profiles
            $stmt = $pdo->prepare("SELECT id, first_name, last_name, email, password FROM user_profiles WHERE email = ?");
            $stmt->execute([$email]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Verifica si se encontró el usuario y la contraseña es correcta
            if ($user && password_verify($password, $user['password'])) {
                // Autenticación exitosa: Establece las variables de sesión clave
                $_SESSION['user_id'] = $user['id']; // ¡Esto es crucial! Guarda el ID del administrador
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_full_name'] = trim($user['first_name'] . ' ' . $user['last_name']);
                
                $usuario_logueado_general = true;
                $acceso_concedido_al_recurso = true;
                $nombre_usuario = $_SESSION['user_full_name'];

                // Redirige al contenido real de la plataforma (dashboard)
                header('Location: ' . $archivo_contenido);
                exit();
            } else {
                $error_mensaje = 'Correo o contraseña incorrectos.';
            }
        } catch (PDOException $e) {
            // Registra el error para depuración (no lo muestres al usuario por seguridad)
            error_log("Error de autenticación en login.php: " . $e->getMessage());
            $error_mensaje = 'Error al intentar acceder. Por favor, inténtalo de nuevo más tarde.';
        }
    }
}

// --- Lógica para cerrar sesión (si se accede con ?logout=true) ---
if (isset($_GET['logout']) && $_GET['logout'] == 'true') {
    session_destroy(); // Destruye todas las variables de sesión
    header('Location: login.php'); // Redirige de nuevo a la página de login
    exit();
}

// Si la ejecución llega a este punto, significa que el usuario NO tiene acceso
// (o no ha intentado loguearse aún, o las credenciales fueron incorrectas),
// por lo que se debe mostrar el formulario de login.

// Adaptación del título (lo que ya tenías)
$titulo_completo_para_mostrar = htmlspecialchars(strtoupper($nombre_producto_actual));
$parte1_titulo = 'ACCESO';
$parte2_titulo = '';

if (strpos($titulo_completo_para_mostrar, 'EBOOK:') === 0) {
    $parte1_titulo .= ' EBOOK:';
    $parte2_titulo = substr($titulo_completo_para_mostrar, strlen('EBOOK:'));
} else {
    $parte2_titulo = $titulo_completo_para_mostrar;
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso a <?php echo htmlspecialchars($nombre_producto_actual); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style> body { font-family: 'Barlow', sans-serif; } </style>
</head>
<body class="bg-[#07162d]">

    <div class="container mx-auto p-4 flex min-h-screen items-center justify-center">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-0 max-w-5xl rounded-2xl shadow-2xl overflow-hidden">
            <div class="hidden md:block">
                <img src="img/Portada.jpg" alt="Portada Recurso" class="w-full h-full object-contain">
            </div>
            <div class="bg-white p-8 md:p-12 flex flex-col justify-center">
                <header class="text-center mb-6">
                    <img src="img/LogoPlataformaNegro.png" alt="Logo Recurso" class="mx-auto h-20 w-auto mb-4">
                    <h1 class="text-3xl font-black">
                        <span class="text-[#07162d]"><?php echo $parte1_titulo; ?></span><span class="text-[#9e1428]"><?php echo $parte2_titulo; ?></span></h1>
                    <?php if ($usuario_logueado_general && !$acceso_concedido_al_recurso && !empty($error_mensaje)): ?>
                        <p class="text-red-600 mt-2 font-semibold">¡Hola, <?php echo htmlspecialchars($nombre_usuario); ?>! <?php echo htmlspecialchars($error_mensaje); ?></p>
                    <?php else: ?>
                        <p class="text-gray-600 mt-2">INGRESA PARA ADMINISTRAR TU NEGOCIO</p>
                    <?php endif; ?>
                </header>

                <form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" class="space-y-6">
                    <div>
                        <div class="relative"><span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-envelope text-gray-400"></i></span><input type="email" id="email" name="email" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Tu Correo Electrónico" required></div>
                    </div>
                    <div>
                        <div class="relative"><span class="absolute inset-y-0 left-0 flex items-center pl-3"><i class="fas fa-lock text-gray-400"></i></span><input type="password" id="password" name="password" class="w-full pl-10 pr-10 py-3 border border-gray-300 rounded-lg focus:ring-[#ffc857] focus:border-[#ffc857]" placeholder="Contraseña" required><span class="absolute inset-y-0 right-0 flex items-center pr-3 cursor-pointer" id="togglePassword"><i class="fas fa-eye text-gray-400" id="eyeIcon"></i></span></div>
                    </div>

                    <?php if (!empty($error_mensaje)): ?>
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative text-center" role="alert"><span><?php echo $error_mensaje; ?></span></div>
                    <?php endif; ?>

                    <button type="submit" class="w-full bg-[#07162d] text-white font-bold py-3 px-8 rounded-lg hover:bg-opacity-90 transition-opacity shadow-lg text-lg">ACCEDER AL RECURSO</button>
                </form>

                <?php include 'files/footer.php'; ?>
            </div>
        </div>
    </div>

    <script>
        const togglePassword = document.querySelector('#togglePassword');
        if (togglePassword) {
            const passwordInput = document.querySelector('#password');
            const eyeIcon = document.querySelector('#eyeIcon');
            togglePassword.addEventListener('click', function () {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                eyeIcon.classList.toggle('fa-eye');
                eyeIcon.classList.toggle('fa-eye-slash');
            });
        }
    </script>
</body>
</html>