<?php
// menu.php

// CAMBIO CLAVE: Solo iniciar la sesión si no hay una ya activa.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Incluir el archivo de conexion a la base de datos
// Asegúrate de que este archivo y la conexión a $pdo sean correctos para evitar errores.
// Si no estás usando una base de datos todavía, puedes comentar las líneas de DB por ahora.
include_once 'db/db_connection.php'; 

// Variables para almacenar los datos del usuario y del negocio (valores por defecto)
$userFullName = "Usuario Demo"; // Cambiado a "Usuario Demo" si no hay login
$userProfilePhoto = "https://placehold.co/96x96/cccccc/333333?text=U"; // Placeholder
$businessName = "Mi Negocio CRM"; // Cambiado a "Mi Negocio CRM" si no hay login

// Verificar si un usuario ha iniciado sesión y obtener sus datos de la DB
if (isset($_SESSION['user_id'])) {
    try {
        $currentUserId = $_SESSION['user_id'];

        // Obtener datos del perfil del usuario actual
        // Asegúrate de que $pdo esté disponible y sea una conexión PDO activa.
        if (isset($pdo) && $pdo instanceof PDO) {
            $stmt_user = $pdo->prepare("SELECT full_name, profile_photo_url FROM user_profiles WHERE user_id = :user_id");
            $stmt_user->bindParam(':user_id', $currentUserId, PDO::PARAM_INT);
            $stmt_user->execute();
            $user_profile_data = $stmt_user->fetch(PDO::FETCH_ASSOC);

            if ($user_profile_data) {
                $userFullName = htmlspecialchars($user_profile_data['full_name'] ?? 'Usuario Desconocido');
                if (!empty($user_profile_data['profile_photo_url'])) {
                    $userProfilePhoto = htmlspecialchars($user_profile_data['profile_photo_url']);
                }
            }

            // Obtener el nombre del negocio
            $stmt_business = $pdo->prepare("SELECT company_name FROM website_config WHERE id = 1");
            $stmt_business->execute();
            $business_config_data = $stmt_business->fetch(PDO::FETCH_ASSOC);

            if ($business_config_data) {
                $businessName = htmlspecialchars($business_config_data['company_name'] ?? 'Mi Negocio');
            }
        } else {
            error_log("ADVERTENCIA: La conexión PDO (\$pdo) no está disponible en menu.php.");
            // Mantendrá los datos por defecto si la conexión no está lista
        }

    } catch (PDOException $e) {
        error_log("Error PDO al cargar datos en menu.php: " . $e->getMessage());
    } catch (Exception $e) {
        error_log("Error general al cargar datos en menu.php: " . $e->getMessage());
    }
}


// Obtiene el nombre del archivo actual para saber qué enlace resaltar
$paginaActual = basename($_SERVER['PHP_SELF']);
?>

<aside id="sidebar" class="bg-[var(--color-primary)] text-[var(--color-text-light)] w-full md:w-64 absolute inset-y-0 left-0 transform -translate-x-full md:relative md:translate-x-0 transition-transform duration-300 ease-in-out z-40 flex flex-col shadow-2xl md:rounded-r-xl">

    <div class="py-6 border-b border-gray-700/50 text-center px-4">
        <div class="relative inline-block">
            <img class="w-24 h-24 rounded-full mx-auto border-4 border-[var(--color-highlight)]" src="<?php echo $userProfilePhoto; ?>" alt="Avatar de usuario">
            <span class="absolute bottom-1 right-1 block h-4 w-4 rounded-full bg-green-400 border-2 border-[var(--color-primary)]"></span>
        </div>
        <h3 class="font-bold text-xl mt-3"><?php echo $userFullName; ?></h3>
        <p class="text-sm text-gray-400"><?php echo $businessName; ?></p>
    </div>

    <nav class="flex-1 space-y-2 p-2 overflow-y-auto">
        <a href="dashboard.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'dashboard.php') { echo 'active-button'; } ?>">
            <i data-lucide="layout-dashboard" class="w-5 h-5 mr-3"></i> INICIO
        </a>
        <a href="clients.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'clients.php') { echo 'active-button'; } ?>">
            <i data-lucide="user-plus" class="w-5 h-5 mr-3"></i> CLIENTES
        </a>
        <a href="leads.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'leads.php') { echo 'active-button'; } ?>">
            <i data-lucide="briefcase" class="w-5 h-5 mr-3"></i> PROSPECTOS
        </a>
        <a href="services.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'services.php') { echo 'active-button'; } ?>">
            <i data-lucide="briefcase" class="w-5 h-5 mr-3"></i> SERVICIOS
        </a>
        <a href="finances.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'finances.php') { echo 'active-button'; } ?>">
            <i data-lucide="trending-up" class="w-5 h-5 mr-3"></i> FINANZAS
        </a>
        <a href="push.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'comunicaciones.php') { echo 'active-button'; } ?>">
            <i data-lucide="message-square" class="w-5 h-5 mr-3"></i> NOTIFICACIONES
        </a>
        <a href="academy.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'academy.php') { echo 'active-button'; } ?>">
            <i data-lucide="graduation-cap" class="w-5 h-5 mr-3"></i> ACADEMIA
        </a>
        <a href="performance.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'performance.php') { echo 'active-button'; } ?>">
            <i data-lucide="bar-chart-2" class="w-5 h-5 mr-3"></i> RENDIMIENTO
        </a>
        <a href="ia-marketing.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'ia-marketing.php') { echo 'active-button'; } ?>">
            <i data-lucide="cpu" class="w-5 h-5 mr-3"></i> IA MARKETING
        </a>
        <a href="promote.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'promote.php') { echo 'active-button'; } ?>">
            <i data-lucide="rocket" class="w-5 h-5 mr-3"></i> PROMOCIONATE
        </a>
        <a href="account.php" class="nav-link flex items-center p-3 rounded-lg hover:bg-[var(--color-secondary)] transition-colors duration-200 uppercase font-black <?php if ($paginaActual == 'account.php') { echo 'active-button'; } ?>">
            <i data-lucide="user-cog" class="w-5 h-5 mr-3"></i> MI CUENTA
        </a>

        <li class="p-2 list-none">
            <img src="img/Portada.jpg" alt="Tu Publicidad Aquí" class="sidebar-ad-image">
        </li>

        <button class="w-full flex items-center p-3 rounded-lg bg-red-700 hover:bg-red-800 text-white transition-colors duration-200 uppercase font-bold">
            <i data-lucide="log-out" class="w-5 h-5 mr-3"></i>
            Cerrar Sesi&oacute;n
        </button>
        
    </nav>
    <?php include 'files/footer.php'; ?>
    <div class="mt-auto p-4 border-t border-gray-700/50"> </div>
</aside>