<?php
ob_start(); // Iniciar el búfer de salida al inicio del script
session_start();

// ***** IMPORTANTE: ESTAS LÍNEAS ESTÁN AQUÍ PARA DEPURAR. *****
// UNA VEZ QUE FUNCIONE, CÁMBIALAS A: error_reporting(0); ini_set('display_errors', 0);
error_reporting(E_ALL); // Reporta todos los errores
ini_set('display_errors', 1); // Muestra los errores en la pantalla
// *************************************************************

// --- DATOS DE ADMINISTRADOR DE EJEMPLO ---
$admin_data = [
    'nombre' => 'María Admin',
    'email' => 'maria.admin@example.com',
    'foto_perfil' => 'https://placehold.co/100x100/4c7c59/ffffff?text=MA' // Ejemplo de imagen
];

// --- Lógica PHP para obtener datos de Banners/Promociones (AHORA SON DATOS DUMMY) ---
// Se ha añadido la clave 'status' para manejar activo/archivado
$banners_data_from_db = [
    'banner-1' => [
        'id' => 'banner-1', // ID para JS (string)
        'db_id' => 1,        // ID simulado de la base de datos (numérico)
        'title' => 'Oferta de Verano: 20% Dto.',
        'image_url' => 'https://placehold.co/400x150/ffc857/07162d?text=OFERTA+VERANO', // URL de imagen dummy
        'link_url' => 'http://example.com/oferta-verano',
        'created_at' => '2024-07-01 10:00:00',
        'status' => 'active' // SOLO UNO DEBE ESTAR ACTIVO
    ],
    'banner-2' => [
        'id' => 'banner-2',
        'db_id' => 2,
        'title' => 'Nuevo Servicio de Consultoría',
        'image_url' => 'https://placehold.co/400x150/07162d/ffc857?text=CONSULTORIA+WEB',
        'link_url' => 'http://example.com/consultoria',
        'created_at' => '2024-07-05 14:30:00',
        'status' => 'archived' // Archivado
    ],
    'banner-3' => [
        'id' => 'banner-3',
        'db_id' => 3,
        'title' => 'Webinars Gratuitos de Marketing',
        'image_url' => 'https://placehold.co/400x150/8a307f/ffffff?text=WEBINAR',
        'link_url' => 'http://example.com/webinars',
        'created_at' => '2024-06-10 09:00:00',
        'status' => 'archived' // Archivado
    ]
];

// Si no hay banners, asegurar que sea un objeto vacío para JSON.
if (empty($banners_data_from_db)) {
    $banners_data_from_db = new stdClass();
}

// Lógica para contar nuevos banners este mes (desde PHP)
$new_banners_this_month = 0;
$current_month_year = date('Y-m'); // "2024-07"
foreach ((array)$banners_data_from_db as $banner) {
    if (isset($banner['created_at']) && (new DateTime($banner['created_at']))->format('Y-m') === $current_month_year) {
        $new_banners_this_month++;
    }
}


// --- Lógica PHP para obtener datos de Notificaciones (AHORA SON DATOS DUMMY) ---
// Se ha añadido la clave 'status' para manejar activo/archivado
$notifications_data_from_db = [
    'notif-1' => [
        'id' => 'notif-1',
        'db_id' => 1,
        'title' => '¡Nuevas Herramientas IA Disponibles!',
        'description' => 'Hemos lanzado un nuevo generador de cotizaciones y facturas en la sección de Herramientas IA.',
        'internal_url' => 'ia-marketing.php',
        'external_url' => null,
        'created_at' => '2024-07-12 08:00:00',
        'status' => 'active' // SOLO UNA DEBE ESTAR ACTIVA
    ],
    'notif-2' => [
        'id' => 'notif-2',
        'db_id' => 2,
        'title' => 'Descuento del 15% en Primer Servicio',
        'description' => 'Aprovecha nuestra promoción especial para nuevos clientes en todos nuestros servicios.',
        'internal_url' => null,
        'external_url' => 'http://example.com/ofertas',
        'created_at' => '2024-07-14 11:00:00',
        'status' => 'archived' // Archivada
    ],
    'notif-3' => [
        'id' => 'notif-3',
        'db_id' => 3,
        'title' => 'Mantenimiento Programado',
        'description' => 'Nuestro sistema estará en mantenimiento el 20 de julio de 2 AM a 4 AM (hora local). Disculpe las molestias.',
        'internal_url' => null,
        'external_url' => null,
        'created_at' => '2024-06-28 17:00:00',
        'status' => 'archived' // Archivada
    ]
];

// Si no hay notificaciones, asegurar que sea un objeto vacío para JSON.
if (empty($notifications_data_from_db)) {
    $notifications_data_from_db = new stdClass();
}

// Lógica para contar nuevas notificaciones este mes (desde PHP)
$new_notifications_this_month = 0;
foreach ((array)$notifications_data_from_db as $notif) {
    if (isset($notif['created_at']) && (new DateTime($notif['created_at']))->format('Y-m') === $current_month_year) {
        $new_notifications_this_month++;
    }
}


// Codificar los datos a JSON para pasarlos a JavaScript
$banners_json = json_encode($banners_data_from_db);
$new_banners_this_month_json = json_encode($new_banners_this_month);

$notifications_json = json_encode($notifications_data_from_db);
$new_notifications_this_month_json = json_encode($new_notifications_this_month);


// Manejo de notificaciones de sesión (si existen)
$notification_message = '';
$notification_type = '';
if (isset($_SESSION['notification'])) {
    $notification_message = $_SESSION['notification']['message'];
    $notification_type = $_SESSION['notification']['type'];
    unset($_SESSION['notification']); // Limpiar la notificación después de mostrarla
}
ob_end_clean(); // Finalizar y limpiar el búfer de salida
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Dashboard | Administración de Comunicaciones</title>
    <meta name="description" content="Administra tus banners promocionales y notificaciones en LocalCRM: sube imágenes, define enlaces y envía mensajes a tus usuarios.">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
</head>
 
<body data-page-title="PANEL DE ADMINISTRADOR - COMUNICACIONES"
      data-page-subtitle="GESTIÓN DE ANUNCIOS Y NOTIFICACIONES"
      data-page-icon="message-square">

<div id="toastNotification" class="toast-notification">
    <i id="toastIcon" class="fas"></i>
    <span id="toastMessage"></span>
    <button id="toastCloseBtn" class="toast-close-btn">&times;</button>
</div>
<style>
.toast-notification {
    visibility: hidden;
    min-width: 250px;
    background-color: #333;
    color: #fff;
    text-align: center;
    border-radius: 8px;
    padding: 16px;
    position: fixed;
    z-index: 1000;
    left: 50%;
    transform: translateX(-50%);
    bottom: 30px;
    font-size: 17px;
    display: flex;
    align-items: center;
    gap: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    opacity: 0;
    transition: opacity 0.5s, bottom 0.5s;
}

.toast-notification.show {
    visibility: visible;
    opacity: 1;
    bottom: 50px;
}

.toast-notification.success { background-color: #4CAF50; }
.toast-notification.error { background-color: #f44336; }
.toast-notification.info { background-color: #2196F3; }

.toast-notification .toast-close-btn {
    background: none;
    border: none;
    color: white;
    font-size: 20px;
    cursor: pointer;
    margin-left: auto;
}
</style>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container" id="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
            </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">
            <section id="banners-section" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="image" class="w-7 h-7 text-[var(--color-primary)]"></i> LISTADO DE BANNERS Y PUBLICIDAD
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">IMÁGENES PROMOCIONALES ADICIONALES QUE ENLAZAN A CONTENIDO.</p>
                        </div>
                        <div class="flex items-center gap-4 w-full md:w-auto">
                            <button id="addBannerBtn" class="btn-secondary font-bold py-2 px-4 rounded-lg flex items-center w-full md:w-auto justify-center uppercase">
                                <i data-lucide="plus" class="w-5 h-5 mr-2"></i> AGREGAR BANNER
                            </button>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-primary)]">
                            <i data-lucide="image" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">TOTAL DE BANNERS</h3>
                                <p id="total-banners-count" class="text-5xl font-bold text-[var(--color-secondary)]">0</p>
                                <p class="text-sm text-gray-400 mt-1">ACTIVOS EN EL SISTEMA</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-highlight)]">
                            <i data-lucide="calendar-plus" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">NUEVOS BANNERS ESTE MES</h3>
                                <p id="new-banners-this-month-count" class="text-5xl font-bold text-[var(--color-secondary)]">0</p>
                                <p class="text-sm text-gray-400 mt-1 uppercase">AGREGADOS EN EL PERIODO</p>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-col md:flex-row gap-4 mb-6">
                        <div class="relative flex-grow">
                            <input type="text" id="banner-search" placeholder="Buscar Por Título o URL..." class="w-full p-3 pl-10 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]">
                            <i data-lucide="search" class="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400"></i>
                        </div>
                        <div class="view-toggle inline-flex bg-gray-200 rounded-lg p-1">
                            <button id="banner-grid-view-btn" class="px-3 py-1 rounded-md text-sm font-semibold transition-colors duration-200 active uppercase" title="Vista de Cuadrícula">
                                <i data-lucide="layout-grid" class="w-5 h-5"></i>
                            </button>
                            <button id="banner-list-view-btn" class="px-3 py-1 rounded-md text-sm font-semibold transition-colors duration-200 uppercase" title="Vista de Lista">
                                <i data-lucide="list" class="w-5 h-5"></i>
                            </button>
                        </div>
                    </div>

                    <div id="banner-grid-view" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        </div>

                    <div id="banner-list-view" class="overflow-x-auto hidden">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-50">
                                <tr class="text-left text-gray-500 uppercase text-sm">
                                    <th class="py-3 px-6 font-semibold">TÍTULO</th>
                                    <th class="py-3 px-6 font-semibold hidden md:table-cell">IMAGEN</th>
                                    <th class="py-3 px-6 font-semibold">URL ENLACE</th>
                                    <th class="py-3 px-6 font-semibold text-center">ESTADO</th>
                                    <th class="py-3 px-6 font-semibold text-center">ACCIONES</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-700 text-sm" id="bannersTableBody">
                                </tbody>
                        </table>
                    </div>
                </div>
            </section>
            
            <section id="notifications-section" class="dashboard-section mt-8">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="bell" class="w-7 h-7 text-[var(--color-primary)]"></i> NOTIFICACIONES Y ANUNCIOS
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">ENVÍA MENSAJES DIRECTOS A TUS USUARIOS DEL CRM.</p>
                        </div>
                        <div class="flex items-center gap-4 w-full md:w-auto">
                            <button id="addNotificationBtn" class="btn-secondary font-bold py-2 px-4 rounded-lg flex items-center w-full md:w-auto justify-center uppercase">
                                <i data-lucide="plus" class="w-5 h-5 mr-2"></i> ENVIAR NOTIFICACIÓN
                            </button>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-primary)]">
                            <i data-lucide="mail" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">TOTAL DE NOTIFICACIONES</h3>
                                <p id="total-notifications-count" class="text-5xl font-bold text-[var(--color-secondary)]">0</p>
                                <p class="text-sm text-gray-400 mt-1">ENVIADAS</p>
                            </div>
                        </div>
                        <div class="stat-card bg-white p-6 rounded-xl shadow-md flex items-center space-x-4 border-l-4 border-[var(--color-highlight)]">
                            <i data-lucide="calendar-plus" class="w-12 h-12 text-gray-700"></i>
                            <div>
                                <h3 class="text-lg font-extrabold text-gray-500 mb-1">NUEVAS NOTIFICACIONES ESTE MES</h3>
                                <p id="new-notifications-this-month-count" class="text-5xl font-bold text-[var(--color-secondary)]">0</p>
                                <p class="text-sm text-gray-400 mt-1 uppercase">ENVIADAS EN EL PERIODO</p>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-col md:flex-row gap-4 mb-6">
                        <div class="relative flex-grow">
                            <input type="text" id="notification-search" placeholder="Buscar Notificación por Título o Descripción..." class="w-full p-3 pl-10 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]">
                            <i data-lucide="search" class="absolute left-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400"></i>
                        </div>
                    </div>

                    <div id="notification-list-view" class="overflow-x-auto">
                        <table class="min-w-full bg-white">
                            <thead class="bg-gray-50">
                                <tr class="text-left text-gray-500 uppercase text-sm">
                                    <th class="py-3 px-6 font-semibold">TÍTULO</th>
                                    <th class="py-3 px-6 font-semibold hidden md:table-cell">DESCRIPCIÓN</th>
                                    <th class="py-3 px-6 font-semibold">ENLACE</th>
                                    <th class="py-3 px-6 font-semibold text-center">ESTADO</th>
                                    <th class="py-3 px-6 font-semibold text-center">ACCIONES</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-700 text-sm" id="notificationsTableBody">
                                </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<div id="addBannerPanel" class="fixed inset-y-0 right-0 w-full md:w-1/2 bg-white shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out z-50 overflow-y-auto">
    <div class="p-8 flex flex-col h-full">
        <div class="flex justify-between items-center mb-6 flex-shrink-0">
            <h3 class="text-2xl font-bold text-[var(--color-primary)]">AGREGAR NUEVO BANNER</h3>
            <button onclick="closePanel('addBannerPanel')" class="text-gray-400 hover:text-gray-600"><i data-lucide="x" class="w-6 h-6"></i></button>
        </div>
        <form id="add-banner-form" class="flex-grow overflow-y-auto pr-2 -mr-2">
            <div class="grid grid-cols-1 gap-x-6 gap-y-4">
                <div>
                    <label for="banner-title" class="block text-gray-700 text-sm font-bold mb-2 uppercase">TÍTULO DEL BANNER</label>
                    <input type="text" id="banner-title" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. Oferta Especial de Invierno" required>
                </div>
                <div>
                    <label for="banner-image-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL DE IMAGEN DEL BANNER</label>
                    <input type="url" id="banner-image-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="http://example.com/mi-banner.jpg" required>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-gray-700 text-sm font-bold mb-2 uppercase">PREVISUALIZACIÓN DE IMAGEN</label>
                    <div id="add-banner-image-preview" class="w-full h-40 bg-gray-200 rounded-lg flex items-center justify-center text-gray-500 overflow-hidden">
                        <i data-lucide="image" class="w-12 h-12"></i>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">La imagen se cargará automáticamente desde la URL.</p>
                </div>
                 <div>
                    <label for="banner-link-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL DE ENLACE (AL HACER CLIC)</label>
                    <input type="url" id="banner-link-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="http://example.com/enlace-de-destino.com" required>
                </div>
            </div>
            <div class="h-4"></div>
        </form>
        <div class="flex justify-end space-x-4 pt-6 flex-shrink-0">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closePanel('addBannerPanel')">CANCELAR</button>
            <button type="submit" form="add-banner-form" class="btn-secondary font-bold py-2 px-4 rounded-lg uppercase">GUARDAR BANNER</button>
        </div>
    </div>
</div>

<div id="confirmDeleteModal" class="fixed inset-0 bg-gray-900 bg-opacity-75 flex items-center justify-center hidden z-50">
    <div class="bg-white p-8 rounded-xl shadow-2xl w-full max-w-sm m-4 transform transition-all duration-300 scale-95 opacity-0 text-center">
        <div class="flex justify-center mb-4">
            <i data-lucide="alert-triangle" class="w-16 h-16 text-red-500"></i>
        </div>
        <h3 class="text-2xl font-bold text-[var(--color-primary)] mb-4 uppercase">CONFIRMAR ELIMINACIÓN</h3>
        <p class="text-gray-700 mb-6 uppercase">¿ESTÁS SEGURO DE QUE DESEAS ELIMINAR ESTE <span id="confirm-item-type" class="font-semibold">ELEMENTO</span>? ESTA ACCIÓN NO SE PUEDE DESHACER.</p>
        <div class="flex justify-center space-x-4">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closeModal('confirmDeleteModal')">CANCELAR</button>
            <button type="button" class="btn-secondary font-bold py-2 px-4 rounded-lg uppercase" id="confirm-delete-button">CONFIRMAR</button>
        </div>
    </div>
</div>

<div id="viewBannerPanel" class="fixed inset-y-0 right-0 w-full md:w-1/2 bg-white shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out z-50 overflow-y-auto">
    <div class="p-8 flex flex-col h-full">
        <div class="flex justify-between items-center mb-6 flex-shrink-0">
            <h3 class="text-2xl font-bold text-[var(--color-primary)]">DETALLE DEL BANNER</h3>
            <button onclick="closePanel('viewBannerPanel')" class="text-gray-400 hover:text-gray-600"><i data-lucide="x" class="w-6 h-6"></i></button>
        </div>
        <form id="view-banner-form" class="flex-grow overflow-y-auto pr-2 -mr-2">
            <input type="hidden" id="view-banner-id">
            <input type="hidden" id="view-banner-internal-id"> <div class="grid grid-cols-1 gap-x-6 gap-y-4">
                <div>
                    <label for="view-banner-title" class="block text-gray-700 text-sm font-bold mb-2 uppercase">TÍTULO DEL BANNER</label>
                    <input type="text" id="view-banner-title" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Título Del Banner">
                </div>
                <div>
                    <label for="view-banner-image-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL DE IMAGEN DEL BANNER</label>
                    <input type="url" id="view-banner-image-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="http://example.com/mi-banner.jpg">
                </div>
                <div class="md:col-span-2">
                    <label class="block text-gray-700 text-sm font-bold mb-2 uppercase">PREVISUALIZACIÓN DE IMAGEN</label>
                    <div id="view-banner-image-preview" class="w-full h-40 bg-gray-200 rounded-lg flex items-center justify-center text-gray-500 overflow-hidden">
                        <i data-lucide="image" class="w-12 h-12"></i>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">La imagen se cargará automáticamente desde la URL.</p>
                </div>
                 <div>
                    <label for="view-banner-link-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL DE ENLACE (AL HACER CLIC)</label>
                    <input type="url" id="view-banner-link-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="http://example.com/enlace-de-destino.com">
                </div>
                <div class="md:col-span-2">
                    <label for="view-banner-status" class="block text-gray-700 text-sm font-bold mb-2 uppercase">Estado</label>
                    <div class="flex items-center space-x-4">
                        <input type="radio" id="view-banner-status-active" name="banner_status" value="active" class="h-4 w-4 text-[var(--color-primary)] focus:ring-[var(--color-highlight)] border-gray-300">
                        <label for="view-banner-status-active" class="text-gray-700 text-sm uppercase font-semibold">Activo</label>
                        <input type="radio" id="view-banner-status-archived" name="banner_status" value="archived" class="h-4 w-4 text-gray-500 focus:ring-[var(--color-highlight)] border-gray-300">
                        <label for="view-banner-status-archived" class="text-gray-700 text-sm uppercase font-semibold">Archivado</label>
                    </div>
                    <p class="text-xs text-gray-500 mt-1">Solo un banner puede estar activo a la vez.</p>
                </div>
            </div>
            <div class="h-4"></div>
        </form>
        <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6 flex-shrink-0">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closePanel('viewBannerPanel')">CANCELAR</button>
            <button type="submit" form="view-banner-form" class="btn-primary font-bold py-2 px-4 rounded-lg uppercase">GUARDAR CAMBIOS</button>
        </div>
    </div>
</div>

<div id="addNotificationPanel" class="fixed inset-y-0 right-0 w-full md:w-1/2 bg-white shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out z-50 overflow-y-auto">
    <div class="p-8 flex flex-col h-full">
        <div class="flex justify-between items-center mb-6 flex-shrink-0">
            <h3 class="text-2xl font-bold text-[var(--color-primary)]">ENVIAR NUEVA NOTIFICACIÓN</h3>
            <button onclick="closePanel('addNotificationPanel')" class="text-gray-400 hover:text-gray-600"><i data-lucide="x" class="w-6 h-6"></i></button>
        </div>
        <form id="add-notification-form" class="flex-grow overflow-y-auto pr-2 -mr-2">
            <div class="grid grid-cols-1 gap-x-6 gap-y-4">
                <div>
                    <label for="notification-title" class="block text-gray-700 text-sm font-bold mb-2 uppercase">TÍTULO DE LA NOTIFICACIÓN</label>
                    <input type="text" id="notification-title" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. ¡Nueva Actualización Disponible!" required>
                </div>
                <div>
                    <label for="notification-description" class="block text-sm font-medium text-gray-700">DESCRIPCIÓN</label>
                    <textarea id="notification-description" rows="5" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Describe brevemente el contenido de la notificación"></textarea>
                </div>
                <div>
                    <label for="notification-internal-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL INTERNA DEL CRM (OPCIONAL)</label>
                    <input type="text" id="notification-internal-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. clients.php o ia-marketing.php">
                    <p class="text-xs text-gray-500 mt-1">Si es una sección dentro del CRM.</p>
                </div>
                 <div>
                    <label for="notification-external-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL EXTERNA (OPCIONAL)</label>
                    <input type="url" id="notification-external-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="http://example.com/blog.com/articulo">
                    <p class="text-xs text-gray-500 mt-1">Si es un enlace a tu web, blog o producto externo.</p>
                </div>
                 <div class="text-xs text-gray-500 italic">Si ambas URLs son proporcionadas, se priorizará la URL externa.</div>
            </div>
            <div class="h-4"></div>
        </form>
        <div class="flex justify-end space-x-4 pt-6 flex-shrink-0">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closePanel('addNotificationPanel')">CANCELAR</button>
            <button type="submit" form="add-notification-form" class="btn-secondary font-bold py-2 px-4 rounded-lg uppercase">ENVIAR NOTIFICACIÓN</button>
        </div>
    </div>
</div>

<div id="viewNotificationPanel" class="fixed inset-y-0 right-0 w-full md:w-1/2 bg-white shadow-lg transform translate-x-full transition-transform duration-300 ease-in-out z-50 overflow-y-auto">
    <div class="p-8 flex flex-col h-full">
        <div class="flex justify-between items-center mb-6 flex-shrink-0">
            <h3 class="text-2xl font-bold text-[var(--color-primary)]">DETALLE DE LA NOTIFICACIÓN</h3>
            <button onclick="closePanel('viewNotificationPanel')" class="text-gray-400 hover:text-gray-600"><i data-lucide="x" class="w-6 h-6"></i></button>
        </div>
        <form id="view-notification-form" class="flex-grow overflow-y-auto pr-2 -mr-2">
            <input type="hidden" id="view-notification-id">
            <input type="hidden" id="view-notification-internal-id"> <div class="grid grid-cols-1 gap-x-6 gap-y-4">
                <div>
                    <label for="view-notification-title" class="block text-gray-700 text-sm font-bold mb-2 uppercase">TÍTULO DE LA NOTIFICACIÓN</label>
                    <input type="text" id="view-notification-title" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Título">
                </div>
                <div>
                    <label for="view-notification-description" class="block text-sm font-medium text-gray-700">DESCRIPCIÓN</label>
                    <textarea id="view-notification-description" rows="5" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Descripción"></textarea>
                </div>
                <div>
                    <label for="view-notification-internal-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL INTERNA DEL CRM (OPCIONAL)</label>
                    <input type="text" id="view-notification-internal-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="Ej. clients.php o ia-marketing.php">
                </div>
                 <div>
                    <label for="view-notification-external-url" class="block text-gray-700 text-sm font-bold mb-2 uppercase">URL EXTERNA (OPCIONAL)</label>
                    <input type="url" id="view-notification-external-url" class="w-full p-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[var(--color-highlight)]" placeholder="http://example.com/blog.com/articulo">
                </div>
                 <div class="md:col-span-2">
                    <label for="view-notification-status" class="block text-gray-700 text-sm font-bold mb-2 uppercase">Estado</label>
                    <div class="flex items-center space-x-4">
                        <input type="radio" id="view-notification-status-active" name="notification_status" value="active" class="h-4 w-4 text-[var(--color-primary)] focus:ring-[var(--color-highlight)] border-gray-300">
                        <label for="view-notification-status-active" class="text-gray-700 text-sm uppercase font-semibold">Activa</label>
                        <input type="radio" id="view-notification-status-archived" name="notification_status" value="archived" class="h-4 w-4 text-gray-500 focus:ring-[var(--color-highlight)] border-gray-300">
                        <label for="view-notification-status-archived" class="text-gray-700 text-sm uppercase font-semibold">Archivada</label>
                    </div>
                    <p class="text-xs text-gray-500 mt-1">Solo una notificación puede estar activa a la vez.</p>
                </div>
            </div>
            <div class="h-4"></div>
        </form>
        <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6 flex-shrink-0">
            <button type="button" class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-bold py-2 px-4 rounded-lg uppercase" onclick="closePanel('viewNotificationPanel')">CANCELAR</button>
            <button type="submit" form="view-notification-form" class="btn-primary font-bold py-2 px-4 rounded-lg uppercase">GUARDAR CAMBIOS</button>
        </div>
    </div>
</div>

<script>
// Variables globales para los datos (dummy)
// Aseguramos que si PHP envía un objeto vacío {}, JS lo interprete como objeto vacío, no array.
// Si el JSON está vacío o no es un objeto válido, se inicializa como un objeto vacío para evitar errores.
let bannersActuales = (function() {
    try {
        const data = <?php echo $banners_json; ?>;
        return (typeof data === 'object' && data !== null && !Array.isArray(data)) ? data : {};
    } catch (e) {
        console.error("Error parseando banners_json:", e);
        return {};
    }
})();
// El contador de nuevos banners este mes ya viene de PHP, lo asignamos directamente
let newBannersThisMonthCount = <?php echo $new_banners_this_month_json; ?>;

let notificationsActuales = (function() {
    try {
        const data = <?php echo $notifications_json; ?>;
        return (typeof data === 'object' && data !== null && !Array.isArray(data)) ? data : {};
    } catch (e) {
        console.error("Error parseando notifications_json:", e);
        return {};
    }
})();
// El contador de nuevas notificaciones este mes ya viene de PHP, lo asignamos directamente
let newNotificationsThisMonthCount = <?php echo $new_notifications_this_month_json; ?>;


document.addEventListener('DOMContentLoaded', function() {
    // --- CONSOLE.LOGS PARA DEPURACIÓN (visible en la consola del navegador) ---
    console.log("--- Depuración de comunicaciones.php ---");
    console.log("bannersActuales (datos de banners al cargar PHP):", bannersActuales);
    console.log("Tipo de bannersActuales:", typeof bannersActuales, Array.isArray(bannersActuales) ? "(Es un Array)" : "(Es un Objeto)");
    console.log("newBannersThisMonthCount (contador mensual de banners desde PHP):", newBannersThisMonthCount);
    console.log("notificationsActuales (datos de notificaciones al cargar PHP):", notificationsActuales);
    console.log("Tipo de notificationsActuales:", typeof notificationsActuales, Array.isArray(notificationsActuales) ? "(Es un Array)" : "(Es un Objeto)");
    console.log("newNotificationsThisMonthCount (contador mensual de notificaciones desde PHP):", newNotificationsThisMonthCount);
    // --- FIN CONSOLE.LOGS PARA DEPURACIÓN ---


    // --- VARIABLES DOM LOCALES (Elementos HTML que el JS necesita manipular) ---
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const sidebar = document.getElementById('sidebar'); // Asegúrate de que tu 'menu.php' tenga un elemento con id="sidebar"
    const sidebarOverlay = document.getElementById('sidebar-overlay');
    const sidebarCloseBtn = document.getElementById('sidebarCloseBtn');
    
    // Banners
    const bannerSearch = document.getElementById('banner-search');
    const bannerGridView = document.getElementById('banner-grid-view');
    const bannerListView = document.getElementById('banner-list-view');
    const bannersTableBody = document.getElementById('bannersTableBody');
    const bannerGridViewBtn = document.getElementById('banner-grid-view-btn');
    const bannerListViewBtn = document.getElementById('banner-list-view-btn');
    const addBannerPanel = document.getElementById('addBannerPanel');
    const addBannerForm = document.getElementById('add-banner-form');
    const viewBannerPanel = document.getElementById('viewBannerPanel');
    const viewBannerForm = document.getElementById('view-banner-form');
    const totalBannersCountElement = document.getElementById('total-banners-count');
    const newBannersThisMonthCountElement = document.getElementById('new-banners-this-month-count');
    // **IMPORTANTE**: Asegúrate que este ID 'addBannerBtn' esté en tu HTML para el botón de "Agregar Banner"
    const addBannerBtn = document.getElementById('addBannerBtn'); 
    const addBannerImageUrlInput = document.getElementById('banner-image-url');
    const addBannerImagePreview = document.getElementById('add-banner-image-preview');
    const viewBannerImageUrlInput = document.getElementById('view-banner-image-url');
    const viewBannerImagePreview = document.getElementById('view-banner-image-preview');
    const viewBannerStatusActiveRadio = document.getElementById('view-banner-status-active'); // Nuevo radio button
    const viewBannerStatusArchivedRadio = document.getElementById('view-banner-status-archived'); // Nuevo radio button
    const viewBannerInternalIdInput = document.getElementById('view-banner-internal-id');


    // Notificaciones
    const notificationSearch = document.getElementById('notification-search');
    const notificationListView = document.getElementById('notification-list-view'); 
    const notificationsTableBody = document.getElementById('notificationsTableBody');
    const addNotificationPanel = document.getElementById('addNotificationPanel');
    const addNotificationForm = document.getElementById('add-notification-form');
    const viewNotificationPanel = document.getElementById('viewNotificationPanel');
    const viewNotificationForm = document.getElementById('view-notification-form');
    const totalNotificationsCountElement = document.getElementById('total-notifications-count');
    const newNotificationsThisMonthCountElement = document.getElementById('new-notifications-this-month-count');
    // **IMPORTANTE**: Asegúrate que este ID 'addNotificationBtn' esté en tu HTML para el botón de "Enviar Notificación"
    const addNotificationBtn = document.getElementById('addNotificationBtn'); 
    const viewNotificationStatusActiveRadio = document.getElementById('view-notification-status-active'); // Nuevo radio button
    const viewNotificationStatusArchivedRadio = document.getElementById('view-notification-status-archived'); // Nuevo radio button
    const viewNotificationInternalIdInput = document.getElementById('view-notification-internal-id');


    // Modales de confirmación (compartidos)
    const confirmDeleteModal = document.getElementById('confirmDeleteModal');
    const confirmDeleteButton = document.getElementById('confirm-delete-button');
    const confirmItemTypeSpan = document.getElementById('confirm-item-type');

    // Variable para controlar la vista actual de los banners (cuadrícula por defecto)
    let currentBannerView = 'grid'; 
    
    // Elemento de overlay para los paneles laterales (creado dinámicamente si no existe)
    // Esto asegura que haya un fondo oscuro cuando los paneles laterales están abiertos
    let panelOverlay = document.getElementById('panel-overlay');
    if (!panelOverlay) {
        panelOverlay = document.createElement('div');
        panelOverlay.id = 'panel-overlay';
        panelOverlay.className = 'fixed inset-0 bg-black bg-opacity-50 z-40 hidden';
        document.body.appendChild(panelOverlay);
    }


    // --- FUNCIONES HELPER GLOBALES (acciones comunes que pueden ser llamadas desde cualquier parte) ---

    // Muestra una notificación temporal en la pantalla (como un "toast")
    window.showCustomNotification = function(message, type = 'info', duration = 3000) {
        const toast = document.getElementById('toastNotification');
        const toastMessage = document.getElementById('toastMessage');
        const toastIcon = document.getElementById('toastIcon');
        const toastCloseBtn = document.getElementById('toastCloseBtn');
        let toastTimeout;

        // Si los elementos del toast no existen, imprime un mensaje en consola y no hace nada
        if (!toast || !toastMessage || !toastIcon || !toastCloseBtn) {
            console.warn(`[NOTIFICACION - FALLBACK] Elementos de toast no encontrados. Mensaje: ${type.toUpperCase()}: ${message}`);
            return;
        }

        clearTimeout(toastTimeout); // Limpia cualquier notificación anterior
        // Limpiar clases de tipo anteriores para aplicar la nueva
        toast.classList.remove('success', 'error', 'info');
        toastIcon.classList.remove('fa-check-circle', 'fa-exclamation-circle', 'fa-info-circle');
        toast.className = 'toast-notification'; // Restablecer a la clase base

        toastMessage.textContent = message; // Establece el mensaje
        toast.classList.add(type); // Añade la clase de estilo (success, error, info)
        
        // Define el ícono basado en el tipo de notificación
        if (type === 'success') {
            toastIcon.classList.add('fa-check-circle');
        } else if (type === 'error') {
            toastIcon.classList.add('fa-exclamation-circle');
        } else {
            toastIcon.classList.add('fa-info-circle'); 
        }

        toast.classList.add('show'); // Muestra el toast
        // Configura un temporizador para ocultar el toast después de 'duration' milisegundos
        toastTimeout = setTimeout(() => {
            toast.classList.remove('show');
        }, duration);

        // Permite cerrar el toast manualmente
        toastCloseBtn.onclick = () => {
            clearTimeout(toastTimeout);
            toast.classList.remove('show');
        };

        console.log(`[NOTIFICACION - ${type.toUpperCase()}] ${message}`);
    };

    // Abre un panel lateral deslizante (como los de añadir/editar)
    window.openPanel = function(panelId) {
        const panel = document.getElementById(panelId);
        if (!panel) { console.error(`Error: Panel con ID "${panelId}" no encontrado.`); return; }
        panel.classList.remove('translate-x-full'); // Mueve el panel para que sea visible
        panelOverlay.classList.remove('hidden');    // Muestra el overlay oscuro
        console.log(`[comunicaciones.php] Panel ${panelId} abierto.`);
        
        // Lógica específica para restablecer formularios al abrir
        if (panelId === 'addBannerPanel') {
            addBannerForm.reset(); // Limpia el formulario
            addBannerImageUrlInput.value = ''; // Limpia la URL de imagen
            addBannerImagePreview.innerHTML = `<i data-lucide="image" class="w-12 h-12 text-gray-500"></i>`; // Muestra ícono por defecto
            lucide.createIcons({ container: addBannerImagePreview }); // Vuelve a renderizar íconos
        } else if (panelId === 'addNotificationPanel') {
            addNotificationForm.reset(); // Limpia el formulario
        }
    };

    // Cierra un panel lateral deslizante
    window.closePanel = function(panelId) {
        const panel = document.getElementById(panelId);
        if (!panel) { console.error(`Error: Panel con ID "${panelId}" no encontrado para cerrar.`); return; }
        panel.classList.add('translate-x-full'); // Esconde el panel
        panelOverlay.classList.add('hidden');    // Esconde el overlay
        console.log(`[comunicaciones.php] Panel ${panelId} cerrado.`);
    };

    // Abre un modal (ventana emergente, como la de confirmación de eliminación)
    window.openModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado.`); return; }
        const modalBox = modal.querySelector('div:first-of-type'); // El contenido real del modal
        modal.classList.remove('hidden'); // Muestra el modal
        // Pequeño retardo para la animación de entrada
        setTimeout(() => { 
            if (modalBox) modalBox.classList.remove('scale-95', 'opacity-0'); 
        }, 50);
        console.log(`[comunicaciones.php] Modal ${modalId} abierto.`);
        lucide.createIcons({ container: modal }); // Asegura que los íconos del modal se muestren
    };

    // Cierra un modal
    window.closeModal = function(modalId) {
        const modal = document.getElementById(modalId);
        if (!modal) { console.error(`Error: Modal con ID "${modalId}" no encontrado para cerrar.`); return; }
        const modalBox = modal.querySelector('div:first-of-type');
        if (modalBox) modalBox.classList.add('scale-95', 'opacity-0'); // Inicia la animación de salida
        // Oculta el modal después de la animación
        setTimeout(() => { modal.classList.add('hidden'); }, 300);
        console.log(`[comunicaciones.php] Modal ${modalId} cerrado.`);
    };
    
    // Prepara y abre el modal de confirmación de eliminación para un elemento específico
    window.openConfirmDeleteModal = function(itemId, itemType) {
        if (!confirmDeleteButton || !confirmItemTypeSpan) { console.error("Error: Elementos del modal de confirmación de eliminación no encontrados."); return; }
        confirmDeleteButton.dataset.itemId = itemId; // Guarda el ID del elemento a eliminar
        confirmDeleteButton.dataset.itemType = itemType; // Guarda el tipo (banner/notificación)
        confirmItemTypeSpan.textContent = itemType.toUpperCase(); // Muestra el tipo en el mensaje
        openModal('confirmDeleteModal'); // Abre el modal
    };


    // --- BANNERS: FUNCIONES DE RENDERIZADO Y LÓGICA ---

    // Abre el panel para ver/editar un banner existente
    window.openViewBannerModal = function(bannerId) {
        const banner = bannersActuales[bannerId];
        if (!banner) { console.error('Banner no encontrado:', bannerId); return; }
        
        // Rellena los campos del formulario con los datos del banner
        document.getElementById('view-banner-id').value = banner.db_id;
        document.getElementById('view-banner-internal-id').value = banner.id; // Guarda el ID interno
        document.getElementById('view-banner-title').value = banner.title;
        document.getElementById('view-banner-image-url').value = banner.image_url || '';
        document.getElementById('view-banner-link-url').value = banner.link_url || '';

        // Establece el estado activo/archivado
        if (banner.status === 'active') {
            viewBannerStatusActiveRadio.checked = true;
        } else {
            viewBannerStatusArchivedRadio.checked = true;
        }

        // Actualiza la imagen de previsualización
        if (viewBannerImagePreview) {
            if (banner.image_url) {
                viewBannerImagePreview.innerHTML = `<img src="${banner.image_url}" alt="Miniatura de banner" class="w-full h-full object-cover rounded-lg">`;
            } else {
                viewBannerImagePreview.innerHTML = `<i data-lucide="image" class="w-12 h-12 text-gray-500"></i>`;
            }
            lucide.createIcons({ container: viewBannerImagePreview }); // Renderiza el ícono si no hay imagen
        }

        openPanel('viewBannerPanel'); // Abre el panel de edición
    };

    // Configura los listeners para los botones de eliminar banner
    function setupBannerDeleteListeners() {
        document.querySelectorAll('.delete-banner-btn').forEach(button => {
            button.removeEventListener('click', handleDeleteBannerButtonClick); // Previene múltiples listeners
            button.addEventListener('click', handleDeleteBannerButtonClick);
        });
    }
    // Manejador de clic para el botón de eliminar banner
    function handleDeleteBannerButtonClick(e) {
        e.stopPropagation(); // Evita que el clic se propague a otros elementos
        const itemId = this.dataset.itemId; 
        const itemType = this.dataset.itemType; 
        openConfirmDeleteModal(itemId, itemType); // Abre el modal de confirmación
    }

    // Configura los listeners para los botones de editar banner
    function setupBannerEditListeners() {
        document.querySelectorAll('.edit-banner-btn').forEach(button => {
            button.removeEventListener('click', handleEditBannerButtonClick); // Previene múltiples listeners
            button.addEventListener('click', handleEditBannerButtonClick);
        });
    }
    // Manejador de clic para el botón de editar banner
    function handleEditBannerButtonClick(e) {
        e.stopPropagation(); // Evita que el clic se propague
        const bannerId = this.dataset.bannerId;
        openViewBannerModal(bannerId); // Abre el panel de edición con los datos del banner
    }
    
    // Función para actualizar los contadores de banners en el dashboard
    function updateBannerMetrics() {
        let total = Object.keys(bannersActuales).length; // Número total de banners
        let newThisMonth = 0;
        const currentMonth = new Date().getMonth();
        const currentYear = new Date().getFullYear();

        // Cuenta cuántos banners fueron creados este mes
        Object.values(bannersActuales).forEach(banner => {
            // Asegura que 'created_at' exista y sea una fecha válida
            if (banner.created_at) {
                const createdAt = new Date(banner.created_at);
                if (createdAt.getFullYear() === currentYear && createdAt.getMonth() === currentMonth) {
                    newThisMonth++;
                }
            }
        });

        // Actualiza los elementos HTML con los nuevos conteos
        if (totalBannersCountElement) totalBannersCountElement.textContent = total.toString();
        if (newBannersThisMonthCountElement) newBannersThisMonthCountElement.textContent = newThisMonth.toString();
    }


    // Crea el HTML para una tarjeta de banner (vista de cuadrícula)
    function renderBannerCard(banner) {
        const card = document.createElement('div');
        card.className = 'bg-white rounded-xl shadow-md overflow-hidden flex flex-col border border-gray-200';
        card.dataset.bannerId = banner.id;
        card.dataset.itemId = banner.id;

        const imageUrl = banner.image_url || '';
        const imageHtml = imageUrl ? 
            `<img src="${imageUrl}" alt="Imagen de ${banner.title}" class="w-full h-32 object-cover">` :
            `<div class="w-full h-32 bg-gray-200 flex items-center justify-center text-gray-500"><i data-lucide="image" class="w-12 h-12"></i></div>`;

        // Icono de estado para la tarjeta
        const statusIcon = banner.status === 'active' ?
            `<span class="px-2 py-1 rounded-full text-xs font-semibold uppercase bg-green-100 text-green-800 flex items-center gap-1"><i data-lucide="check-circle" class="w-4 h-4"></i> Activo</span>` :
            `<span class="px-2 py-1 rounded-full text-xs font-semibold uppercase bg-gray-100 text-gray-600 flex items-center gap-1"><i data-lucide="archive" class="w-4 h-4"></i> Archivado</span>`;


        card.innerHTML = `
            <div class="relative">
                ${imageHtml}
                <div class="absolute inset-0 flex items-center justify-center bg-black bg-opacity-50 text-white opacity-0 hover:opacity-100 transition-opacity duration-300 cursor-pointer" onclick="openViewBannerModal('${banner.id}')">
                    <i data-lucide="eye" class="w-16 h-16"></i>
                </div>
            </div>
            <div class="p-4 flex-grow flex flex-col">
                <h3 class="font-bold text-lg text-gray-800 mb-2 uppercase line-clamp-2">${banner.title}</h3>
                <p class="text-gray-700 text-sm flex-grow mb-2 line-clamp-3">${banner.link_url || 'Sin URL de enlace.'}</p>
                <div class="flex justify-between items-center text-gray-500 text-xs mt-auto">
                    <span>Agregado: <span class="font-semibold">${new Date(banner.created_at).toLocaleDateString()}</span></span>
                    ${statusIcon}
                </div>
            </div>
            <div class="bg-gray-100 p-3 flex justify-end space-x-3 border-t border-gray-200">
                <a href="${banner.link_url}" target="_blank" class="bg-blue-100 hover:bg-blue-200 text-blue-600 font-semibold py-2 px-4 rounded-lg text-sm uppercase inline-flex items-center justify-center gap-1">
                    <i data-lucide="external-link" class="w-4 h-4"></i> Ir
                </a>
                <button class="bg-gray-200 hover:bg-gray-300 text-gray-800 font-semibold py-2 px-4 rounded-lg text-sm uppercase edit-banner-btn" data-banner-id="${banner.id}">EDITAR</button>
                <button class="p-2 bg-red-100 hover:bg-red-200 text-red-600 rounded-lg delete-banner-btn" data-item-type="banner" data-item-id="${banner.id}" title="ELIMINAR BANNER"><i data-lucide="trash-2" class="w-5 h-5"></i></button>
            </div>
        `;
        // Asegurarse de que los íconos de Lucide se rendericen dentro de la tarjeta creada
        lucide.createIcons({ container: card });
        return card;
    } 

    // Crea el HTML para una fila de tabla de banner (vista de lista)
    function renderBannerTableRow(banner) {
        const row = document.createElement('tr');
        row.className = 'border-b border-gray-200 hover:bg-gray-50';
        row.dataset.bannerId = banner.id;
        row.dataset.itemId = banner.id;

        const shortLink = banner.link_url ? new URL(banner.link_url).hostname : 'N/A';
        const statusText = banner.status === 'active' ?
            `<span class="px-2 py-1 rounded-full text-xs font-semibold uppercase bg-green-100 text-green-800 flex items-center justify-center gap-1"><i data-lucide="check-circle" class="w-4 h-4"></i> Activo</span>` :
            `<span class="px-2 py-1 rounded-full text-xs font-semibold uppercase bg-gray-100 text-gray-600 flex items-center justify-center gap-1"><i data-lucide="archive" class="w-4 h-4"></i> Archivado</span>`;

        row.innerHTML = `
            <td class="py-4 px-6 whitespace-nowrap">
                <span class="text-blue-600 hover:text-blue-800 cursor-pointer font-semibold uppercase" onclick="openViewBannerModal('${banner.id}')">${banner.title}</span>
            </td>
            <td class="py-4 px-6 hidden md:table-cell">
                ${banner.image_url ? `<img src="${banner.image_url}" alt="Miniatura" class="w-16 h-auto object-cover rounded-md">` : 'N/A'}
            </td>
            <td class="py-4 px-6">
                <a href="${banner.link_url}" target="_blank" class="text-blue-500 hover:underline flex items-center gap-1">
                    <i data-lucide="external-link" class="w-4 h-4"></i> ${shortLink}
                </a>
            </td>
            <td class="py-4 px-6 text-center">${statusText}</td>
            <td class="py-4 px-6 text-center">
                <button class="text-blue-600 hover:text-blue-800 mr-3 edit-banner-btn" title="EDITAR BANNER" data-banner-id="${banner.id}"><i data-lucide="edit-2" class="w-5 h-5"></i></button>
                <button class="text-red-600 hover:text-red-800 delete-banner-btn" data-item-type="banner" data-item-id="${banner.id}" title="ELIMINAR BANNER"><i data-lucide="trash-2" class="w-5 h-5"></i></button>
            </td>
        `;
        // Asegurarse de que los íconos de Lucide se rendericen dentro de la fila creada
        lucide.createIcons({ container: row });
        return row;
    }

    // Renderiza (dibuja) todos los banners en la vista seleccionada (cuadrícula o lista)
    function renderBanners(viewType = currentBannerView) {
        // Verifica que todos los elementos HTML necesarios existan antes de intentar manipularlos
        if (!bannerGridView || !bannerListView || !bannersTableBody || !bannerSearch || !bannerGridViewBtn || !bannerListViewBtn) {
                console.error("[comunicaciones.php] ERROR: Elementos DOM de Banners no encontrados. Verifique los IDs de los elementos HTML."); return;
        }
        const searchTerm = bannerSearch.value.toLowerCase(); // Obtiene el texto de búsqueda

        // Convierte el objeto de banners a un array para poder filtrarlo
        const allBannersArray = Object.values(bannersActuales); 

        console.log("renderBanners: bannersActuales antes de filtrar:", allBannersArray);

        // Filtra los banners según el término de búsqueda
        const filteredBanners = allBannersArray.filter(b => {
            const matchesSearch = searchTerm === '' || 
                                    (b.title && b.title.toLowerCase().includes(searchTerm)) || 
                                    (b.link_url && b.link_url.toLowerCase().includes(searchTerm));
            return matchesSearch;
        });

        console.log("renderBanners: banners filtrados:", filteredBanners);

        // Limpia las vistas actuales antes de renderizar
        bannerGridView.innerHTML = '';
        bannersTableBody.innerHTML = '';

        if (filteredBanners.length === 0) {
            // Muestra un mensaje si no se encuentran banners
            const message = `<p class="text-gray-500 md:col-span-2 lg:col-span-3 text-center uppercase">NO SE ENCONTRARON BANNERS.</p>`;
            if (viewType === 'grid') {
                bannerGridView.innerHTML = message;
            } else {
                bannersTableBody.innerHTML = `<tr><td colspan="5" class="py-4 px-6 text-center text-gray-500 uppercase">NO SE ENCONTRARON BANNERS.</td></tr>`; // Ajustar colspan
            }
        } else {
            // Renderiza los banners en la vista seleccionada
            if (viewType === 'grid') {
                filteredBanners.forEach(banner => bannerGridView.appendChild(renderBannerCard(banner)));
            } else {
                filteredBanners.forEach(banner => bannersTableBody.appendChild(renderBannerTableRow(banner)));
            }
        }

        // Vuelve a configurar los listeners para los botones de eliminar y editar (necesario después de cada renderizado)
        setupBannerDeleteListeners();
        setupBannerEditListeners();
        // Los iconos de Lucide ya se crean dentro de renderBannerCard/renderBannerTableRow
    }


    // --- NOTIFICACIONES: FUNCIONES DE RENDERIZADO Y LÓGICA ---

    // Abre el panel para ver/editar una notificación existente
    window.openViewNotificationModal = function(notificationId) {
        const notification = notificationsActuales[notificationId];
        if (!notification) { console.error('Notificación no encontrada:', notificationId); return; }
        
        // Rellena los campos del formulario con los datos de la notificación
        document.getElementById('view-notification-id').value = notification.db_id;
        document.getElementById('view-notification-internal-id').value = notification.id; // Guarda el ID interno
        document.getElementById('view-notification-title').value = notification.title;
        document.getElementById('view-notification-description').value = notification.description || '';
        document.getElementById('view-notification-internal-url').value = notification.internal_url || '';
        document.getElementById('view-notification-external-url').value = notification.external_url || '';

        // Establece el estado activo/archivado
        if (notification.status === 'active') {
            viewNotificationStatusActiveRadio.checked = true;
        } else {
            viewNotificationStatusArchivedRadio.checked = true;
        }

        openPanel('viewNotificationPanel'); // Abre el panel de edición
    };

    // Configura los listeners para los botones de eliminar notificación
    function setupNotificationDeleteListeners() {
        document.querySelectorAll('.delete-notification-btn').forEach(button => {
            button.removeEventListener('click', handleDeleteNotificationButtonClick);
            button.addEventListener('click', handleDeleteNotificationButtonClick);
        });
    }
    // Manejador de clic para el botón de eliminar notificación
    function handleDeleteNotificationButtonClick(e) {
        e.stopPropagation();
        const itemId = this.dataset.itemId; 
        const itemType = this.dataset.itemType; 
        openConfirmDeleteModal(itemId, itemType);
    }

    // Configura los listeners para los botones de editar notificación
    function setupNotificationEditListeners() {
        document.querySelectorAll('.edit-notification-btn').forEach(button => {
            button.removeEventListener('click', handleEditNotificationButtonClick);
            button.addEventListener('click', handleEditNotificationButtonClick);
        });
    }
    // Manejador de clic para el botón de editar notificación
    function handleEditNotificationButtonClick(e) {
        e.stopPropagation();
        const notificationId = this.dataset.notificationId;
        openViewNotificationModal(notificationId);
    }
    
    // Función para actualizar los contadores de notificaciones en el dashboard
    function updateNotificationMetrics() {
        let total = Object.keys(notificationsActuales).length; // Número total de notificaciones
        let newThisMonth = 0;
        const currentMonth = new Date().getMonth();
        const currentYear = new Date().getFullYear();

        // Cuenta cuántas notificaciones fueron creadas este mes
        Object.values(notificationsActuales).forEach(notification => {
            // Asegura que 'created_at' exista y sea una fecha válida
            if (notification.created_at) {
                const createdAt = new Date(notification.created_at);
                if (createdAt.getFullYear() === currentYear && createdAt.getMonth() === currentMonth) {
                    newThisMonth++;
                }
            }
        });

        // Actualiza los elementos HTML con los nuevos conteos
        if (totalNotificationsCountElement) totalNotificationsCountElement.textContent = total.toString();
        if (newNotificationsThisMonthCountElement) newNotificationsThisMonthCountElement.textContent = newThisMonth.toString();
    }

    // Crea el HTML para una fila de tabla de notificación (siempre vista de lista para notificaciones)
    function renderNotificationRow(notification) {
        const row = document.createElement('tr');
        row.className = 'border-b border-gray-200 hover:bg-gray-50';
        row.dataset.notificationId = notification.id;
        row.dataset.itemId = notification.id;

        const shortDescription = notification.description ? notification.description.substring(0, 70) + (notification.description.length > 70 ? '...' : '') : 'N/A';
        
        let linkHtml = 'N/A';
        if (notification.external_url) {
            const displayUrl = notification.external_url.replace(/^(https?:\/\/)?(www\.)?/,'').split('/')[0];
            linkHtml = `<a href="${notification.external_url}" target="_blank" class="text-blue-500 hover:underline flex items-center gap-1"><i data-lucide="external-link" class="w-4 h-4"></i> ${displayUrl}</a>`;
        } else if (notification.internal_url) {
            linkHtml = `<a href="${notification.internal_url}" class="text-blue-500 hover:underline flex items-center gap-1"><i data-lucide="link" class="w-4 h-4"></i> ${notification.internal_url}</a>`;
        }

        const statusText = notification.status === 'active' ?
            `<span class="px-2 py-1 rounded-full text-xs font-semibold uppercase bg-green-100 text-green-800 flex items-center justify-center gap-1"><i data-lucide="check-circle" class="w-4 h-4"></i> Activa</span>` :
            `<span class="px-2 py-1 rounded-full text-xs font-semibold uppercase bg-gray-100 text-gray-600 flex items-center justify-center gap-1"><i data-lucide="archive" class="w-4 h-4"></i> Archivada</span>`;

        row.innerHTML = `
            <td class="py-4 px-6 whitespace-nowrap">
                <span class="text-blue-600 hover:text-blue-800 cursor-pointer font-semibold uppercase" onclick="openViewNotificationModal('${notification.id}')">${notification.title}</span>
            </td>
            <td class="py-4 px-6 hidden md:table-cell uppercase">${shortDescription}</td>
            <td class="py-4 px-6">${linkHtml}</td>
            <td class="py-4 px-6 text-center">${statusText}</td>
            <td class="py-4 px-6 text-center">
                <button class="text-blue-600 hover:text-blue-800 mr-3 edit-notification-btn" title="EDITAR NOTIFICACIÓN" data-notification-id="${notification.id}"><i data-lucide="edit-2" class="w-5 h-5"></i></button>
                <button class="text-red-600 hover:text-red-800 delete-notification-btn" data-item-type="notificación" data-item-id="${notification.id}" title="ELIMINAR NOTIFICACIÓN"><i data-lucide="trash-2" class="w-5 h-5"></i></button>
            </td>
        `;
        // Asegurarse de que los íconos de Lucide se rendericen dentro de la fila creada
        lucide.createIcons({ container: row });
        return row;
    }

    // Renderiza (dibuja) todas las notificaciones en la tabla
    function renderNotifications() {
        // Verifica que todos los elementos HTML necesarios existan
        if (!notificationListView || !notificationsTableBody || !notificationSearch) {
                console.error("[comunicaciones.php] ERROR: Elementos DOM de Notificaciones no encontrados. Verifique los IDs de los elementos HTML."); return;
        }
        const searchTerm = notificationSearch.value.toLowerCase(); // Obtiene el texto de búsqueda
        
        // Convierte el objeto de notificaciones a un array para poder filtrarlo
        const allNotificationsArray = Object.values(notificationsActuales); 

        console.log("renderNotifications: notificationsActuales antes de filtrar:", allNotificationsArray);

        // Filtra las notificaciones según el término de búsqueda
        const filteredNotifications = allNotificationsArray.filter(n => {
            const matchesSearch = searchTerm === '' || 
                                    (n.title && n.title.toLowerCase().includes(searchTerm)) || 
                                    (n.description && n.description.toLowerCase().includes(searchTerm));
            return matchesSearch;
        });

        console.log("renderNotifications: notificaciones filtradas:", filteredNotifications);

        notificationsTableBody.innerHTML = ''; // Limpia la tabla antes de renderizar

        if (filteredNotifications.length === 0) {
            // Muestra un mensaje si no se encuentran notificaciones
            notificationsTableBody.innerHTML = `<tr><td colspan="5" class="py-4 px-6 text-center text-gray-500 uppercase">NO SE ENCONTRARON NOTIFICACIONES.</td></tr>`; // Ajustar colspan
        } else {
            // Renderiza las notificaciones en la tabla
            filteredNotifications.forEach(notification => notificationsTableBody.appendChild(renderNotificationRow(notification)));
        }

        // Vuelve a configurar los listeners para los botones (necesario después de cada renderizado)
        setupNotificationDeleteListeners();
        setupNotificationEditListeners();
        // Los iconos de Lucide ya se crean dentro de renderNotificationRow
    }


    // Funciones de formato de teléfono (no usadas en esta página, pero incluidas para referencia si se necesitaran en el futuro)
    function formatPhoneNumber(value) {
        if (!value) return '';
        const cleaned = ('' + value).replace(/\D/g, '');    
        const match = cleaned.match(/^(\d{3})(\d{3})(\d{4})$/);
        if (match) {
            return `(${match[1]}) ${match[2]}-${match[3]}`;
        }
        return cleaned;    
    }

    function applyInputPhoneFormat(inputElement) {
        if (!inputElement) return;
        inputElement.value = formatPhoneNumber(inputElement.value);
        inputElement.addEventListener('input', (e) => {
            let value = e.target.value.replace(/\D/g, '');    
            e.target.value = formatPhoneNumber(value);
        });
        inputElement.addEventListener('blur', (e) => {
            e.target.value = formatPhoneNumber(e.target.value);
        });
    }

    // Esto se mantiene, pero no hace nada ya que no hay campos de teléfono aquí
    function applyPhoneFormatToInputs() {
        // No hay campos de teléfono en esta página.
    }


    // --- INICIALIZACIÓN DE LA PÁGINA ---
    // Esta es la función principal que se ejecuta una vez que el DOM está completamente cargado.

    // 1. Mostrar notificación PHP si existe (por ejemplo, si vienes de un formulario)
    const phpNotificationMessage = "<?php echo addslashes($notification_message); ?>";
    const phpNotificationType = "<?php echo addslashes($notification_type); ?>";
    if (phpNotificationMessage) {
        showCustomNotification(phpNotificationMessage, phpNotificationType);
    }

    // 2. Configurar eventos de la barra lateral (menú móvil)
    if (mobileMenuButton) {
        // Asegúrate de que `toggleSidebar` esté definido en `header-manager.js`
        mobileMenuButton.addEventListener('click', typeof toggleSidebar === 'function' ? toggleSidebar : () => console.error('toggleSidebar function not found'));
    }

    // Cierra paneles y overlay si se hace clic en el overlay del sidebar (para móviles)
    if (sidebarOverlay) {
        sidebarOverlay.addEventListener('click', () => {
            if (typeof toggleSidebar === 'function') toggleSidebar();
            closePanel('addBannerPanel'); 
            closePanel('viewBannerPanel');
            closePanel('addNotificationPanel');
            closePanel('viewNotificationPanel');
        });
    }
    // Este listener en panelOverlay es crucial para cerrar los paneles laterales cuando se hace clic fuera de ellos
    if (panelOverlay) {
        panelOverlay.addEventListener('click', () => {    
            closePanel('addBannerPanel');
            closePanel('viewBannerPanel');
            closePanel('addNotificationPanel');
            closePanel('viewNotificationPanel');
        });
    }
    if (sidebarCloseBtn) {
        if (typeof toggleSidebar === 'function') sidebarCloseBtn.addEventListener('click', toggleSidebar);
    }
    
    // Si la función `toggleSidebar` no está en `header-manager.js` por alguna razón,
    // puedes descomentar este bloque para una definición básica:
    /*
    if (typeof window.toggleSidebar === 'undefined') {
        window.toggleSidebar = function() {
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebar-overlay');
            if (sidebar && sidebarOverlay) {
                sidebar.classList.toggle('-translate-x-full');
                sidebarOverlay.classList.toggle('hidden');
            }
        };
    }
    */


    // --- BANNERS: Lógica de inicialización y eventos ---
    updateBannerMetrics(); // Actualiza los contadores de banners al cargar la página
    renderBanners(currentBannerView); // Renderiza los banners inicialmente en la vista de cuadrícula
    console.log("[comunicaciones.php] Banners renderizados.");

    // Evento de búsqueda para banners
    if (bannerSearch) bannerSearch.addEventListener('input', () => renderBanners(currentBannerView));

    // Lógica para el botón de confirmación de eliminación (compartido para banners y notificaciones)
    if (confirmDeleteButton) {
        confirmDeleteButton.addEventListener('click', function() {
            const itemId = this.dataset.itemId;
            const itemType = this.dataset.itemType; // 'banner' o 'notificación'
            
            if (itemType === 'banner') {
                if (bannersActuales[itemId]) { 
                    // Simulamos que la eliminación fue exitosa
                    const data = { success: true, message: "Banner eliminado simuladamente." };
                    if (data.success) {
                        closeModal('confirmDeleteModal');
                        showCustomNotification('Banner eliminado con éxito (simulado).', 'success');
                        delete bannersActuales[itemId]; // Elimina el banner del objeto de datos
                        updateBannerMetrics(); // Actualiza los contadores
                        renderBanners(currentBannerView); // Vuelve a dibujar la lista de banners
                    } else {
                        showCustomNotification('Error al eliminar banner (simulado): ' + data.message, 'error');
                    }
                } else {
                    showCustomNotification('Error: Banner no encontrado para eliminar (simulado).', 'error');
                }
            } else if (itemType === 'notificación') { 
                if (notificationsActuales[itemId]) {
                    // Simulamos que la eliminación fue exitosa
                    const data = { success: true, message: "Notificación eliminada simuladamente." };
                    if (data.success) {
                        closeModal('confirmDeleteModal');
                        showCustomNotification('Notificación eliminada con éxito (simulado).', 'success');
                        delete notificationsActuales[itemId]; // Elimina la notificación del objeto de datos
                        updateNotificationMetrics(); // Actualiza los contadores
                        renderNotifications(); // Vuelve a dibujar la lista de notificaciones
                    } else {
                        showCustomNotification('Error al eliminar notificación (simulado): ' + data.message, 'error');
                    }
                } else {
                    showCustomNotification('Error: Notificación no encontrada para eliminar (simulado).', 'error');
                }
            }
        });
    }

    // Manejo de clics para los botones de vista (cuadrícula/lista) para banners
    if (bannerGridViewBtn) {
        bannerGridViewBtn.addEventListener('click', () => {
            currentBannerView = 'grid';
            renderBanners('grid');
        });
    }
    if (bannerListViewBtn) {
        bannerListViewBtn.addEventListener('click', () => {
            currentBannerView = 'list';
            renderBanners('list');
        });
    }

    // Lógica para el formulario de añadir nuevos banners
    if (addBannerForm) {
        addBannerForm.addEventListener('submit', async function(e) {    
            e.preventDefault(); // Previene el envío del formulario tradicional
            const bannerData = {
                title: document.getElementById('banner-title').value,
                image_url: document.getElementById('banner-image-url').value,
                link_url: document.getElementById('banner-link-url').value,
                status: 'archived' // Nuevo banner por defecto se archiva
            };

            try {    
                // Generar un ID único para el nuevo banner simulado
                const currentBannerValues = Object.values(bannersActuales);
                // Si no hay banners, empieza en 0 para que Math.max funcione. Luego +1.
                const currentBannerIds = currentBannerValues.length > 0 ? currentBannerValues.map(b => parseInt(b.id.replace('banner-', '')) || 0) : [0];
                const newIdNumeric = Math.max(...currentBannerIds) + 1; // Encuentra el ID numérico más alto y le suma 1
                const newId = 'banner-' + newIdNumeric; // El ID de string para usar como clave en el objeto JS

                // Simulación de respuesta de éxito del "servidor"
                const data = {    
                    success: true,    
                    message: "Banner agregado simuladamente.",
                    banner: {    
                        id: newIdNumeric, // Esto simula el ID que la base de datos daría
                        title: bannerData.title,
                        image_url: bannerData.image_url,
                        link_url: bannerData.link_url,
                        created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), // Fecha actual
                        status: bannerData.status
                    }
                };

                if (data.success) {
                    closePanel('addBannerPanel'); // Cierra el panel
                    addBannerForm.reset(); // Limpia el formulario
                    showCustomNotification('Banner agregado con éxito (simulado).', 'success');
                    // Añade el nuevo banner a nuestro objeto de datos simulados
                    bannersActuales[newId] = {    
                        id: newId, // El ID de string
                        db_id: data.banner.id, // El ID numérico simulado
                        title: data.banner.title,
                        image_url: data.banner.image_url,
                        link_url: data.banner.link_url,
                        created_at: data.banner.created_at,
                        status: data.banner.status
                    };
                    updateBannerMetrics(); // Actualiza los contadores
                    renderBanners(currentBannerView); // Vuelve a dibujar los banners para mostrar el nuevo
                } else {
                    showCustomNotification('Error al agregar banner (simulado): ' + (data.message || 'Error desconocido.'), 'error');
                }
            } catch (error) {
                showCustomNotification('Error de conexión al agregar el banner (simulado).', 'error');
                console.error('Create banner error (simulado):', error);
            }
        });
    }

    // Lógica para el formulario de ver/editar banners
    if (viewBannerForm) {
        viewBannerForm.addEventListener('submit', async function(e) {    
            e.preventDefault(); // Previene el envío del formulario tradicional
            const internalId = document.getElementById('view-banner-internal-id').value; // ID interno de JS
            const newStatus = document.querySelector('input[name="banner_status"]:checked').value;

            const bannerData = {
                id: document.getElementById('view-banner-id').value, // Esto es el `db_id` numérico
                title: document.getElementById('view-banner-title').value,
                image_url: document.getElementById('view-banner-image-url').value,
                link_url: document.getElementById('view-banner-link-url').value,
                status: newStatus
            };
            
            try {    
                // Simulación de respuesta de éxito del "servidor"
                const data = {    
                    success: true,    
                    message: "Cambios guardados simuladamente.",
                    banner: {    
                        id: bannerData.id, // El db_id que se "envió"
                        title: bannerData.title,
                        image_url: bannerData.image_url,
                        link_url: bannerData.link_url,
                        created_at: bannersActuales[internalId].created_at, // Mantenemos la fecha de creación original
                        status: bannerData.status
                    }
                };

                if (data.success) {
                    // Si el nuevo estado es 'active', archivar todos los demás banners
                    if (newStatus === 'active') {
                        for (const key in bannersActuales) {
                            if (key !== internalId && bannersActuales[key].status === 'active') {
                                bannersActuales[key].status = 'archived';
                            }
                        }
                    }

                    closePanel('viewBannerPanel'); // Cierra el panel
                    showCustomNotification('Cambios guardados con éxito (simulado).', 'success');
                    // Actualiza el banner en nuestro objeto de datos simulados
                    if (bannersActuales[internalId]) {
                        bannersActuales[internalId] = {
                            id: internalId, // El ID de string
                            db_id: data.banner.id, // El ID numérico simulado
                            title: data.banner.title,
                            image_url: data.banner.image_url,
                            link_url: data.banner.link_url,
                            created_at: data.banner.created_at,
                            status: data.banner.status
                        };
                    }
                    renderBanners(currentBannerView); // Vuelve a dibujar los banners para mostrar los cambios
                } else {
                    showCustomNotification('Error al guardar cambios (simulado): ' + (data.message || 'Error desconocido.'), 'error');
                }
            } catch (error) {
                showCustomNotification('Error de conexión al guardar los cambios (simulado).', 'error');
                console.error('Update banner error (simulado):', error);
            }
        });
    }

    // Listener para actualizar la imagen de previsualización en el panel de añadir cuando cambia la URL del input
    if (addBannerImageUrlInput && addBannerImagePreview) {
        addBannerImageUrlInput.addEventListener('input', function() {
            const url = this.value;
            if (url) {
                addBannerImagePreview.innerHTML = `<img src="${url}" alt="Miniatura de banner" class="w-full h-full object-cover rounded-lg">`;
            } else {
                addBannerImagePreview.innerHTML = `<i data-lucide="image" class="w-12 h-12 text-gray-500"></i>`;
            }
            lucide.createIcons({ container: addBannerImagePreview });
        });
    }

    // Listener para actualizar la imagen de previsualización en el panel de edición cuando cambia la URL del input
    if (viewBannerImageUrlInput && viewBannerImagePreview) {
        viewBannerImageUrlInput.addEventListener('input', function() {
            const url = this.value;
            if (url) {
                viewBannerImagePreview.innerHTML = `<img src="${url}" alt="Miniatura de banner" class="w-full h-full object-cover rounded-lg">`;
            } else {
                viewBannerImagePreview.innerHTML = `<i data-lucide="image" class="w-12 h-12 text-gray-500"></i>`;
            }
            lucide.createIcons({ container: viewBannerImagePreview });
        });
    }

    // Listener para el botón "Agregar Banner"
    if (addBannerBtn) {
        addBannerBtn.addEventListener('click', () => {
            openPanel('addBannerPanel');
        });
    }

    // --- NOTIFICACIONES: Lógica de inicialización y eventos ---
    updateNotificationMetrics(); // Actualiza los contadores de notificaciones al cargar la página
    renderNotifications(); // Renderiza las notificaciones inicialmente
    console.log("[comunicaciones.php] Notificaciones renderizadas.");

    // Evento de búsqueda para notificaciones
    if (notificationSearch) notificationSearch.addEventListener('input', () => renderNotifications());

    // Lógica para el formulario de añadir nuevas notificaciones
    if (addNotificationForm) {
        addNotificationForm.addEventListener('submit', async function(e) {    
            e.preventDefault(); // Previene el envío del formulario tradicional
            const notificationData = {
                title: document.getElementById('notification-title').value,
                description: document.getElementById('notification-description').value,
                internal_url: document.getElementById('notification-internal-url').value || null,
                external_url: document.getElementById('notification-external-url').value || null,
                status: 'archived' // Nueva notificación por defecto se archiva
            };

            // Validar que al menos una URL se proporcione
            if (!notificationData.title) {
                showCustomNotification('El título de la notificación no puede estar vacío.', 'error');
                return;
            }
            if (!notificationData.description) {
                showCustomNotification('La descripción de la notificación no puede estar vacía.', 'error');
                return;
            }
            if (!notificationData.internal_url && !notificationData.external_url) {
                showCustomNotification('Debes proporcionar al menos una URL (interna o externa).', 'error');
                return; // Detiene el proceso si falta una URL
            }

            try {    
                // Generar un ID único para la nueva notificación simulada
                const currentNotificationValues = Object.values(notificationsActuales);
                // Si no hay notificaciones, empieza en 0 para que Math.max funcione. Luego +1.
                const currentNotificationIds = currentNotificationValues.length > 0 ? currentNotificationValues.map(n => parseInt(n.id.replace('notif-', '')) || 0) : [0];
                const newIdNumeric = Math.max(...currentNotificationIds) + 1; // Encuentra el ID numérico más alto y le suma 1
                const newId = 'notif-' + newIdNumeric; // El ID de string para usar como clave en el objeto JS

                // Simulación de respuesta de éxito del "servidor"
                const data = {    
                    success: true,    
                    message: "Notificación enviada simuladamente.",
                    notification: {    
                        id: newIdNumeric, // Esto simula el ID que la base de datos daría
                        title: notificationData.title,
                        description: notificationData.description,
                        internal_url: notificationData.internal_url,
                        external_url: notificationData.external_url,
                        created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), // Fecha actual
                        status: notificationData.status
                    }
                };

                if (data.success) {
                    closePanel('addNotificationPanel'); // Cierra el panel
                    addNotificationForm.reset(); // Limpia el formulario
                    showCustomNotification('Notificación enviada con éxito (simulado).', 'success');
                    // Añade la nueva notificación a nuestro objeto de datos simulados
                    notificationsActuales[newId] = {    
                        id: newId,
                        db_id: data.notification.id,
                        title: data.notification.title,
                        description: data.notification.description,
                        internal_url: data.notification.internal_url,
                        external_url: data.notification.external_url,
                        created_at: data.notification.created_at,
                        status: data.notification.status
                    };
                    updateNotificationMetrics(); // Actualiza los contadores
                    renderNotifications(); // Vuelve a dibujar las notificaciones para mostrar la nueva
                } else {
                    showCustomNotification('Error al enviar notificación (simulado): ' + (data.message || 'Error desconocido.'), 'error');
                }
            } catch (error) {
                showCustomNotification('Error de conexión al enviar la notificación (simulado).', 'error');
                console.error('Create notification error (simulado):', error);
            }
        });
    }

    // Lógica para el formulario de ver/editar notificaciones
    if (viewNotificationForm) {
        viewNotificationForm.addEventListener('submit', async function(e) {    
            e.preventDefault(); // Previene el envío del formulario tradicional
            const internalId = document.getElementById('view-notification-internal-id').value; // ID interno de JS
            const newStatus = document.querySelector('input[name="notification_status"]:checked').value;

            const notificationData = {
                id: document.getElementById('view-notification-id').value, // Esto es el `db_id` numérico
                title: document.getElementById('view-notification-title').value,
                description: document.getElementById('view-notification-description').value,
                internal_url: document.getElementById('view-notification-internal-url').value || null,
                external_url: document.getElementById('view-notification-external-url').value || null,
                status: newStatus
            };

            // Validar que al menos una URL se proporcione antes de guardar cambios
            if (!notificationData.title) {
                showCustomNotification('El título de la notificación no puede estar vacío.', 'error');
                return;
            }
            if (!notificationData.description) {
                showCustomNotification('La descripción de la notificación no puede estar vacía.', 'error');
                return;
            }
            if (!notificationData.internal_url && !notificationData.external_url) {
                showCustomNotification('Debes proporcionar al menos una URL (interna o externa).', 'error');
                return; // Detiene el proceso
            }
            
            try {    
                // Simulación de respuesta de éxito del "servidor"
                const data = {    
                    success: true,    
                    message: "Cambios guardados simuladamente.",
                    notification: {    
                        id: notificationData.id, // El db_id que se "envió"
                        title: notificationData.title,
                        description: notificationData.description,
                        internal_url: notificationData.internal_url,
                        external_url: notificationData.external_url,
                        created_at: notificationsActuales[internalId].created_at, // Mantenemos la fecha de creación original
                        status: notificationData.status
                    }
                };

                if (data.success) {
                    // Si el nuevo estado es 'active', archivar todas las demás notificaciones
                    if (newStatus === 'active') {
                        for (const key in notificationsActuales) {
                            if (key !== internalId && notificationsActuales[key].status === 'active') {
                                notificationsActuales[key].status = 'archived';
                            }
                        }
                    }

                    closePanel('viewNotificationPanel'); // Cierra el panel
                    showCustomNotification('Cambios guardados con éxito (simulado).', 'success');
                    // Actualiza la notificación en nuestro objeto de datos simulados
                    if (notificationsActuales[internalId]) {
                        notificationsActuales[internalId] = {
                            id: internalId,
                            db_id: data.notification.id,
                            title: data.notification.title,
                            description: data.notification.description,
                            internal_url: data.notification.internal_url,
                            external_url: data.notification.external_url,
                            created_at: data.notification.created_at,
                            status: data.notification.status
                        };
                    }
                    renderNotifications(); // Vuelve a dibujar las notificaciones para mostrar los cambios
                } else {
                    showCustomNotification('Error al guardar cambios (simulado): ' + (data.message || 'Error desconocido.'), 'error');
                }
            } catch (error) {
                showCustomNotification('Error de conexión al guardar los cambios (simulado).', 'error');
                console.error('Update notification error (simulado):', error);
            }
        });
    }

    // Listener para el botón "Enviar Notificación"
    if (addNotificationBtn) {
        addNotificationBtn.addEventListener('click', () => {
            openPanel('addNotificationPanel');
        });
    }

    // Renderiza todos los íconos de Lucide estáticos al final de la carga del DOM
    lucide.createIcons();
});
</script>
</body>
</html>