<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

// Solo permitir solicitudes POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

// Obtener y decodificar los datos JSON de la solicitud
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que todos los datos requeridos estén presentes
$required_fields = [
    'business_name', 'service_type', 'service_zone', 'service_price',
    'main_objective', 'desired_new_clients', 'commitment_level',
    'business_stage', 'has_website_optimized', 'monthly_budget',
    'prior_ad_investment', 'facebook_page_optimized'
];

foreach ($required_fields as $field) {
    if (!isset($data[$field]) || (is_string($data[$field]) && trim($data[$field]) === '')) {
        http_response_code(400);
        echo json_encode(['error' => "Falta el campo requerido: '{$field}'. Asegúrate de completar todos los datos."]);
        exit;
    }
}

// Asegurar que los valores numéricos sean tratados como tal
$service_price = floatval($data['service_price']);
$desired_new_clients = intval($data['desired_new_clients']);
$monthly_budget = floatval($data['monthly_budget']);

// Calcular el costo por cliente si la meta es alcanzar el punto de equilibrio
$cost_per_client_goal = ($desired_new_clients > 0) ? $monthly_budget / $desired_new_clients : 0;
$clients_to_break_even = ($service_price > 0) ? ceil($monthly_budget / $service_price) : 0;

// --- PROMPT MAESTRO (v1.0 - PLAN TÁCTICO CON REALISMO) ---
$prompt = "Actúa como un estratega de marketing digital para negocios locales con poco o nulo conocimiento en publicidad. Tu tarea es generar un plan táctico publicitario REALISTA, estratégico y fácil de entender, adaptado a su presupuesto, objetivos y situación actual. Siempre habla directamente al usuario (Tú, Tu negocio, Tu plan...).

--- FILOSOFÍA CLIENT3 ---
- Enfocado en atraer clientes locales.
- Prioriza empezar con campañas de 'Mensajes' por su simplicidad.
- El presupuesto mínimo recomendado para publicidad efectiva es $5/día ($150/mes).
- La optimización de la página de Facebook y una web optimizada son cimientos clave.

--- TU TAREA ESPECÍFICA ---
Genera un plan táctico basado en los siguientes datos. El plan debe ser 100% realista y coherente con el presupuesto y situación del usuario. Si los objetivos son irreales dados los recursos, DEBES recalcarlo de forma constructiva y ajustar las expectativas.

--- DATOS DEL NEGOCIO ---
- Nombre del Negocio: {$data['business_name']}
- Tipo de Servicio/Producto: {$data['service_type']}
- Zona de Servicio: {$data['service_zone']}
- Precio Promedio del Servicio: \${$service_price}

--- OBJETIVOS Y EXPECTATIVAS ---
- Objetivo Principal de Publicidad: {$data['main_objective']}
- Clientes Nuevos Deseados al Mes: {$desired_new_clients}
- Nivel de Compromiso: {$data['commitment_level']}
- Etapa Actual del Negocio: {$data['business_stage']}
- ¿Página Web Profesional?: {$data['has_website_optimized']}

--- PRESUPUESTO PUBLICITARIO ---
- Presupuesto Mensual para Anuncios: \${$monthly_budget}
- ¿Ha Invertido en Publicidad Pagada Antes?: {$data['prior_ad_investment']}
- ¿Página de Facebook Optimizada?: {$data['facebook_page_optimized']}

--- CÁLCULOS CLAVE ---
- Clientes necesarios para cubrir inversión (\${$monthly_budget}): {$clients_to_break_even} clientes.

--- FORMATO DE RESPUESTA REQUERIDO (JSON) ---
La respuesta DEBE ser un objeto JSON válido con las siguientes claves:
- 'diagnostico_rapido': Un párrafo conciso que resume la situación actual del negocio.
- 'estimacion_clientes': Un párrafo que analiza la viabilidad del objetivo de clientes con el presupuesto. DEBES ser realista. Si el presupuesto es bajo o los objetivos son demasiado ambiciosos, explícalo claramente. Calcula y menciona cuántos clientes se necesitarían para cubrir la inversión publicitaria.
- 'plan_tactico': Un array de strings, cada string es un paso ACCIONABLE del plan.
    - El plan debe ser muy detallado y personalizado (3-5 pasos).
    - Los pasos deben estar ordenados cronológicamente (ej. Preparación, Lanzamiento, Optimización).
    - Incluye recomendaciones claras de herramientas CLIENT3 o módulos del curso donde sea relevante.
    - Si la web o FB no están optimizados, los primeros pasos DEBEN enfocarse en eso.
    - Adapta la complejidad de los pasos al 'Nivel de Compromiso' del usuario.
    - Si el presupuesto es menor a \$150, el primer paso DEBE recalcar que el presupuesto es bajo y que los resultados serán limitados, sugiriendo aumentarlo o ajustar expectativas.
- 'metricas_clave': Un párrafo explicando las 2-3 métricas más importantes a monitorear.
- 'recomendaciones_optimizacion': Un párrafo con consejos sencillos para mejorar el rendimiento a largo plazo.
";

// URL de la API de Google Gemini
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

// Inicializar cURL
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

// Manejo de errores de la solicitud cURL o respuesta HTTP
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response' => $response
    ]);
    exit;
}

// Decodificar la respuesta de la IA
$result = json_decode($response, true);

// Extraer el texto generado.
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? null;

// Limpiar el texto de posibles bloques de código Markdown
if ($generated_text) {
    $generated_text = str_replace(['```json', '```'], '', $generated_text);
}

// Intentar decodificar el JSON final.
$final_data = json_decode(trim($generated_text), true);

// Validar el formato del JSON final y su estructura
if ($final_data === null || !isset($final_data['diagnostico_rapido']) || !isset($final_data['estimacion_clientes']) || !isset($final_data['plan_tactico']) || !isset($final_data['metricas_clave']) || !isset($final_data['recomendaciones_optimizacion'])) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o la estructura de datos esperada no está completa. Intenta de nuevo con tus datos.',
        'raw_ai_response_after_trim' => trim($generated_text),
        'decoded_data_debug' => $final_data // Ayuda a depurar si es JSON válido pero estructura incorrecta
    ]);
    exit;
}

// Si todo es correcto, devolver los datos generados
echo json_encode($final_data);