<?php
// db/client-services-sync.php

// ***** IMPORTANTE: ESTAS LÍNEAS ESTÁN AQUÍ PARA DEPURAR. *****
// UNA VEZ QUE FUNCIONE, CÁMBIALAS A: error_reporting(0); ini_set('display_errors', 0);
error_reporting(E_ALL); // Reporta todos los errores
ini_set('display_errors', 1); // Muestra los errores en la pantalla
// *************************************************************

/**
 * Sincroniza los servicios asociados a un cliente en la tabla client_services.
 * Esto implica eliminar los servicios actuales del cliente y luego insertar los nuevos.
 *
 * @param PDO $pdo La instancia de conexión PDO a la base de datos.
 * @param int $clientId El ID del cliente cuyos servicios se van a sincronizar.
 * @param array $newServiceIds Un array de IDs de servicios que deben asociarse al cliente.
 * @return bool True si la sincronización fue exitosa, false en caso de error.
 */
function syncClientServices(PDO $pdo, int $clientId, array $newServiceIds): bool
{
    try {
        // 1. Eliminar todos los servicios existentes para este cliente
        $stmtDelete = $pdo->prepare("DELETE FROM client_services WHERE client_id = ?");
        $stmtDelete->execute([$clientId]);

        // 2. Insertar los nuevos servicios
        if (!empty($newServiceIds)) {
            $stmtInsert = $pdo->prepare("INSERT INTO client_services (client_id, service_id) VALUES (?, ?)");
            foreach ($newServiceIds as $serviceId) {
                // Asegurarse de que el serviceId sea un entero válido
                if (filter_var($serviceId, FILTER_VALIDATE_INT) !== false) {
                    $stmtInsert->execute([$clientId, (int)$serviceId]);
                } else {
                    error_log("ID de servicio inválido detectado: " . $serviceId);
                    // Puedes optar por ignorar el ID inválido o lanzar una excepción
                    // Para este caso, solo lo registramos y continuamos.
                }
            }
        }
        return true; // Éxito en la sincronización
    } catch (PDOException $e) {
        error_log("Error de PDO al sincronizar servicios para cliente ID " . $clientId . ": " . $e->getMessage());
        return false; // Falló la sincronización
    } catch (Exception $e) {
        error_log("Error general al sincronizar servicios para cliente ID " . $clientId . ": " . $e->getMessage());
        return false; // Falló la sincronización
    }
}