<?php
// Incluir conexión a la base de datos
include_once 'db_connection.php'; 

// Establecer cabecera para devolver una respuesta en formato JSON
header('Content-Type: application/json');

// Leer los datos JSON que envía el JavaScript
$data = json_decode(file_get_contents('php://input'), true);

// Validación de datos básicos
if (!isset($data['type'], $data['description'], $data['amount']) || empty(trim($data['description']))) {
    echo json_encode(['success' => false, 'message' => 'Faltan datos requeridos (tipo, descripción, monto).']);
    exit;
}

// Recolectar datos principales
$client_id = !empty($data['client_id']) ? $data['client_id'] : null;
$type = $data['type'];
$description = trim($data['description']);
$amount = (float) $data['amount'];
$is_recurring = !empty($data['is_recurring']);

// LÓGICA DE DECISIÓN: ¿ES RECURRENTE O NORMAL?

// SI es un gasto Y está marcado como recurrente
if ($type === 'gasto' && $is_recurring) {
    
    // --- LÓGICA PARA GUARDAR EN TABLA DE RECURRENTES ---
    
    $start_date = $data['transaction_date'];
    $recurrence_day = (int) $data['recurrence_day_of_month'];
    $end_date = !empty($data['end_date']) ? $data['end_date'] : null;

    // Validación específica para recurrentes
    if (empty($start_date) || $recurrence_day < 1 || $recurrence_day > 31) {
        echo json_encode(['success' => false, 'message' => 'Para un gasto recurrente, la fecha de inicio y el día del mes son obligatorios.']);
        exit;
    }

    try {
        // ✅ ¡CORREGIDO! Ahora usa la tabla correcta: `recurring_finances`
        $sql = "INSERT INTO recurring_finances (client_id, type, description, amount, recurrence_day_of_month, start_date, end_date) 
                VALUES (:client_id, :type, :description, :amount, :recurrence_day, :start_date, :end_date)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':client_id' => $client_id,
            ':type' => 'gasto',
            ':description' => $description,
            ':amount' => $amount,
            ':recurrence_day' => $recurrence_day,
            ':start_date' => $start_date,
            ':end_date' => $end_date
        ]);

        echo json_encode(['success' => true]);

    } catch (PDOException $e) {
        error_log("Error en DB (recurrente): " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Error al guardar el gasto recurrente en la base de datos.']);
    }

} else {

    // --- LÓGICA PARA GUARDAR EN TABLA NORMAL (`finances`) ---
    
    $transaction_date = $data['transaction_date'];

    if (empty($transaction_date)) {
        echo json_encode(['success' => false, 'message' => 'La fecha de la transacción es obligatoria.']);
        exit;
    }

    try {
        $sql = "INSERT INTO finances (client_id, type, description, amount, transaction_date) 
                VALUES (:client_id, :type, :description, :amount, :transaction_date)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':client_id' => $client_id,
            ':type' => $type,
            ':description' => $description,
            ':amount' => $amount,
            ':transaction_date' => $transaction_date
        ]);
        
        echo json_encode(['success' => true]);

    } catch (PDOException $e) {
        error_log("Error en DB (normal): " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Error al guardar la transacción en la base de datos.']);
    }
}
?>