<?php
// db/lead-sources-delete.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response_data = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $source_id = $input['id'] ?? null;

    if (empty($source_id)) {
        $response_data['message'] = 'ID de fuente no proporcionado.';
    } else {
        try {
            // Opcional: Verificar si la fuente está en uso antes de eliminarla.
            // Por ahora, permitiremos la eliminación. Si una fuente se elimina y estaba asignada a un lead,
            // la columna 'source' en la tabla 'leads' contendrá un valor que ya no existe en 'lead_sources'.
            // Podrías considerar establecer 'source' a NULL o a un valor predeterminado si es crítica.

            $stmt = $pdo->prepare("DELETE FROM lead_sources WHERE id = :id");
            if ($stmt->execute([':id' => $source_id])) {
                if ($stmt->rowCount() > 0) {
                    $response_data['success'] = true;
                    $response_data['message'] = 'Fuente eliminada exitosamente.';
                } else {
                    $response_data['message'] = 'La fuente no fue encontrada o ya fue eliminada.';
                }
            } else {
                $response_data['message'] = 'Error al eliminar la fuente.';
            }
        } catch (PDOException $e) {
            error_log("Error PDO al eliminar fuente de lead: " . $e->getMessage());
            $response_data['message'] = 'Error de Base de Datos al eliminar fuente: ' . $e->getMessage();
        } catch (Exception $e) {
            error_log("Error general al eliminar fuente de lead: " . $e->getMessage());
            $response_data['message'] = 'Error inesperado al eliminar fuente: ' . $e->getMessage();
        }
    }
} else {
    $response_data['message'] = 'Método de solicitud no permitido.';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>