<?php
// db/lead-sources-read.php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response_data = ['success' => false, 'data' => []];

try {
    $stmt = $pdo->query("SELECT id, name FROM lead_sources ORDER BY name ASC");
    $sources = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response_data = ['success' => true, 'data' => $sources];

} catch (PDOException $e) {
    error_log("Error PDO al cargar fuentes de leads: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar fuentes: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("Error general al cargar fuentes de leads: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar fuentes: ' . $e->getMessage();
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>