<?php
// db/leads-update.php
require_once 'db_connection.php'; // Asegúrate de que la ruta sea correcta

header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Ocurrió un error inesperado.'];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido.');
    }

    if (empty($data['id'])) {
        throw new Exception('Error: El ID del prospecto es requerido para actualizar.');
    }

    $pdo->beginTransaction();

    // Lógica para determinar si es una actualización de estado o una completa.
    
    // Si solo se envían 'id' y 'status', es una actualización por arrastrar y soltar.
    if (isset($data['status']) && count($data) === 2) {
        
        $sql = "UPDATE leads SET status = :status WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':status', $data['status']);
        $stmt->bindValue(':id', $data['id']);
        
        $response['message'] = 'Estado del prospecto actualizado.';

    } else {
        // Si se envían más datos, es una actualización completa desde el formulario.
        $sql = "UPDATE leads SET 
                    first_name = :first_name, 
                    last_name = :last_name, 
                    company = :company, 
                    email = :email, 
                    phone = :phone, 
                    mobile = :mobile,
                    source = :source, 
                    status = :status,
                    street_address = :street_address,
                    city = :city,
                    state_province = :state_province,
                    zip_code = :zip_code
                WHERE id = :id";

        $stmt = $pdo->prepare($sql);

        // Asignar todos los valores del formulario
        $stmt->bindValue(':id', $data['id']);
        $stmt->bindValue(':first_name', $data['first_name'] ?? null);
        $stmt->bindValue(':last_name', $data['last_name'] ?? null);
        $stmt->bindValue(':company', $data['company'] ?? null);
        $stmt->bindValue(':email', $data['email'] ?? null);
        $stmt->bindValue(':phone', $data['phone'] ?? null);
        $stmt->bindValue(':mobile', $data['mobile'] ?? null);
        $stmt->bindValue(':source', $data['source'] ?? null);
        $stmt->bindValue(':status', $data['status'] ?? null);
        $stmt->bindValue(':street_address', $data['street_address'] ?? null);
        $stmt->bindValue(':city', $data['city'] ?? null);
        $stmt->bindValue(':state_province', $data['state_province'] ?? null); // Vuelve a esperar 'state_province'
        $stmt->bindValue(':zip_code', $data['zip_code'] ?? null);

        $response['message'] = 'Prospecto actualizado exitosamente.';
    }

    $stmt->execute();
    $pdo->commit();

    $response['success'] = true;

} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $response['message'] = 'Error de Base de Datos: ' . $e->getMessage();
    error_log("Error PDO en leads-update: " . $e->getMessage());

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $response['message'] = $e->getMessage();
    error_log("Error General en leads-update: " . $e->getMessage());
}

echo json_encode($response);
?>