<?php
ob_start();
error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response_data = [];

try {
    $stmt = $pdo->query("SELECT id, name FROM service_categories ORDER BY name ASC");
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response_data = ['success' => true, 'categories' => $categories];
} catch (PDOException $e) {
    error_log("Error PDO al cargar categorías: " . $e->getMessage());
    $response_data = ['success' => false, 'message' => 'Error de Base de Datos al cargar categorías: ' . $e->getMessage()];
} catch (Exception $e) {
    error_log("Error general al cargar categorías: " . $e->getMessage());
    $response_data = ['success' => false, 'message' => 'Error inesperado al cargar categorías: ' . $e->getMessage()];
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>