<?php
ob_start();

error_reporting(0);
ini_set('display_errors', 0);

include_once 'db_connection.php';

$response = [];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Error: JSON inválido recibido.');
    }
    if (!$data || !isset($data['id'])) {
        throw new Exception('ID del servicio no proporcionado.');
    }

    $id = $data['id'];

    $sql = "DELETE FROM services WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute([$id])) {
        $response = ['success' => true, 'message' => 'Servicio eliminado con éxito.'];
    } else {
        throw new Exception('Falló la ejecución de la consulta de eliminación.');
    }
} catch (PDOException $e) {
    error_log("PDO Error en services-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => 'Error de Base de Datos: ' . $e->getMessage()];
} catch (Exception $e) {
    error_log("General Error en services-delete.php: " . $e->getMessage());
    $response = ['success' => false, 'message' => $e->getMessage()];
}

ob_end_clean();

header('Content-Type: application/json');
echo json_encode($response);
exit;