<?php
// db/website-config-read.php
ob_start();
error_reporting(E_ALL); // Habilitado para depuración
ini_set('display_errors', 1); // Habilitado para depuración

include_once 'db_connection.php'; // Aquí podría estar el problema si falla antes

$response_data = ['success' => false, 'data' => null];

try {
    // Intentar leer la única fila de configuración (con ID 1)
    $stmt = $pdo->query("SELECT * FROM website_config WHERE id = 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        // Decodificar los campos JSON
        $config['gallery_images'] = json_decode($config['gallery_images'] ?? '[]', true);
        $config['cities_operated'] = json_decode($config['cities_operated'] ?? '[]', true);
        $config['weekly_schedule'] = json_decode($config['weekly_schedule'] ?? '[]', true); // Se asume un array de objetos para el horario semanal
        $config['blocked_dates'] = json_decode($config['blocked_dates'] ?? '[]', true);
        $config['enable_booking'] = (bool)$config['enable_booking']; // Convertir a booleano

        $response_data = ['success' => true, 'data' => $config];
    } else {
        // Si no existe la fila (raro si se usó INSERT IGNORE), devolver defaults o error
        $response_data['message'] = 'No se encontró la configuración. Asegúrate de que la tabla website_config tiene una fila con ID 1.';
    }

} catch (PDOException $e) {
    error_log("Error PDO al cargar configuración web: " . $e->getMessage());
    $response_data['message'] = 'Error de Base de Datos al cargar configuración: ' . $e->getMessage();
} catch (Exception $e) {
    error_log("General Error al cargar configuración web: " . $e->getMessage());
    $response_data['message'] = 'Error inesperado al cargar configuración: ' . $e->getMessage();
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response_data);
exit;
?>