<?php 
// 1. INCLUIR ARCHIVOS DE CONEXIÓN Y SEGURIDAD
include 'files/guardiankey.php'; 
include 'db/db_connection.php'; // Conexión a la base de datos

// 2. OBTENER DATOS DE LA TABLA website_config
$company_name_from_db = ''; // Valor por defecto
$website_url_from_db = ''; // Valor por defecto
$contact_phone_from_db = ''; // Valor por defecto

try {
    $stmt = $pdo->query("SELECT company_name, website_url, phone_primary FROM website_config WHERE id = 1 LIMIT 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($config) {
        $company_name_from_db = htmlspecialchars($config['company_name'] ?? $company_name_from_db);
        $website_url_from_db = htmlspecialchars($config['website_url'] ?? $website_url_from_db);
        $contact_phone_from_db = htmlspecialchars($config['phone_primary'] ?? $contact_phone_from_db);
    }
} catch (PDOException $e) {
    // En caso de error, la página usará los valores por defecto sin romperse.
    error_log("Error fetching website_config: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Generador De Plan Táctico Publicitario | OrozDesign Multimedia</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
        
    <style>
        /* Estilos específicos para los títulos de los pasos (copiados del archivo anterior) */
        .step-header h2 {
            flex-direction: column;
            align-items: flex-start;
            justify-content: flex-start;
            text-align: left;
        }

        .step-header .step-number {
            font-size: 1.25rem;
            font-weight: 900;
            margin-right: 0;
            margin-bottom: 0.25rem;
            display: flex;
            align-items: center;
            color: var(--color-secondary);
            flex-shrink: 0;
            text-align: left;
        }
        .step-header .step-number i {
            margin-right: 0.5rem;
            font-size: 1.5rem;
        }

        .step-header .step-title {
            font-size: 1.4rem;
            font-weight: 900;
            color: #1e293b;
            line-height: 1.2;
            text-transform: uppercase;
            text-align: left;
            width: 100%;
        }

        @media (min-width: 768px) {
            .step-header h2 {
                flex-direction: row;
                align-items: center;
                justify-content: flex-start;
                text-align: left;
            }
            .step-header .step-number {
                font-size: 1.5rem;
                margin-right: 0.5rem;
                margin-bottom: 0;
                text-align: left;
            }
            .step-header .step-number i {
                font-size: 1.8rem;
            }
            .step-header .step-title {
                font-size: 1.5rem;
                width: auto;
                text-align: left;
            }
        }
    </style>
</head>
<body data-page-title="Generador De Plan Táctico Publicitario"
      data-page-subtitle="Obtén Un Plan Publicitario Estratégico Adaptado A Tu Presupuesto"
      data-page-icon="clipboard-list">

    <div id="toast-container" class="toast-container"></div>
        
    <?php include 'files/gtm-body.php'; ?>
        
<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden" aria-hidden="true"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800" aria-label="Abrir menú lateral">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title" class="text-xl font-bold text-gray-800"></h2>
                <p id="page-subtitle" class="text-sm text-gray-600"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="tactical-plan-generator" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">

                    <div class="lg:col-span-3">
                        <form id="tactical-plan-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase md:justify-start"> <span class="step-number"> <i class="fas fa-building mr-3 text-[var(--color-secondary)]"></i>
                                            PASO 1:
                                        </span>
                                        <span class="step-title"> DEFINE TU NEGOCIO Y SERVICIO
                                        </span>
                                    </h2>
                                    <p class="step-subtitle uppercase">Ingresa los datos fundamentales de tu empresa</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="business_name" class="block font-bold text-gray-700 mb-2">Nombre De Tu Negocio</label>
                                        <input type="text" id="business_name" name="business_name" class="w-full p-3 bg-gray-100 border border-gray-300 rounded-lg" value="<?php echo htmlspecialchars($company_name_from_db); ?>" readonly>
                                    </div>
                                    <div>
                                        <label for="service_type" class="block font-bold text-gray-700 mb-2">Tipo De Producto Principal</label>
                                        <input type="text" id="service_type" name="service_type" placeholder="Ej: Limpieza de casas, Contabilidad, Clases de guitarra" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                    </div>
                                    <div>
                                        <label for="service_zone" class="block font-bold text-gray-700 mb-2">Zona Geográfica De Servicio</label>
                                        <input type="text" id="service_zone" name="service_zone" placeholder="Ej: Seattle WA, Madrid España" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                    </div>
                                    <div>
                                        <label for="service_price" class="block font-bold text-gray-700 mb-2">Precio Promedio De Tu Servicio/Producto ($)</label>
                                        <input type="number" id="service_price" name="service_price" step="1" min="1" placeholder="Ej: 300" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                    </div>
                                </div>
                            </div>

                            <div class="pt-8">
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase md:justify-start"> <span class="step-number"> <i class="fas fa-bullseye mr-3 text-[var(--color-highlight)]"></i>
                                            PASO 2:
                                        </span>
                                        <span class="step-title"> DEFINE TUS OBJETIVOS Y EXPECTATIVAS
                                        </span>
                                    </h2>
                                    <p class="step-subtitle uppercase">Establece lo que esperas lograr con tu publicidad</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="main_objective" class="block font-bold text-gray-700 mb-2">Objetivo Principal De Publicidad</label>
                                        <select id="main_objective" name="main_objective" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                            <option value="">Selecciona Un Objetivo</option>
                                            <option value="Conseguir más clientes">Conseguir Más Clientes</option>
                                            <option value="Dar a conocer mi negocio">Dar A Conocer Mi Negocio</option>
                                            <option value="Vender un producto/servicio específico">Vender Un Servicio Específico</option>
                                            <option value="Llenar mi agenda de citas">Llenar Mi Agenda De Citas</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label for="desired_new_clients" class="block font-bold text-gray-700 mb-2">¿Cuántos Clientes Nuevos Te Gustaría Conseguir Al Mes Con Publicidad?</label>
                                        <input type="number" id="desired_new_clients" name="desired_new_clients" step="1" min="1" placeholder="Ej: 5" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                    </div>
                                    <div>
                                        <label for="commitment_level" class="block font-bold text-gray-700 mb-2">Tu Nivel De Compromiso Para Aprender Y Aplicar</label>
                                        <select id="commitment_level" name="commitment_level" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                            <option value="">Selecciona Tu Nivel De Compromiso</option>
                                            <option value="Bajo (Prefiero lo más simple y automatizado)">Bajo (Prefiero Lo Más Simple Y Automatizado)</option>
                                            <option value="Medio (Dispuesto a aprender lo básico y dedicar algo de tiempo)">Medio (Dispuesto A Aprender Y Dedicar Algo De Tiempo)</option>
                                            <option value="Alto (Quiero dominar la publicidad y optimizar al máximo)">Alto (Quiero Dominar La Publicidad Y Optimizar Al Máximo)</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label for="business_stage" class="block font-bold text-gray-700 mb-2">Etapa Actual De Tu Negocio</label>
                                        <select id="business_stage" name="business_stage" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                            <option value="">Selecciona La Etapa De Tu Negocio</option>
                                            <option value="Apenas voy a comenzar (negocio nuevo)">Apenas Voy A Comenzar</option>
                                            <option value="Ya tengo negocio, pero no consigo clientes">Tengo Mi Negocio, Pero No Consigo Clientes</option>
                                            <option value="Tengo clientes, pero quiero más">Tengo Mis Clientes, Pero Quiero Más</option>
                                            <option value="Quiero escalar mi negocio actual">Quiero Escalar Mi Negocio Actual</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label for="has_website_optimized" class="block font-bold text-gray-700 mb-2">¿Actualmente Tienes Una Página Web Profesional Para Tu Negocio?</label>
                                        <select id="has_website_optimized" name="has_website_optimized" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                            <option value="">Selecciona Una Opción</option>
                                            <option value="No, todavía no">No, Todavía No Tengo</option>
                                            <option value="Sí, pero es solo informativa">Sí, Pero Es Solo Informativa</option>
                                            <option value="Sí, y está optimizada para vender">Sí, Preparada Para Vender</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="pt-8">
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase md:justify-start"> <span class="step-number"> <i class="fas fa-dollar-sign mr-3 text-[var(--color-secondary)]"></i>
                                            PASO 3:
                                        </span>
                                        <span class="step-title"> DEFINE TU PRESUPUESTO PUBLICITARIO
                                        </span>
                                    </h2>
                                    <p class="step-subtitle uppercase">Detalla tu inversión disponible para publicidad</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="monthly_budget" class="block font-bold text-gray-700 mb-2">Presupuesto Mensual Para Anuncios (Solo Inversión En Plataformas Como Facebook/Google) ($)</label>
                                        <input type="number" id="monthly_budget" name="monthly_budget" step="1" min="1" placeholder="Ej: 150" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                    </div>
                                    <div>
                                        <label for="prior_ad_investment" class="block font-bold text-gray-700 mb-2">¿Has Invertido En Publicidad Pagada Antes?</label>
                                        <select id="prior_ad_investment" name="prior_ad_investment" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                            <option value="">Selecciona Una Opción</option>
                                            <option value="No">No, Nunca</option>
                                            <option value="Sí">Sí Un Poco</option>
                                            <option value="No estoy seguro">No Estoy Seguro</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label for="facebook_page_optimized" class="block font-bold text-gray-700 mb-2">¿Cuentas Con Una Página De Facebook Optimizada Para Negocios?</label>
                                        <select id="facebook_page_optimized" name="facebook_page_optimized" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-highlight)] focus:border-transparent" required>
                                            <option value="">Selecciona Una Opción</option>
                                            <option value="No">No Todavia No</option>
                                            <option value="Sí">Sí Esta Preparada</option>
                                            <option value="No estoy seguro">No Estoy Seguro(a)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div id="form-error-message" class="hidden bg-red-100 text-center p-3 text-red-700 rounded-lg border border-red-300" role="alert">
                                Por Favor, Completa Todos Los Campos Requeridos.
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover rounded-xl" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata" poster="https://placehold.co/600x337/07162d/ffc857?text=VIDEO_PREVIEW">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <span class="step-number"> <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    </span>
                                    <span class="step-title">
                                        INSTRUCCIONES
                                    </span>
                                </h2>
                                <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-info-circle"></i></span><div><strong class="text-brand-dark">PROPORCIONA DATOS DETALLADOS:</strong> Cuanta más información brindes, más preciso y útil será tu plan táctico.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-coins"></i></span><div><strong class="text-brand-dark">SE REALISTA CON TU PRESUPUESTA:</strong> Nuestra IA te guiará para alcanzar tus metas de forma viable.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-clipboard-check"></i></span><div><strong class="text-brand-dark">GENERA TU PLAN:</strong> Recibe un diagnóstico, estimaciones y un plan de acción paso a paso.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-chart-line"></i></span><div><strong class="text-brand-dark">IMPLEMENTA Y OPTIMIZA:</strong> Sigue el plan y usa las métricas clave para mejorar continuamente tus campañas.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                            <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase md:justify-start">
                                <span class="step-number"> <i class="fas fa-chart-pie mr-3 text-[var(--color-secondary)]"></i>
                                    PASO 4:
                                </span>
                                <span class="step-title">
                                    GENERAR TU PLAN TÁCTICO
                                </span>
                            </h2>
                            <p class="step-subtitle text-center md:text-left uppercase">Obtén un plan publicitario estratégico adaptado a tu presupuesto y objetivos.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                        <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Basado en tus datos, <strong class="font-black">CLIENT3 IA</strong>, generará un <b>plan táctico de publicidad completamente personalizado</b>. Analizará la viabilidad de tus objetivos, te dará estimaciones realistas y te guiará paso a paso para que consigas clientes de forma efectiva.</p>
                            <button id="generateBtn" type="submit" form="tactical-plan-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase" aria-live="polite">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">GENERA TU PLAN TÁCTICO</span>
                                <div id="loader-container" class="hidden ml-3">
                                    <div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>
                                </div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8 opacity-0 transition-opacity duration-500 transform scale-95"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicialización del Toast desde URL parámetros (solo aquí, no en header-manager.js)
    const urlParams = new URLSearchParams(window.location.search);
    const notificationType = urlParams.get('notification_type');
    const notificationMessage = urlParams.get('notification_message');

    if (notificationType && notificationMessage) {
        if (typeof showToast === 'function') {
            showToast(notificationMessage, notificationType);
        } else {
            console.error("showToast function is not defined. Toast notification might not display.");
        }
    }

    lucide.createIcons();

    function initVideoPlayer() {
        const videoPlayer = document.getElementById('videoPlayer');
        const playOverlay = document.getElementById('playOverlay');

        if (videoPlayer && playOverlay) {
            videoPlayer.controls = false; 

            playOverlay.addEventListener('click', () => {
                playOverlay.style.display = 'none';
                videoPlayer.controls = true; 
                videoPlayer.play().catch(e => showToast("Error al reproducir video: " + e.message, 'error')); // Replaced console.error
            });

            videoPlayer.addEventListener('ended', () => {
                playOverlay.style.display = 'flex'; 
                videoPlayer.controls = false; 
                videoPlayer.load(); 
            });
        }
    }

    function setupPlanGenerator() {
        const form = document.getElementById('tactical-plan-form');
        const resultContainer = document.getElementById('result-container');
        const generateBtn = document.getElementById('generateBtn');
        const btnText = document.getElementById('btn-text');
        const loaderContainer = document.getElementById('loader-container');
        const formErrorMessage = document.getElementById('form-error-message');

        function validateForm() {
            const requiredInputs = form.querySelectorAll('[required]');
            let allValid = true;
            requiredInputs.forEach(input => {
                if (!input.value || (input.type === 'number' && parseFloat(input.value) <= 0)) {
                    input.classList.add('border-red-500'); 
                    allValid = false;
                } else {
                    input.classList.remove('border-red-500');
                }
            });
            if (!allValid) {
                formErrorMessage.classList.remove('hidden');
                formErrorMessage.focus(); 
                showToast('Por favor, completa todos los campos requeridos.', 'warning'); // Added toast
            } else {
                formErrorMessage.classList.add('hidden');
            }
            return allValid;
        }

        form.addEventListener('submit', async function(event) {
            event.preventDefault(); 

            if (!validateForm()) {
                return;
            }

            btnText.textContent = 'Generando Tu Plan Personalizadp...';
            loaderContainer.classList.remove('hidden');
            generateBtn.disabled = true;
            generateBtn.setAttribute('aria-busy', 'true'); 
            resultContainer.innerHTML = ''; 
            resultContainer.style.opacity = '0'; 
            resultContainer.style.transform = 'scale(0.95)';

            const formData = {
                business_name: document.getElementById('business_name').value,
                service_type: document.getElementById('service_type').value,
                service_zone: document.getElementById('service_zone').value,
                service_price: parseFloat(document.getElementById('service_price').value),
                main_objective: document.getElementById('main_objective').value,
                desired_new_clients: parseInt(document.getElementById('desired_new_clients').value),
                commitment_level: document.getElementById('commitment_level').value,
                business_stage: document.getElementById('business_stage').value,
                has_website_optimized: document.getElementById('has_website_optimized').value,
                monthly_budget: parseFloat(document.getElementById('monthly_budget').value),
                prior_ad_investment: document.getElementById('prior_ad_investment').value,
                facebook_page_optimized: document.getElementById('facebook_page_optimized').value
            };

            try {
                const response = await fetch('api/API-Generador-De-Plan-Tactico-Publicitario.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(formData)
                });

                if (!response.ok) {
                    const errorData = await response.json();
                    throw new Error(errorData.error || `Error del servidor: ${response.status}. Por favor, inténtalo de nuevo.`);
                }

                const data = await response.json();
                if(data.error) {
                    throw new Error(data.error);
                }
                displayResult(data);

            } catch (error) {
                showToast("Error al generar el plan: " + error.message, 'error'); // Replaced console.error and alert
                resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300" role="alert"><p><strong>Error:</strong> No se pudo generar el plan táctico.</p><p class="mt-2 text-sm">${error.message}</p></div>`;
                resultContainer.style.opacity = '1'; 
                resultContainer.style.transform = 'scale(1)';
            } finally {
                btnText.textContent = 'GENERA TU PLAN TÁCTICO';
                loaderContainer.classList.add('hidden');
                generateBtn.disabled = false;
                generateBtn.removeAttribute('aria-busy');
            }
        });

        function displayResult(data) {
            resultContainer.innerHTML = `
                <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8 bg-white">
                    <div class="text-center">
                        <h2 class="ai-report-main-title text-3xl font-black text-[var(--color-primary)] mb-4">Tu Plan Táctico Publicitario CLIENT3</h2>
                        <p class="text-lg text-gray-700">${data.summary || 'Aquí está un resumen de tu plan personalizado.'}</p>
                    </div>

                    <div class="ai-report-section border-t border-gray-200 pt-6">
                        <h3 class="text-2xl font-bold flex items-center text-[var(--color-dark)] mb-4"><i class="fas fa-lightbulb mr-3 text-[var(--color-primary)]"></i>Diagnóstico Rápido</h3>
                        <p class="section-content-text text-gray-700">${data.diagnostico_rapido}</p>
                    </div>

                    <div class="ai-report-section border-t border-gray-200 pt-6">
                        <h3 class="text-2xl font-bold flex items-center text-[var(--color-dark)] mb-4"><i class="fas fa-chart-line mr-3 text-[var(--color-primary)]"></i>Estimación de Clientes Potenciales</h3>
                        <p class="section-content-text text-gray-700">${data.estimacion_clientes}</p>
                    </div>
                    
                    <div class="ai-report-action-plan-container border-t border-gray-200 pt-6">
                        <h3 class="ai-action-plan-title text-2xl font-bold flex items-center text-[var(--color-dark)] mb-4"><i class="fas fa-clipboard-list mr-3 text-[var(--color-secondary)]"></i>Tu Plan Táctico Detallado</h3>
                        <div class="mt-6 space-y-6">
                            ${data.plan_tactico.map((step, index) => `
                                <div class="tactical-step-item flex items-start p-4 bg-gray-50 rounded-lg shadow-sm">
                                    <div class="tactical-step-number-circle bg-[var(--color-secondary)] text-white text-lg font-black flex-shrink-0 flex items-center justify-center w-8 h-8 rounded-full">
                                        ${index + 1}
                                    </div>
                                    <div class="ml-4 flex-grow">
                                        <p class="tactical-step-text text-gray-800 leading-relaxed">
                                            ${step.replace(/\*\*(.*?)\*\*/g, '<strong class="text-[var(--color-primary)]">$1</strong>')}
                                        </p>
                                    </div>
                                </div>
                            `).join('')}
                        </div>
                    </div>

                    <div class="ai-report-section border-t border-gray-200 pt-6">
                        <h3 class="text-2xl font-bold flex items-center text-[var(--color-dark)] mb-4"><i class="fas fa-gauge-high mr-3 text-[var(--color-primary)]"></i>Métricas Clave a Monitorear</h3>
                        <p class="section-content-text text-gray-700">${data.metricas_clave}</p>
                    </div>

                    <div class="ai-report-section border-t border-gray-200 pt-6">
                        <h3 class="text-2xl font-bold flex items-center text-[var(--color-dark)] mb-4"><i class="fas fa-wrench mr-3 text-[var(--color-primary)]"></i>Recomendaciones para Optimización</h3>
                        <p class="section-content-text text-gray-700">${data.recomendaciones_optimizacion}</p>
                    </div>
                </div>
            `;
            setTimeout(() => { 
                resultContainer.style.opacity = '1'; 
                resultContainer.style.transform = 'scale(1)'; 
                resultContainer.scrollIntoView({ behavior: 'smooth', block: 'start' }); 
            }, 100);
        }
    }

    initVideoPlayer();
    setupPlanGenerator();
});
</script>

</body>
</html>