<?php include 'files/guardiankey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Dashboard | Marketing IA | OrozDesign Multimedia</title>
    <meta name="description" content="Descubre las herramientas con IA de LocalCRM: automatiza tareas, analiza datos y optimiza tu gestión comercial de forma inteligente">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <script src="https://unpkg.com/lucide@latest" defer></script>
    
    <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
        
</head>
<body data-page-title="HERRAMIENTAS DE INTELIGENCIA ARTIFICIAL" 
      data-page-subtitle="POTENCIA TU NEGOCIO CON NUESTRAS HERRAMIENTAS INTELIGENTES." 
      data-page-icon="cpu">
        
<?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">
            <section id="herramientas-ia" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="cpu" class="w-7 h-7 text-[var(--color-primary)]"></i> CATÁLOGO DE HERRAMIENTAS IA
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">DESCUBRE NUESTRAS SOLUCIONES INTELIGENTES PARA TU NEGOCIO.</p>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <div class="tool-card bg-slate-900 rounded-xl p-6 flex flex-col group">
                            <div class="tool-card-icon w-14 h-14 rounded-full flex items-center justify-center mb-4">
                                <i data-lucide="layout-dashboard" class="w-8 h-8 text-[var(--color-highlight)]"></i>
                            </div>
                            <h4 class="font-extrabold text-2xl mb-2 uppercase text-white">GENERADOR DE PLAN TÁCTICO PUBLICITARIO</h4>
                            <p class="text-slate-300 text-sm mb-4 flex-grow uppercase">Obtén un plan publicitario estratégico adaptado a tu presupuesto.</p>
                            <a href="ia-generador-de-plan-tactico-publicitario.php" class="tool-card-button w-full mt-auto py-2 px-4 uppercase">
                                USAR HERRAMIENTA <span class="arrow-icon"><i data-lucide="arrow-right" class="w-4 h-4"></i></span>
                            </a>
                        </div>
                        <div class="tool-card bg-slate-900 rounded-xl p-6 flex flex-col group">
                            <div class="tool-card-icon w-14 h-14 rounded-full flex items-center justify-center mb-4">
                                <i data-lucide="message-square-plus" class="w-8 h-8 text-[var(--color-highlight)]"></i>
                            </div>
                            <h4 class="font-extrabold text-2xl mb-2 uppercase text-white">GENERADOR DE MENSAJE PRIMER CONTACTO</h4>
                            <p class="text-slate-300 text-sm mb-4 flex-grow uppercase">Crea mensajes iniciales potentes para posibles nuevos clientes.</p>
                            <a href="ia-generador-de-mensaje-primer-contacto.php" class="tool-card-button w-full mt-auto py-2 px-4 uppercase">
                                USAR HERRAMIENTA <span class="arrow-icon"><i data-lucide="arrow-right" class="w-4 h-4"></i></span>
                            </a>
                        </div>
                        <div class="tool-card bg-slate-900 rounded-xl p-6 flex flex-col group">
                            <div class="tool-card-icon w-14 h-14 rounded-full flex items-center justify-center mb-4">
                                <i data-lucide="git-pull-request-draft" class="w-8 h-8 text-[var(--color-highlight)]"></i>
                            </div>
                            <h4 class="font-extrabold text-2xl mb-2 uppercase text-white">ASISTENTE DE SEGUIMIENTO ESTRATÉGICO</h4>
                            <p class="text-slate-300 text-sm mb-4 flex-grow uppercase">Crea mensajes para dar seguimiento tras una propuesta o servicio.</p>
                            <a href="ia-asistente-de-seguimiento-estrategico.php" class="tool-card-button w-full mt-auto py-2 px-4 uppercase">
                                USAR HERRAMIENTA <span class="arrow-icon"><i data-lucide="arrow-right" class="w-4 h-4"></i></span>
                            </a>
                        </div>
                        <div class="tool-card bg-slate-900 rounded-xl p-6 flex flex-col group">
                            <div class="tool-card-icon w-14 h-14 rounded-full flex items-center justify-center mb-4">
                                <i data-lucide="megaphone" class="w-8 h-8 text-[var(--color-highlight)]"></i>
                            </div>
                            <h4 class="font-extrabold text-2xl mb-2 uppercase text-white">CREADOR DE PUBLICACIONES SOCIALES</h4>
                            <p class="text-slate-300 text-sm mb-4 flex-grow uppercase">Crea posts que abordan el problema, la solución y tu servicio.</p>
                            <a href="ia-creador-de-publicaciones-sociales.php" class="tool-card-button w-full mt-auto py-2 px-4 uppercase">
                                USAR HERRAMIENTA <span class="arrow-icon"><i data-lucide="arrow-right" class="w-4 h-4"></i></span>
                            </a>
                        </div>
                        <div class="tool-card bg-slate-900 rounded-xl p-6 flex flex-col group">
                            <div class="tool-card-icon w-14 h-14 rounded-full flex items-center justify-center mb-4">
                                <i data-lucide="file-text" class="w-8 h-8 text-[var(--color-highlight)]"></i>
                            </div>
                            <h4 class="font-extrabold text-2xl mb-2 uppercase text-white">CREADOR DE PROPUESTAS DE PROYECTOS</h4>
                            <p class="text-slate-300 text-sm mb-4 flex-grow uppercase">Genera propuestas profesionales para ganar nuevos clientes.</p>
                            <a href="ia-creador-de-propuestas-de-proyectos.php" class="tool-card-button w-full mt-auto py-2 px-4 uppercase">
                                USAR HERRAMIENTA <span class="arrow-icon"><i data-lucide="arrow-right" class="w-4 h-4"></i></span>
                            </a>
                        </div>
                        <div class="tool-card bg-slate-900 rounded-xl p-6 flex flex-col group">
                            <div class="tool-card-icon w-14 h-14 rounded-full flex items-center justify-center mb-4">
                                <i data-lucide="globe" class="w-8 h-8 text-[var(--color-highlight)]"></i>
                            </div>
                            <h4 class="font-extrabold text-2xl mb-2 uppercase text-white">TRADUCTOR DE INGLÉS INTELIGENTE</h4>
                            <p class="text-slate-300 text-sm mb-4 flex-grow uppercase">Traduce textos a inglés con enfoque en marketing y ventas.</p>
                            <a href="ia-traductor-ingles-inteligente.php" class="tool-card-button w-full mt-auto py-2 px-4 uppercase">
                                USAR HERRAMIENTA <span class="arrow-icon"><i data-lucide="arrow-right" class="w-4 h-4"></i></span>
                            </a>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        const pageTitle = document.getElementById('page-title');    
        const pageSubtitle = document.getElementById('page-subtitle');    
        
        function toggleSidebar() {
            if (sidebar) sidebar.classList.toggle('-translate-x-full');
            if (sidebarOverlay) sidebarOverlay.classList.toggle('hidden');
            console.log("[Herramientas IA] Sidebar toggled.");
        }

        if (mobileMenuButton) {
            mobileMenuButton.addEventListener('click', toggleSidebar);
        }
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', toggleSidebar);
        }

        lucide.createIcons();
    });
</script>
</body>
</html>