<?php include 'files/guardiankey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Dashboard | Promociona | OrozDesign Multiemdia</title>
        <meta name="description" content="Accede a material de apoyo en LocalCRM: plantillas, guías y recursos para impulsar y promocionar tu negocio de manera profesional">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <script src="https://unpkg.com/lucide@latest" defer></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"> <link rel="stylesheet" href="style.css">
    <script src="files/header-manager.js"></script>
    
</head>

<body data-page-title="POTENCIA TU MARCA" 
      data-page-subtitle="DESCUBRE PRODUCTOS Y SERVICIOS PARA IMPULSAR TU EMPRESA." 
      data-page-icon="rocket">
    
    <div id="toast-container" class="toast-container"></div>
        
<?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8 space-y-8">
            <section id="promocion" class="dashboard-section">
                <div class="bg-white p-6 rounded-xl shadow-md">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div>
                            <h3 class="text-2xl font-extrabold text-gray-800 flex items-center gap-2">
                                <i data-lucide="rocket" class="w-7 h-7 text-[var(--color-primary)]"></i> EXPLORA NUESTROS RECURSOS DE MARKETING
                            </h3>
                            <p class="text-gray-500 text-sm mt-1 uppercase">ENCUENTRA HERRAMIENTAS Y SOLUCIONES PARA CRECER TU NEGOCIO.</p>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                        <div class="promo-card bg-white rounded-lg shadow-md overflow-hidden group flex flex-col">
                            <div class="overflow-hidden">
                                <img src="https://placehold.co/600x400/07162d/ffc857?text=10+Tacticas" alt="DigitalBook | 10 Tácticas Rápidas" class="w-full h-48 object-cover promo-card-image" loading="lazy" width="600" height="400">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h4 class="text-xl font-extrabold text-[var(--color-primary)] mb-2 uppercase">DigitalBook | 10 Tácticas Rápidas</h4>
                                <div class="text-gray-600 text-sm mb-4 flex-grow">Aplica Tácticas Simples Y Efectivas Para Atraer Más Clientes</div>
                                <div class="flex items-center justify-between mb-4">
                                    <span class="line-through text-gray-500 text-base">$49.99</span>
                                    <span class="text-[var(--color-secondary)] text-2xl font-extrabold">$27.00/Año</span>
                                </div>
                                <button class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg font-bold flex items-center justify-center gap-2 uppercase"
                                    onclick="window.open('index.php', '_blank');"> VER DETALLES <i data-lucide="arrow-right" class="w-4 h-4"></i>
                                </button>
                            </div>
                        </div>

                        <div class="promo-card bg-white rounded-lg shadow-md overflow-hidden group flex flex-col">
                            <div class="overflow-hidden">
                                <img src="https://placehold.co/600x400/9e1428/ffffff?text=20+Estrategias" alt="DigitalBook | 20 Estrategias" class="w-full h-48 object-cover promo-card-image" loading="lazy" width="600" height="400">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h4 class="text-xl font-extrabold text-[var(--color-primary)] mb-2 uppercase">DigitalBook | 20 Estrategias</h4>
                                <div class="text-gray-600 text-sm mb-4 flex-grow">Descubre Estrategias Probadas Para Aumentar Clientes Rápido</div>
                                <div class="flex items-center justify-between mb-4">
                                    <span class="line-through text-gray-500 text-base">$89.99</span>
                                    <span class="text-[var(--color-secondary)] text-2xl font-extrabold">$42.00/Año</span>
                                </div>
                                <button class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg font-bold flex items-center justify-center gap-2 uppercase"
                                    onclick="window.open('index.php', '_blank');">
                                    VER DETALLES <i data-lucide="arrow-right" class="w-4 h-4"></i>
                                </button>
                            </div>
                        </div>

                        <div class="promo-card bg-white rounded-lg shadow-md overflow-hidden group flex flex-col">
                            <div class="overflow-hidden">
                                <img src="https://placehold.co/600x400/ffc857/07162d?text=ToolKit" alt="ToolKit | Promocionarte Sin Complicarte" class="w-full h-48 object-cover promo-card-image" loading="lazy" width="600" height="400">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h4 class="font-extrabold text-xl mb-2 uppercase text-[var(--color-primary)]">ToolKit | Promocionarte Sin Complicarte</h4>
                                <p class="text-gray-600 text-sm mb-4 flex-grow">Atrae Más Clientes Con 5 Cursos Interactivos Prácticos Y Fáciles De Aplicar</p>
                                <div class="flex items-center justify-between mb-4">
                                    <span class="line-through text-gray-500 text-base">$299.00</span>
                                    <span class="text-[var(--color-secondary)] text-2xl font-extrabold">$67.00/Año</span>
                                </div>
                                <button class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg font-bold flex items-center justify-center gap-2 uppercase"
                                    onclick="window.open('index.php', '_blank');">
                                    VER DETALLES <i data-lucide="arrow-right" class="w-4 h-4"></i>
                                </button>
                            </div>
                        </div>

                        <div class="promo-card bg-white rounded-lg shadow-md overflow-hidden group flex flex-col">
                            <div class="overflow-hidden">
                                <img src="https://placehold.co/600x400/007bff/ffffff?text=Tarjetas+Presentacion" alt="Tarjetas De Presentación" class="w-full h-48 object-cover promo-card-image" loading="lazy" width="600" height="400">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h4 class="font-extrabold text-xl mb-2 uppercase text-[var(--color-primary)]">Tarjetas De Presentación</h4>
                                <p class="text-gray-600 text-sm mb-4 flex-grow">Diseños Profesionales Que Dejan Una Impresión Memorable.</p>
                                <div class="flex items-center justify-between mb-4">
                                    <span class="line-through text-gray-500 text-base">$150.00</span>
                                    <span class="text-[var(--color-secondary)] text-2xl font-extrabold">$99.00</span>
                                </div>
                                <button class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg font-bold flex items-center justify-center gap-2 uppercase"
                                    onclick="window.open('index.php', '_blank');">
                                    VER DETALLES <i data-lucide="arrow-right" class="w-4 h-4"></i>
                                </button>
                            </div>
                        </div>

                        <div class="promo-card bg-white rounded-lg shadow-md overflow-hidden group flex flex-col">
                            <div class="overflow-hidden">
                                <img src="https://placehold.co/600x400/28a745/ffffff?text=Brochures" alt="Brochures" class="w-full h-48 object-cover promo-card-image" loading="lazy" width="600" height="400">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h4 class="font-extrabold text-xl mb-2 uppercase text-[var(--color-primary)]">Brochures</h4>
                                <p class="text-gray-600 text-sm mb-4 flex-grow">Comunica Tus Servicios De Forma Clara Y Atractiva.</p>
                                <div class="flex items-center justify-between mb-4">
                                    <span class="line-through text-gray-500 text-base">$200.00</span>
                                    <span class="text-[var(--color-secondary)] text-2xl font-extrabold">$140.00</span>
                                </div>
                                <button class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg font-bold flex items-center justify-center gap-2 uppercase"
                                    onclick="window.open('index.php', '_blank');">
                                    VER DETALLES <i data-lucide="arrow-right" class="w-4 h-4"></i>
                                </button>
                            </div>
                        </div>

                        <div class="promo-card bg-white rounded-lg shadow-md overflow-hidden group flex flex-col">
                            <div class="overflow-hidden">
                                <img src="https://placehold.co/600x400/dc3545/ffffff?text=Door+Hangers" alt="Door Hangers" class="w-full h-48 object-cover promo-card-image" loading="lazy" width="600" height="400">
                            </div>
                            <div class="p-6 flex flex-col flex-grow">
                                <h4 class="font-extrabold text-xl mb-2 uppercase text-[var(--color-primary)]">Door Hangers</h4>
                                <p class="text-gray-600 text-sm mb-4 flex-grow">Llega Directamente A Tus Clientes Potenciales.</p>
                                <div class="flex items-center justify-between mb-4">
                                    <span class="line-through text-gray-500 text-base">$120.00</span>
                                    <span class="text-[var(--color-secondary)] text-2xl font-extrabold">$75.00</span>
                                </div>
                                <button class="btn-secondary w-full mt-auto py-2 px-4 rounded-lg font-bold flex items-center justify-center gap-2 uppercase"
                                    onclick="window.open('index.php', '_blank');">
                                    VER DETALLES <i data-lucide="arrow-right" class="w-4 h-4"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Inicialización del Toast desde URL parámetros (solo aquí, no en header-manager.js)
        const urlParams = new URLSearchParams(window.location.search);
        const notificationType = urlParams.get('notification_type');
        const notificationMessage = urlParams.get('notification_message');

        if (notificationType && notificationMessage) {
            if (typeof showToast === 'function') {
                showToast(notificationMessage, notificationType);
            } else {
                console.error("showToast function is not defined. Toast notification might not display.");
            }
        }

        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const sidebar = document.getElementById('sidebar');
        const sidebarOverlay = document.getElementById('sidebar-overlay');
        if (mobileMenuButton) {
            mobileMenuButton.addEventListener('click', () => {
                if (sidebar) sidebar.classList.toggle('-translate-x-full');
                if (sidebarOverlay) sidebarOverlay.classList.toggle('hidden');
            });
        }
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', () => {
                if (sidebar) sidebar.classList.toggle('-translate-x-full');
                if (sidebarOverlay) sidebarOverlay.classList.toggle('hidden');
            });
        }
        
        const loadMoreBtn = document.getElementById('load-more-videos-btn');
        if (loadMoreBtn) {
            loadMoreBtn.addEventListener('click', function() {
                const hiddenVideos = document.querySelectorAll('.video-card.hidden');
                hiddenVideos.forEach(video => {
                    video.classList.remove('hidden');
                    video.classList.add('flex');
                });
                document.getElementById('load-more-container').style.display = 'none';
            });
        }
        lucide.createIcons();
    });
</script>
</body>
</html>