<?php include 'files/guardiankey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit Con IA | Analista De Anuncios Publicitarios | OrozDesign Multiemdia</title>
    <meta name="description" content="Aprovecha LocalCRM Toolkit con IA para analizar y optimizar anuncios publicitarios: generación de insights, automatización y recomendaciones inteligentes">
    <meta name="robots" content="noindex, nofollow">

    <link rel="icon" type="image/png" href="img/favicon.png">
    <link rel="apple-touch-icon" href="img/apple-touch-icon.png">

    <?php include 'files/gtm-head.php'; ?>
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
    <script src="files/header-manager.js"></script>

</head>
<body data-page-title="Analista De Resultados Publicitarios" 
      data-page-subtitle="Analiza Tus Anuncios Y Recibe Ideas Claras Para Mejorar Tus Resultados" 
      data-page-icon="bar-chart-2">

<?php include 'files/gtm-body.php'; ?>

<div class="relative min-h-screen md:flex">

    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="analyzer" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">
                    <div class="lg:col-span-3">
                        <form id="analyzer-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                        <i class="fas fa-clipboard-list mr-3 text-[var(--color-secondary)]"></i> 
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> COMPLETA EL DIAGNÓSTICO
                                    </h2>
                                    <p class="step-subtitle text-center md:text-left uppercase">Ingresa los datos de tus anuncios para un análisis de tus resultados.</p>
                                </div>
                                <div class="border-b border-[var(--color-primary)] pb-4 mb-6"></div>
                                
                                <div class="space-y-6">
                                    <div>
                                        <label for="campaign_objective" class="block font-bold capitalize text-gray-700 mb-2">¿Cuál Fue El Objetivo De Tu Anuncio?</label>
                                        <select id="campaign_objective" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" required>
                                            <option value="Recibir Mensajes">Conseguir Mensajes (Recomendado)</option>
                                            <option value="Tráfico a la Página Web">Llevar Tráfico A Tu Página Web</option>
                                            <option value="Generación de Clientes Potenciales">Obtener Datos De Clientes (Formulario)</option>
                                            <option value="Interacción con la Publicación">Conseguir "Me Gusta" y Comentarios</option>
                                        </select>
                                    </div>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 pt-4">
                                        <div>
                                            <label for="investment" class="block font-bold capitalize text-gray-700 mb-2">¿Cuánto Invertiste En Total? ($)</label>
                                            <input type="number" step="0.01" id="investment" placeholder="Ej: 100" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" required>
                                        </div>
                                        <div>
                                            <label for="service_price" class="block font-bold capitalize text-gray-700 mb-2">¿Qué Precio Tiene Tu Producto?</label>
                                            <input type="number" step="0.01" id="service_price" placeholder="Ej: 250" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" required>
                                        </div>
                                        <div>
                                            <label for="messages" class="block font-bold capitalize text-gray-700 mb-2">¿Cuántos Mensajes O Contactos Recibiste?</label>
                                            <input type="number" id="messages" placeholder="Ej: 25" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" required>
                                        </div>
                                        <div>
                                            <label for="closed_clients" class="block font-bold capitalize text-gray-700 mb-2">¿A Cuántos Clientes Les Vendiste?</label>
                                            <input type="number" id="closed_clients" placeholder="Ej: 5" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" required>
                                        </div>
                                        <div>
                                            <label for="impressions" class="block font-bold capitalize text-gray-700 mb-2">¿Cuántas Veces Se Mostró Tu Anuncio?</label>
                                            <input type="number" id="impressions" placeholder="Ej: 1,500" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent">
                                        </div>
                                        <div>
                                            <label for="clicks" class="block font-bold capitalize text-gray-700 mb-2">¿Cuántos Clics Tuvo El Enlace?</label>
                                            <input type="number" id="clicks" placeholder="Ej: 300" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent">
                                        </div>
                                        <div>
                                            <label for="demographics" class="block font-bold capitalize text-gray-700 mb-2">¿Quiénes Respondieron Mejor?</label>
                                            <input type="text" id="demographics" placeholder="Ej: Mujeres de 35-44" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" required>
                                        </div>
                                        <div>
                                            <label for="platform" class="block font-bold capitalize text-gray-700 mb-2">¿Qué Plataforma Funcionó Mejor?</label>
                                            <select id="platform" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" required>
                                                <option value="Facebook">Facebook</option>
                                                <option value="Instagram">Instagram</option>
                                                <option value="Ambas por igual">Ambas Por Igual</option>
                                            </select>
                                        </div>
                                        <div class="md:col-span-2">
                                            <label for="locations" class="block font-bold capitalize text-gray-700 mb-2">¿Qué Ciudades O Zonas Funcionaron Mejor?</label>
                                            <textarea id="locations" placeholder="Ej: Ciudad de México, Guadalajara, Monterrey" class="w-full p-3 bg-white border border-gray-300 rounded-lg focus:ring-2 focus:ring-[var(--color-primary)] focus:border-transparent" rows="3" required></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO+1" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                              <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>

                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-video"></i></span><div><strong class="text-brand-dark">Comprende La Herramienta:</strong> Dale play al video tutorial para sacar el máximo provecho al análisis.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-file-invoice-dollar"></i></span><div><strong class="text-brand-dark">Ingresa Datos Reales:</strong> Para obtener un diagnóstico preciso, utiliza los números exactos de tus campañas.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-cogs"></i></i></span><div><strong class="text-brand-dark">Genera Tu Plan de Acción:</strong> Haz clic en 'Analizar Mis Resultados' y deja que nuestra IA cree tu plan personalizado.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-user-check"></i></span><div><strong class="text-brand-dark">Usa Tu Criterio:</strong> La IA es una guía poderosa, pero tú eres el experto en tu negocio.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-chart-line"></i></span><div><strong class="text-brand-dark">Implementa Y Mide:</strong> Aplica las acciones que consideres más valiosas y mide el impacto.</div></li>
                            </ul>
                        </div>
                    </div>
                    
                    <div class="lg:col-span-5 bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                            <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                <i class="fas fa-magic-wand-sparkles mr-3 text-[var(--color-secondary)]"></i> 
                                <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> ANALIZAR MIS RESULTADOS
                            </h2>
                            <p class="step-subtitle text-center md:text-left uppercase">Obtén un plan de acción personalizado y estratégico basado en los datos que proporcionaste.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                        
                        <div class="flex flex-col md:flex-row items-center md:justify-between gap-4 md:gap-8 mb-6">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Para obtener un análisis preciso y un plan de acción efectivo para tus anuncios publicitarios, es <b>crucial que los datos que nos envíes sean exactos</b>. Basado en esta información, <strong class="font-black">CLIENT3 IA</strong>, nuestra Inteligencia Artificial, analizará detalladamente los resultados de <b>tus campañas</b> y te proporcionará un plan de acción completamente personalizado para optimizarlas</p>
                            <button id="generateBtn" type="submit" form="analyzer-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">ANALIZAR MIS RESULTADOS</span>
                                <div id="loader-container" class="hidden ml-3"></div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('analyzer-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');
    
    // --- Código para títulos de cabecera ---
    const pageTitleElement = document.getElementById('page-title');
    const pageSubtitleElement = document.getElementById('page-subtitle');
    const body = document.body;

    if (pageTitleElement && pageSubtitleElement) {
        const iconClass = body.getAttribute('data-page-icon');
        const iconHTML = iconClass ? `<i data-lucide="${iconClass}" class="w-7 h-7"></i>` : '';
        pageTitleElement.innerHTML = `${iconHTML} ${body.getAttribute('data-page-title') || 'Dashboard'}`;
        pageSubtitleElement.textContent = body.getAttribute('data-page-subtitle') || 'Gestión General';
        if (iconHTML) {
            lucide.createIcons();
        }
    }
    // --- Fin Código Títulos ---

    lucide.createIcons(); // Inicializa los iconos Lucide del resto de la página
    
    // --- Lógica para el video "Clic para Reproducir" ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');

    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false; 

        playOverlay.addEventListener('click', function() {
            playOverlay.style.display = 'none'; 
            videoPlayer.controls = true;      
            videoPlayer.play();                 
        });

        videoPlayer.addEventListener('ended', function() {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;    
        });
    }
    // --- Fin Lógica de video ---


    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        
        btnText.textContent = 'Analizando Datos...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-brand-dark rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        
        const formData = {
            campaign_objective: document.getElementById('campaign_objective').value,
            investment: document.getElementById('investment').value,
            messages: document.getElementById('messages').value,
            closed_clients: document.getElementById('closed_clients').value,
            service_price: document.getElementById('service_price').value,
            impressions: document.getElementById('impressions').value || 'N/A',
            clicks: document.getElementById('clicks').value || 'N/A',
            demographics: document.getElementById('demographics').value,
            locations: document.getElementById('locations').value,
            platform: document.getElementById('platform').value
        };

        try {
            // AHORA APUNTAMOS AL NUEVO ARCHIVO PHP
            const response = await fetch('api/API-Analista-De-Resultados-Publicitarios.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorBody = await response.text();
                throw new Error(`La respuesta del servidor no fue exitosa: ${response.status} ${errorBody}`);
            }

            const data = await response.json();
            if (data.error) {
                throw new Error(data.error);
            }
            
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            let errorMessage = "No se pudo generar el análisis. Por favor, revisa los datos que ingresaste e inténtalo de nuevo.";

            // Intenta parsear el mensaje de error para buscar el código 503
            try {
                // Modificado para manejar el formato del mensaje de error
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`; // Mantener detalles si es otro error
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`; // Si no hay JSON, solo añadir el mensaje completo
                }
            } catch (parseError) {
                // Si no se puede parsear, es un error inesperado, mostrar el mensaje completo
                errorMessage += ` Detalles: ${error.message}`;
            }

            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
        } finally {
            // RESTABLECER EL ESTADO DEL BOTÓN
            btnText.textContent = 'ANALIZAR MIS RESULTADOS';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        // QUITAR EL BORDE AMARILLO: Eliminadas las clases border-4 y border-[var(--color-highlight)]
        resultContainer.innerHTML = `
            <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-xl animate-slideInUp ai-response">
                <h3><i class="icon fas fa-check-circle text-[var(--color-secondary)]"></i>DIAGNÓSTICO GENERAL</h3>
                <p>${data.diagnostico_general || 'No se pudo generar un diagnóstico general.'}</p>
                
                <h3><i class="icon fas fa-chart-line text-[var(--color-secondary)]"></i>ANÁLISIS FINANCIERO Y DE RENDIMIENTO</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 text-center my-6">
                    <div class="bg-gray-50 p-6 rounded-lg border-2 border-gray-200 shadow-lg">
                        <p class="text-sm text-gray-700 mb-2 font-semibold uppercase">Costo por Cliente Nuevo</p>
                        <span class="text-5xl font-black text-brand-dark">${data.metricas_clave.cac}</span>
                    </div>
                    <div class="bg-gray-50 p-6 rounded-lg border-2 border-gray-200 shadow-lg">
                        <p class="text-sm text-gray-700 mb-2 font-semibold uppercase">Retorno de Inversión</p>
                        <span class="text-5xl font-black text-brand-dark">${data.metricas_clave.roi}</span>
                    </div>
                    <div class="bg-[var(--color-highlight)] p-6 rounded-lg border-2 border-[var(--color-highlight)] shadow-lg">
                        <p class="text-sm text-gray-700 mb-2 font-semibold uppercase">Tasa de Cierre</p>
                        <span class="text-5xl font-black text-brand-dark">${data.metricas_clave.tasa_cierre}</span>
                    </div>
                </div>
                <p>${data.analisis_financiero || ''}</p>
                <p>${data.diagnostico_anuncio || ''}</p>

                <h3><i class="icon fas fa-rocket text-[var(--color-secondary)]"></i>PLAN DE ACCIÓN SUGERIDO</h3>
                <ul class="action-plan-list space-y-4">
                    ${data.plan_de_accion.map(s => `
                        <li class="action-plan-item">
                            <span class="icon-container"><i class="fas fa-check"></i></span>
                            <span class="text">${s}</span>
                        </li>
                    `).join('')}
                </ul>
            </div>
        `;
        
        setTimeout(() => { 
            resultContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 200);
    }
});
</script>
</body>
</html>