<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Asistente De Cliente Ideal</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
</head>
<body data-page-title="Asistente De Cliente Ideal"
      data-page-subtitle="Define Con Claridad A Quién Le Vendes Y Cómo Comunicarte Mejor"
      data-page-icon="users">

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>
    <?php include 'menu.php'; ?>
    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800"><i data-lucide="menu" class="w-6 h-6"></i></button>
            <div class="page-header-container"><h2 id="page-title"></h2><p id="page-subtitle"></p></div>
        </header>
        <div id="content-area" class="p-4 md:p-8">
            <section id="ideal-client-assistant" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">
                    <div class="lg:col-span-3">
                        <form id="profile-generator-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header"><h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase"><i class="fas fa-bullseye mr-3 text-[var(--color-secondary)]"></i><span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> DESCRIBE A TU CLIENTE</h2><p class="step-subtitle uppercase">Ingresa los datos para perfilar a tu cliente ideal.</p></div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>
                                <div class="space-y-6">
                                    <div><label for="service" class="block font-bold text-gray-700 mb-2">Tu Servicio Principal Es...</label><input type="text" id="service" placeholder="Ej: Mantenimiento De Jardines" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required></div>
                                    <div><label for="client_desc" class="block font-bold text-gray-700 mb-2">Describe A Tus Clientes Como...</label><textarea id="client_desc" placeholder="Ej: Familias con niños y mascotas, ocupadas y con poco tiempo para la limpieza del hogar." class="w-full p-3 bg-white border border-gray-300 rounded-lg" rows="4" required></textarea></div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md"><div class="native-video-wrapper" id="videoWrapper"><div class="play-overlay" id="playOverlay"><img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl"><i class="fas fa-play play-icon"></i></div><video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata"><source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4"></video></div></div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md"><div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                              <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                                </div><div class="border-b border-gray-200 pb-4 mb-6"></div>
                                <ul class="space-y-4 text-gray-700"><li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-user-check"></i></span><div><strong>Claridad es Clave:</strong> Describe tu servicio y clientes de la manera más específica.</div></li><li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-lightbulb"></i></span><div><strong>IA en Acción:</strong> Clic en 'Generar Perfil' para que la IA deduzca sus problemas y deseos.</div></li><li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-bullhorn"></i></span><div><strong>Estrategia de Comunicación:</strong> Usa el perfil para crear mensajes más efectivos.</div></li></ul></div>
                    </div>
                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header"><h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase"><i class="fas fa-magic-wand-sparkles mr-3 text-[var(--color-secondary)]"></i><span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> GENERAR PERFIL</h2><p class="step-subtitle uppercase">Crea el perfil estratégico de tu cliente ideal con un solo clic.</p></div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                        <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Para definir a tu cliente ideal, es <b>esencial entender sus problemas y deseos más profundos</b>. Basado en tu información, <strong class="font-black">CLIENT3 IA</strong> generará un <b>perfil completo y estratégico</b>.</p>
                            <button id="generateBtn" type="submit" form="profile-generator-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase"><i class="fas fa-brain mr-3"></i><span id="btn-text">Generar Perfil De Cliente Ideal</span><div id="loader-container" class="hidden ml-3"></div></button>
                        </div>
                    </div>
                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();

    const form = document.getElementById('profile-generator-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    // Función para auto-ajustar la altura del textarea
    function autoResizeTextarea(textarea) {
        textarea.style.height = 'auto';
        textarea.style.height = textarea.scrollHeight + 'px';
    }

    function showError(message) {
        // console.error("Error:", message); // Mantener para depuración
        let errorMessage = "No se pudo generar el perfil. Por favor, revisa los datos que ingresaste e inténtalo de nuevo.";

        // Intenta parsear el mensaje de error para buscar el código 503
        try {
            // Se asume que el mensaje podría empezar con "Error del servidor XXX: " antes del JSON
            const jsonStartIndex = message.indexOf('{');
            if (jsonStartIndex !== -1) {
                const errorJsonString = message.substring(jsonStartIndex);
                const errorDetails = JSON.parse(errorJsonString);
                if (errorDetails.error && errorDetails.error.code === 503) {
                    errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                } else {
                    errorMessage += ` Detalles: ${message}`; // Mantener detalles si es otro error
                }
            } else {
                errorMessage += ` Detalles: ${message}`; // Si no hay JSON, solo añadir el mensaje completo
            }
        } catch (parseError) {
            // Si no se puede parsear, es un error inesperado, mostrar el mensaje completo
            errorMessage += ` Detalles: ${message}`;
        }
        resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
        resultContainer.scrollIntoView({ behavior: 'smooth', block: 'center' }); // Asegurar que el error sea visible
    }

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando Perfil...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-white rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        resultContainer.style.opacity = '0'; // Reinicia la opacidad para la animación


        try {
            const formData = {
                service: document.getElementById('service').value,
                client_desc: document.getElementById('client_desc').value,
            };
            const response = await fetch('api/API-Generador-De-Cliente-Ideal.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorBody = await response.text(); // Captura el cuerpo de la respuesta para detalles
                throw new Error(`El servidor respondió con un error ${response.status}. Detalle: ${errorBody}`);
            }
            
            const data = await response.json();

            if (data.error) throw new Error(data.error);
            if (!data.titulo_perfil || !data.sugerencias) throw new Error("La respuesta de la IA no tuvo el formato esperado. Inténtalo de nuevo.");
            
            displayResult(data);

        } catch (error) {
            showError(error.message);
        } finally {
            btnText.textContent = 'GENERAR PERFIL DE CLIENTE IDEAL';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });
    
    function displayResult(data) {
        const suggestionsHtml = data.sugerencias.map(s => `
            <li class="bg-gray-50 p-3 rounded-md border border-gray-200 shadow-sm flex items-start">
                <span class="icon-wrapper mt-1 mr-3"><i class="fas fa-check-circle text-[var(--color-highlight)]"></i></span>
                <div class="flex-1 text-gray-700">${s}</div>
            </li>
        `).join('');

        resultContainer.innerHTML = `
            <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8">
                <h2 class="profile-main-title text-3xl font-extrabold text-[var(--color-primary)] text-center mb-6">${data.titulo_perfil}</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-x-12 gap-y-8">
                    <div class="space-y-8">
                        <div class="p-4 bg-gray-50 rounded-lg shadow-sm border border-gray-200">
                            <h3 class="profile-section-title text-xl font-bold text-gray-800 mb-3 flex items-center">
                                <i class="fas fa-heart-crack mr-3 text-red-500"></i>El Problema Urgente
                            </h3>
                            <p class="profile-content-text text-gray-700 leading-relaxed">${data.problema}</p>
                        </div>
                        <div class="p-4 bg-gray-50 rounded-lg shadow-sm border border-gray-200">
                            <h3 class="profile-section-title text-xl font-bold text-gray-800 mb-3 flex items-center">
                                <i class="fas fa-star mr-3 text-yellow-500"></i>El Deseo Profundo
                            </h3>
                            <p class="profile-content-text text-gray-700 leading-relaxed">${data.deseo}</p>
                        </div>
                    </div>
                    <div class="space-y-8">
                         <div class="marketing-phrase-box p-4 bg-[var(--color-highlight)] text-brand-dark rounded-lg shadow-md border border-[var(--color-highlight)]">
                            <h3 class="profile-section-title text-xl font-bold text-brand-dark mb-3 flex items-center">
                                <i class="fas fa-key mr-3 text-brand-dark"></i>Frase de Marketing Clave
                            </h3>
                            <p class="profile-content-text text-brand-dark leading-relaxed">"${data.frase_marketing}"</p>
                        </div>
                        <div class="p-4 bg-gray-50 rounded-lg shadow-sm border border-gray-200">
                            <h3 class="profile-section-title text-xl font-bold text-gray-800 mb-3 flex items-center">
                                <i class="fas fa-lightbulb mr-3 text-blue-500"></i>Sugerencias Para Anuncios
                            </h3>
                            <ul class="suggestions-list space-y-3 mt-4">${suggestionsHtml}</ul>
                        </div>
                    </div>
                    <div class="md:col-span-2 mt-6 pt-6 border-t-2 border-gray-200">
                        <h3 class="profile-section-title text-xl font-bold text-gray-800 mb-3 flex items-center">
                            <i class="fas fa-paste mr-3 text-[var(--color-secondary)]"></i>Resumen Para Copiar y Usar
                        </h3>
                        <div class="relative mt-2 flex flex-col md:flex-row items-start md:items-center">
                            <textarea readonly id="summary-text" class="copy-summary-textarea w-full p-3 bg-gray-100 rounded-lg leading-relaxed text-gray-800 resize-y border border-gray-300 flex-grow mr-2"></textarea>
                            <button class="copy-btn-summary bg-[var(--color-highlight)] text-brand-dark font-bold py-1 px-2 rounded-lg hover:bg-opacity-90 transition-all duration-200 text-sm mt-2 md:mt-0 whitespace-nowrap">
                                <i class="fas fa-copy mr-1"></i> Copiar
                            </button>
                        </div>
                    </div>
                </div>
            </div>`;

        // Auto-ajustar altura del textarea después de que se establece el contenido
        const summaryTextarea = document.getElementById('summary-text');
        if (summaryTextarea) {
            summaryTextarea.value = data.resumen_copiar; // Asignar el contenido primero
            autoResizeTextarea(summaryTextarea);
            // Re-ajustar si el tamaño de la ventana cambia (útil para responsividad)
            window.addEventListener('resize', () => autoResizeTextarea(summaryTextarea));
        }

        document.getElementById('copy-summary-btn').addEventListener('click', function() {
            const textToCopy = document.getElementById('summary-text').value;
            navigator.clipboard.writeText(textToCopy).then(() => {
                this.innerHTML = '<i class="fas fa-check"></i> Copiado';
                this.classList.add('copied');
                setTimeout(() => {
                    this.innerHTML = '<i class="fas fa-copy"></i> Copiar';
                    this.classList.remove('copied');
                }, 2000);
            }).catch(err => {
                console.error('Error al copiar el texto: ', err);
            });
        });
        
        resultContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
    }
    
    // El resto del script no necesita cambios, solo inicializar
    const pageTitleElement = document.getElementById('page-title');
    const pageSubtitleElement = document.getElementById('page-subtitle');
    if (pageTitleElement && pageSubtitleElement) {
        const body = document.body;
        const iconClass = body.getAttribute('data-page-icon');
        const iconHTML = iconClass ? `<i data-lucide="${iconClass}" class="w-7 h-7"></i>` : '';
        pageTitleElement.innerHTML = `${iconHTML} ${body.getAttribute('data-page-title') || 'Dashboard'}`;
        pageSubtitleElement.textContent = body.getAttribute('data-page-subtitle') || 'Gestión General';
        if(iconHTML) lucide.createIcons();
    }
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => console.error("Error al reproducir video:", e));
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

});
</script>
<script src="files/header-manager.js"></script>
</body>
</html>