<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Generador De Hooks Para Anuncios</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
</head>
<body data-page-title="Generador De Hooks Para Anuncios"
      data-page-subtitle="Crea Títulos Y Textos Cortos Y Potentes Para Tus Imágenes De Post"
      data-page-icon="image-plus">

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="hook-generator" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">

                    <div class="lg:col-span-3">
                        <form id="hook-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <i class="fas fa-bullseye mr-3 text-[var(--color-secondary)]"></i>
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> DEFINE TU ANUNCIO
                                    </h2>
                                    <p class="step-subtitle uppercase">Ingresa los datos de tu servicio y cliente ideal para generar los hooks.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-6">
                                    <div>
                                        <label for="service" class="block font-bold text-gray-700 mb-2">¿Qué Servicio Ofreces?</label>
                                        <input type="text" id="service" placeholder="Ej: Servicios De Contabilidad" class="w-full p-3 bg-white border border-gray-300 rounded-lg" required>
                                    </div>
                                    <div>
                                        <label for="ideal_client_summary" class="block font-bold text-gray-700 mb-2">Pega El Resumen De Tu Cliente Ideal</label>
                                        <textarea id="ideal_client_summary" placeholder="Pega aquí el resumen que generaste con la Herramienta 'Asistente Cliente Ideal'..." class="w-full p-3 bg-white border border-gray-300 rounded-lg" rows="6" required></textarea>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                              <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-lightbulb"></i></span><div><strong class="text-brand-dark">Pega el Resumen:</strong> Utiliza el resultado de la herramienta 'Asistente de Cliente Ideal' para el campo 'Resumen de Tu Cliente Ideal'.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-cogs"></i></span><div><strong class="text-brand-dark">Genera Hooks:</strong> La IA creará 6 ganchos (3 por problema, 3 por transformación) y 2-3 ideas para tus imágenes.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-magic-wand-sparkles"></i></span><div><strong class="text-brand-dark">Corta y Pega:</strong> Estos hooks están diseñados para ser cortos y directos, ideales para superponer en tus imágenes de anuncios.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-chart-line"></i></span><div><strong class="text-brand-dark">Aumenta tu CTR:</strong> Un buen hook capta la atención al instante y aumenta la tasa de clics de tus anuncios.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                             <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i class="fas fa-sparkles mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> GENERAR HOOKS
                            </h2>
                            <p class="step-subtitle uppercase">Crea títulos y textos cortos y potentes para tus imágenes de post.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                         <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Basado en tu servicio y tu cliente ideal, <strong class="font-black">CLIENT3 IA</strong>, generará <b>hooks persuasivos y concisos</b>, listos para captar la atención de tu audiencia en segundos y maximizar el impacto visual de tus anuncios.</p>
                            <button id="generateBtn" type="submit" form="hook-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">GENERAR HOOKS</span>
                                <div id="loader-container" class="hidden ml-3"></div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();

    // --- Lógica del Video Player ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => console.error("Error al reproducir video:", e));
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

    // --- Lógica del Generador ---
    const form = document.getElementById('hook-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Generando...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        resultContainer.style.opacity = '0'; // Reinicia la opacidad para la animación

        const formData = {
            service: document.getElementById('service').value,
            ideal_client_summary: document.getElementById('ideal_client_summary').value,
        };

        try {
            const response = await fetch('api/API-Generador-De-Titulos-Para-Imagenes.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(formData)
            });

            if (!response.ok) {
                const errorText = await response.text();
                throw new Error(`El servidor respondió con un error ${response.status}. Detalle: ${errorText}`);
            }

            const data = await response.json();
            if(data.error) {
                throw new Error(data.error);
            }
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            let errorMessage = "No se pudieron generar los hooks. Por favor, revisa los datos e inténtalo de nuevo.";

            // Intenta parsear el mensaje de error para buscar el código 503
            try {
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`;
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`;
                }
            } catch (parseError) {
                errorMessage += ` Detalles: ${error.message}`;
            }
            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.style.opacity = '1'; // Mostrar el error inmediatamente
        } finally {
            btnText.textContent = 'GENERAR HOOKS';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.innerHTML = `
            <div class="bg-white p-6 md:p-8 rounded-xl shadow-md space-y-8 ai-response">
                <div>
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-exclamation-circle mr-3 text-red-500"></i>Hooks Enfocados En El Problema</h3>
                    <p class="section-subtitle text-gray-600 mb-4">Ganchos directos que resuenan con las dificultades de tu cliente ideal.</p>
                    ${createHookSection(data.problem_hooks)}
                </div>

                <div class="border-t border-gray-200 pt-8">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-star mr-3 text-yellow-500"></i>Hooks Enfocados En La Transformación</h3>
                    <p class="section-subtitle text-gray-600 mb-4">Ganchos que prometen el resultado deseado y el cambio positivo.</p>
                    ${createHookSection(data.result_hooks)}
                </div>

                <div class="border-t border-gray-200 pt-8">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-image mr-3 text-[var(--color-secondary)]"></i>IDEAS PARA LA IMAGEN</h3>
                    <p class="section-subtitle text-gray-600 mb-4">Sugerencias visuales para complementar tus hooks y captar más atención.</p>
                    <ul class="action-plan-list mt-4 space-y-3">
                        ${data.image_ideas.map(idea => `
                            <li class="action-plan-item bg-gray-50 p-3 rounded-md border border-gray-200 shadow-sm flex items-start">
                                <span class="icon-wrapper mt-1 mr-3"><i class="fas fa-check-circle text-[var(--color-highlight)]"></i></span>
                                <div class="flex-1 text-gray-700">${idea}</div>
                            </li>
                        `).join('')}
                    </ul>
                </div>
            </div>
        `;

        setTimeout(() => { resultContainer.style.opacity = '1'; resultContainer.style.transform = 'scale(1)'; }, 100);
    }

    function createHookSection(hooks) {
        let html = '<div class="mt-4 grid grid-cols-1 md:grid-cols-3 gap-6">';
        hooks.forEach(hook => {
            html += `
                <div class="hook-card bg-gray-50 p-4 rounded-lg border border-gray-200 shadow-sm">
                    <div class="hook-content">
                        <p class="font-bold text-gray-800 text-lg"><span class="text-[var(--color-primary)] mr-2">🇪🇸</span> ${hook.es}</p>
                        <p class="font-normal text-gray-700 mt-2 text-base"><span class="text-[var(--color-primary)] mr-2">🇺🇸</span> ${hook.en}</p>
                    </div>
                    <button class="copy-hook-btn bg-[var(--color-primary)] text-white px-3 py-1 rounded-md text-sm hover:opacity-90 transition-opacity mt-3 w-full" data-copytext-es="${encodeURIComponent(hook.es)}" data-copytext-en="${encodeURIComponent(hook.en)}">
                        <i class="fas fa-copy mr-1"></i>Copiar
                    </button>
                </div>
            `;
        });
        html += '</div>';
        return html;
    }

    // Listener para los botones de copiar de los hooks
    resultContainer.addEventListener('click', function(e) {
        const button = e.target.closest('.copy-hook-btn');
        if (button) {
            const textToCopyEs = decodeURIComponent(button.dataset.copytextEs);
            const textToCopyEn = decodeURIComponent(button.dataset.copytextEn);
            const combinedText = `🇪🇸 ${textToCopyEs}\n🇺🇸 ${textToToCopyEn}`; // Copia ambos para comodidad

            navigator.clipboard.writeText(combinedText).then(() => {
                const originalContent = button.innerHTML;
                button.innerHTML = '<i class="fas fa-check"></i> Copiado';
                button.classList.add('copied');
                setTimeout(() => {
                    button.innerHTML = originalContent;
                    button.classList.remove('copied');
                }, 2000);
            }).catch(err => {
                console.error('Error al copiar el texto: ', err);
            });
        }
    });
});
</script>

</body>
</html>