<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Mini Test De Diagnóstico</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
</head>
<body data-page-title="Mini Test De Diagnóstico"
      data-page-subtitle="Un Diagnóstico Rápido Para Descubre Dónde Estás Y Qué Mejorar"
      data-page-icon="clipboard-check">

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="diagnostic-tool" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">

                    <div class="lg:col-span-3">
                        <form id="diagnostic-form" class="space-y-8 bg-white p-8 rounded-xl shadow-md">
                            <div>
                                <div class="step-header">
                                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                        <i class="fas fa-question-circle mr-3 text-[var(--color-secondary)]"></i>
                                        <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> RESPONDE LAS PREGUNTAS
                                    </h2>
                                    <p class="step-subtitle uppercase">Marca todas las opciones que se parezcan a tu situación actual.</p>
                                </div>
                                <div class="border-b border-gray-200 pb-4 mb-6"></div>

                                <div class="space-y-8">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-8" id="diagnostic-options">
                                        </div>
                                    <div class="mt-6">
                                        <label for="diag-other" class="block font-bold text-gray-700 mb-2">Otro (Opcional):</label>
                                        <input id="diag-other" name="otro" type="text" placeholder="Describe brevemente otra situación..." class="w-full p-3 bg-white border border-gray-300 rounded-lg">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>
                        <div class="bg-white text-brand-dark p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                              <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-check-double"></i></span><div><strong class="text-brand-dark">Marca Tus Situaciones:</strong> Selecciona todas las opciones que reflejen tu realidad actual.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-brain"></i></span><div><strong class="text-brand-dark">Genera el Diagnóstico:</strong> Haz clic en el botón para que la IA analice tus respuestas.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-lightbulb"></i></span><div><strong class="text-brand-dark">Recibe Tu Plan:</strong> Obtén una puntuación, un diagnóstico general y un plan de acción personalizado.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-road"></i></span><div><strong class="text-brand-dark">Descubre Tu Camino:</strong> El plan te indicará los pasos clave y módulos del curso para superar tus desafíos.</div></li>
                            </ul>
                        </div>
                    </div>

                    <div class="lg:col-span-5 bg-white p-6 md:p-8 rounded-xl shadow-md mt-6">
                        <div class="step-header">
                             <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i class="fas fa-flask mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> GENERAR DIAGNÓSTICO
                            </h2>
                            <p class="step-subtitle uppercase">Descubre dónde estás y cuál es el camino ideal para ti.</p>
                        </div>
                        <div class="border-b border-gray-200 pb-4 mb-6"></div>
                         <div class="flex flex-col md:flex-row items-center md:justify-between gap-4">
                            <p class="text-lg text-center md:text-left text-gray-700 md:flex-1 md:pr-4 mb-0">Basado en tus respuestas, <strong class="font-black">CLIENT3 IA</strong> te proporcionará un <b>diagnóstico rápido y personalizado</b>. Recibirás una puntuación de preparación y un plan de acción concreto para ayudarte a avanzar.</p>
                            <button id="generateBtn" type="submit" form="diagnostic-form" class="w-full md:w-auto bg-[var(--color-highlight)] text-brand-dark font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                                <i class="fas fa-brain mr-3"></i>
                                <span id="btn-text">GENERAR MI DIAGNÓSTICO</span>
                                <div id="loader-container" class="hidden ml-3"></div>
                            </button>
                        </div>
                    </div>

                    <div id="result-container" class="lg:col-span-5 mt-8"></div>
                </div>
            </section>
        </div>
    </main>
</div>

<script src="files/header-manager.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();

    // --- Lógica del Video Player ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => console.error("Error al reproducir video:", e));
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }

    // --- Lógica del Generador ---
    const optionsContainer = document.getElementById('diagnostic-options');
    const diagnosticPoints = [
        { id: 'diag-1', label: 'Dependo Únicamente De Recomendaciones', desc: 'Mis clientes llegan solo si alguien habla de mí. Si no, no tengo nuevos clientes.' },
        { id: 'diag-2', label: 'Publico En Redes, Pero No Veo Resultados', desc: 'Subo contenido, pero nadie comenta ni me contacta. Me siento invisible.' },
        { id: 'diag-3', label: 'He Hecho Anuncios, Pero No Sé Si Funcionan', desc: 'He gastado dinero, pero no entiendo si es una inversión o solo un gasto.' },
        { id: 'diag-4', label: 'No Estoy Haciendo Nada Para Atraer Clientes', desc: 'No tengo una estrategia activa, solo espero que los clientes lleguen solos.' },
        { id: 'diag-5', label: 'Pago A Alguien, Pero No Veo Resultados', desc: 'He contratado ayuda, pero no tengo claridad sobre lo que hacen ni veo más clientes.' },
        { id: 'diag-6', label: 'Veo Videos En YouTube, Pero Me Confundo', desc: 'Busco información, pero todo es confuso, técnico o se contradice.' },
        { id: 'diag-7', label: 'Compro “Leads”, Pero Muchos No Me Contratan', desc: 'Pago por contactos, pero pocos responden o se interesan realmente en mi servicio.' },
        { id: 'diag-8', label: 'Quiero Aprender A Crecer Por Mi Cuenta', desc: 'No quiero depender más de otros para conseguir clientes para mi negocio.' }
    ];

    diagnosticPoints.forEach(point => {
        const div = document.createElement('div');
        div.className = 'form-checkbox-option bg-white p-4 rounded-lg shadow-sm border border-gray-200 flex items-start'; // Changed items-center to items-start for better alignment with larger checkbox
        div.innerHTML = `
            <input id="${point.id}" name="${point.label}" type="checkbox" class="form-checkbox w-6 h-6 flex-shrink-0 mt-1"> 
            <div class="ml-4 flex-1">
                <label for="${point.id}" class="form-checkbox-label font-extrabold text-gray-800 text-base">${point.label}</label>
                <p class="form-checkbox-description text-gray-600 text-sm mt-1">${point.desc}</p>
            </div>`;
        optionsContainer.appendChild(div);
    });

    const form = document.getElementById('diagnostic-form');
    const resultContainer = document.getElementById('result-container');
    const generateBtn = document.getElementById('generateBtn');
    const btnText = document.getElementById('btn-text');
    const loaderContainer = document.getElementById('loader-container');

    form.addEventListener('submit', async function(event) {
        event.preventDefault();
        btnText.textContent = 'Analizando Tu Situación Actual...';
        loaderContainer.innerHTML = '<div class="w-6 h-6 border-4 border-t-transparent border-[var(--color-primary)] rounded-full animate-spin"></div>';
        loaderContainer.classList.remove('hidden');
        generateBtn.disabled = true;
        resultContainer.innerHTML = '';
        resultContainer.style.opacity = '0'; // Reinicia la opacidad para la animación

        const selectedOptions = [];
        form.querySelectorAll('input[type=checkbox]:checked').forEach(checkbox => {
            selectedOptions.push(checkbox.name);
        });

        const otherInput = document.getElementById('diag-other').value;
        if (otherInput) {
            selectedOptions.push(`Otro: ${otherInput}`);
        }

        if (selectedOptions.length === 0) {
            alert('Por favor, selecciona al menos una opción para continuar.');
            btnText.textContent = 'GENERAR MI DIAGNÓSTICO';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
            return;
        }

        try {
            const response = await fetch('api/API-Mini-Test-De-Diagnostico.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ situations: selectedOptions })
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `El servidor respondió con un error ${response.status}.`);
            }

            const data = await response.json();
            if(data.error) {
                throw new Error(data.error);
            }
            displayResult(data);

        } catch (error) {
            console.error("Error:", error);
            let errorMessage = "No se pudo generar el diagnóstico. Por favor, revisa los datos que ingresaste e inténtalo de nuevo.";

            // Intenta parsear el mensaje de error para buscar el código 503
            try {
                const jsonStartIndex = error.message.indexOf('{');
                if (jsonStartIndex !== -1) {
                    const errorJsonString = error.message.substring(jsonStartIndex);
                    const errorDetails = JSON.parse(errorJsonString);
                    if (errorDetails.error && errorDetails.error.code === 503) {
                        errorMessage = "LO SENTIMOS En Este Momento, Nuestra Inteligencia Artificial Está Saturada. Por favor, Inténtalo De Nuevo En Unos Minutos.";
                    } else {
                        errorMessage += ` Detalles: ${error.message}`;
                    }
                } else {
                    errorMessage += ` Detalles: ${error.message}`;
                }
            } catch (parseError) {
                errorMessage += ` Detalles: ${error.message}`;
            }

            resultContainer.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> ${errorMessage}</p></div>`;
            resultContainer.style.opacity = '1'; // Mostrar el error inmediatamente
        } finally {
            btnText.textContent = 'GENERAR MI DIAGNÓSTICO';
            loaderContainer.classList.add('hidden');
            generateBtn.disabled = false;
        }
    });

    function displayResult(data) {
        resultContainer.innerHTML = `
            <div class="ai-response p-6 md:p-8 rounded-xl shadow-md space-y-8">
                <div class="diagnostic-score-container text-center bg-gray-50 p-6 rounded-lg border border-gray-200 shadow-sm">
                    <h2 class="diagnostic-score-title text-3xl font-extrabold text-[var(--color-primary)] mb-3">Tu Puntuación De Preparación</h2>
                    <p class="diagnostic-score-number text-6xl font-black text-brand-dark">${data.puntuacion}<span class="text-3xl">/10</span></p>
                </div>

                <div class="ai-report-section mt-8 pt-8 border-t border-gray-200">
                    <h3 class="ad-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-search-plus mr-3 text-[var(--color-primary)]"></i>Diagnóstico General</h3>
                    <p class="section-content-text text-gray-700 leading-relaxed">${data.diagnostico_general}</p>
                </div>
                
                <div class="ai-report-action-plan-container mt-8 pt-8 border-t border-gray-200">
                    <h3 class="ai-action-plan-title text-xl font-bold text-gray-800 mb-3 flex items-center"><i class="fas fa-tasks mr-3 text-[var(--color-secondary)]"></i>Tu Plan De Acción Personalizado</h3>
                    <div class="mt-6 space-y-6">
                        ${data.plan_de_accion.map((step, index) => `
                            <div class="plan-action-step-item bg-gray-50 p-4 rounded-lg border border-gray-200 shadow-sm flex items-start">
                                <div class="plan-action-number-circle bg-[var(--color-secondary)] text-white font-bold rounded-full w-8 h-8 flex items-center justify-center flex-shrink-0">${index + 1}</div>
                                <div class="ml-4 flex-1">
                                    <p class="plan-action-step-text text-gray-700 leading-relaxed">
                                        ${step.replace(/\*\*(.*?)\*\*/g, '<strong class="text-[var(--color-primary)]">$1</strong>')}
                                    </p>
                                </div>
                            </div>
                        `).join('')}
                    </div>
                </div>
            </div>
        `;
        setTimeout(() => { resultContainer.style.opacity = '1'; resultContainer.style.transform = 'scale(1)'; }, 100);
    }
});
</script>

</body>
</html>