<?php include 'GuardianKey.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LocalCRM ToolKit | Optimizador De WhatsApp Business</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="tools.css">
    
    <style>
        /* Estilos específicos que no están en tools.css pero que son necesarios */
        .toggle-label { position: relative; display: inline-block; width: 50px; height: 28px; }
        .toggle-label input { opacity: 0; width: 0; height: 0; }
        .toggle-slider {
            position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0;
            background-color: #ccc; transition: .4s; border-radius: 28px;
        }
        .toggle-slider:before {
            position: absolute; content: ""; height: 20px; width: 20px; left: 4px; bottom: 4px;
            background-color: white; transition: .4s; border-radius: 50%;
        }
        input:checked + .toggle-slider { background-color: var(--color-primary); }
        input:checked + .toggle-slider:before { transform: translateX(22px); }

        /* Estilos para la respuesta de IA, adaptados a tus variables CSS */
        .ai-response h3 {
            font-size: 1.75rem; font-weight: 900; color: var(--color-primary);
            margin-top: 2rem; margin-bottom: 1rem; padding-bottom: 0.5rem;
            border-bottom: 2px solid var(--color-highlight); display: flex; align-items: center;
        }
        .ai-response h3::before {
            font-family: "Font Awesome 6 Free"; font-weight: 900; margin-right: 0.75rem;
            color: var(--color-secondary);
        }
       .ai-response h3:first-of-type::before { content: '\f0eb'; } /* lightbulb */
       .ai-response h3:nth-of-type(2)::before { content: '\f085'; } /* cogs */
       .ai-response h3:nth-of-type(3)::before { content: '\f1d8'; } /* rocket */
       .ai-response ul { list-style-type: none; padding-left: 0; margin-bottom: 1rem; }
       .ai-response li {
           padding-left: 1.5rem; position: relative; margin-bottom: 0.5rem; line-height: 1.6;
       }
       .ai-response li::before {
           content: '\f00c'; font-family: "Font Awesome 6 Free"; font-weight: 900;
           position: absolute; left: 0; top: 4px; color: var(--color-primary);
       }
       .ai-response p { margin-bottom: 1rem; line-height: 1.6; }
       .ai-response strong { color: var(--color-primary); }
       .loader-ai { border: 4px solid #d1d5db; border-top: 4px solid var(--color-primary); border-radius: 50%; width: 24px; height: 24px; animation: spin 1s linear infinite; }
       @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
</head>
<body data-page-title="Optimizador De WhatsApp Business"
      data-page-subtitle="Tu Diagnóstico Y Plan De Acción Inteligente Para WhatsApp"
      data-page-icon="whatsapp">

<div class="relative min-h-screen md:flex">
    <div id="sidebar-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-30 hidden md:hidden"></div>

    <?php include 'menu.php'; ?>

    <main class="flex-1 overflow-y-auto">
        <header class="bg-white shadow-sm p-4 flex justify-between items-center sticky top-0 z-20">
            <button id="mobile-menu-button" class="md:hidden text-gray-600 hover:text-gray-800">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <div class="page-header-container">
                <h2 id="page-title"></h2>
                <p id="page-subtitle"></p>
            </div>
        </header>

        <div id="content-area" class="p-4 md:p-8">
            <section id="whatsapp-optimizer" class="dashboard-section">
                <div class="grid grid-cols-1 lg:grid-cols-5 gap-8">
                    <div class="lg:col-span-3">
                        <div class="bg-white text-gray-800 rounded-xl shadow-md p-6 md:p-8">
                            <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                                <i class="fab fa-whatsapp mr-3 text-[var(--color-secondary)]"></i>
                                <span class="text-[var(--color-secondary)] mr-2">PASO 1:</span> COMPLETA TU DIAGNÓSTICO
                            </h2>
                            <p class="step-subtitle uppercase">Responde las preguntas para evaluar tu perfil de WhatsApp Business.</p>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <div id="checklist-container">
                                </div>
                        </div>
                    </div>

                    <div class="lg:col-span-2 space-y-8">
                        <div class="bg-white rounded-xl shadow-md">
                            <div class="native-video-wrapper" id="videoWrapper">
                                <div class="play-overlay" id="playOverlay">
                                    <img src="https://placehold.co/600x337/07162d/ffc857?text=VIDEO" alt="Imagen de previsualización del video" class="absolute inset-0 w-full h-full object-cover rounded-xl">
                                    <i class="fas fa-play play-icon"></i>
                                </div>
                                <video class="w-full h-full object-cover" id="videoPlayer" controlslist="nodownload nofullscreen" preload="metadata">
                                    <source src="https://samplelib.com/lib/preview/mp4/sample-5s.mp4" type="video/mp4">
                                    Tu navegador no soporta la etiqueta de video.
                                </video>
                            </div>
                        </div>

                        <div class="bg-[var(--color-primary)] text-white rounded-xl shadow-md p-6 border-2 border-[var(--color-highlight)] flex flex-col items-center justify-center">
                            <h3 class="text-2xl font-bold mb-4 text-center">Puntuación De Tu Perfil</h3>
                            <div id="score-display" class="text-7xl font-black text-[var(--color-highlight)] mb-2">0%</div>
                            <div class="w-full bg-gray-700 rounded-full h-4">
                                <div id="progress-bar" class="bg-[var(--color-highlight)] h-4 rounded-full" style="width: 0%; transition: width 0.5s;"></div>
                            </div>
                        </div>

                        <div class="bg-white text-[var(--color-primary)] p-6 md:p-8 rounded-xl shadow-md">
                            <div class="step-header">
                                <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase justify-center md:justify-start">
                                    <i class="fas fa-book mr-3 text-[var(--color-highlight)]"></i> 
                                    INSTRUCCIONES
                                </h2>
                                <p class="step-subtitle text-center md:text-left uppercase">REVISA ESTOS PUNTOS DETALLADAMENTE</p>
                            </div>
                            <div class="border-b border-gray-200 pb-4 mb-6"></div>
                            <ul class="space-y-4 text-gray-700">
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-check-double"></i></span><div><strong class-[var(--color-primary)]>Responde El Cuestionario:</strong> Evalúa cada punto de tu perfil de WhatsApp Business.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-percent"></i></span><div><strong class-[var(--color-primary)]>Mira Tu Puntuación:</strong> Descubre qué tan optimizado está tu perfil.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-tasks"></i></span><div><strong class-[var(--color-primary)]>Obtén Tareas Pendientes:</strong> Se generará una lista de acciones rápidas para mejorar.</div></li>
                                <li class="instructions-list-item"><span class="icon-wrapper"><i class="fas fa-lightbulb"></i></span><div><strong class-[var(--color-primary)]>Genera La Estrategia IA:</strong> Recibe un plan detallado y personalizado para tus puntos débiles.</div></li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white text-gray-800 rounded-xl shadow-md p-6 mt-8 lg:col-span-5">
                    <h3 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase mb-4">
                        <i class="fas fa-list-check mr-3 text-[var(--color-secondary)]"></i>
                        <span class="text-[var(--color-secondary)] mr-2">TAREAS:</span> TU PLAN DE ACCIÓN RÁPIDA
                    </h3>
                    <div class="border-b border-gray-200 pb-4 mb-6"></div>
                    <div id="task-list" class="space-y-4">
                        <p class="text-gray-500">Tus tareas pendientes aparecerán aquí...</p>
                    </div>
                </div>

                <div id="ai-assistant-section" class="bg-white text-gray-800 rounded-xl shadow-md p-6 md:p-8 mt-8 hidden lg:col-span-5">
                    <h2 class="text-2xl font-black pb-0 mb-0 flex items-center uppercase">
                        <i class="fas fa-robot mr-3 text-[var(--color-secondary)]"></i>
                        <span class="text-[var(--color-secondary)] mr-2">PASO 2:</span> RECIBE TU ESTRATEGIA PERSONALIZADA
                    </h2>
                    <p class="step-subtitle uppercase">Basado en tu diagnóstico, nuestro asistente de IA ha preparado un plan detallado para ti. Haz clic para revelarlo.</p>
                    <div class="border-b border-gray-200 pb-4 mb-6"></div>
                    
                    <button id="get-ai-advice-btn" class="w-full md:w-auto bg-[var(--color-highlight)] text-[var(--color-primary)] font-bold py-4 px-6 rounded-lg hover:scale-105 transition-transform shadow-lg text-lg flex items-center justify-center uppercase">
                        <i class="fas fa-brain mr-3"></i>
                        <span>Generar Mi Estrategia</span>
                    </button>

                    <div id="ai-response-container" class="mt-8 border-t border-gray-200 pt-6 hidden">
                        <div id="ai-loader" class="flex items-center">
                            <div class="loader-ai mr-4"></div>
                            <span class="text-[var(--color-primary)] font-semibold">El Asistente Está Preparando Tu Estrategia...</span>
                        </div>
                        <div id="ai-response-content" class="ai-response"></div>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>

<?php include 'FooterBK.php'; ?>
<script src="files/header-manager.js"></script>
<script type="module">
document.addEventListener('DOMContentLoaded', function() {
    lucide.createIcons();
    
    // --- Lógica del Video Player ---
    const videoPlayer = document.getElementById('videoPlayer');
    const playOverlay = document.getElementById('playOverlay');
    if (videoPlayer && playOverlay) {
        videoPlayer.controls = false;
        playOverlay.addEventListener('click', () => {
            playOverlay.style.display = 'none';
            videoPlayer.controls = true;
            videoPlayer.play().catch(e => console.error("Error al reproducir video:", e));
        });
        videoPlayer.addEventListener('ended', () => {
            playOverlay.style.display = 'flex';
            videoPlayer.controls = false;
        });
    }
    // --- Fin Lógica de video ---

    const checklistData = [
        { id: 'foto', question: '¿Tienes una foto de perfil profesional?', recommendation: 'Sube un logo claro de tu negocio o una foto profesional tuya.', category: 'Identidad Visual' },
        { id: 'nombre', question: '¿Tu nombre de negocio es claro y reconocible?', recommendation: 'Asegúrate que el nombre sea el oficial de tu negocio y fácil de encontrar.', category: 'Identidad Visual' },
        { id: 'descripcion', question: '¿Tu descripción incluye lo que haces y tu valor único?', recommendation: 'Escribe una descripción corta que explique tus servicios y lo que te hace especial.', category: 'Información Básica' },
        { id: 'categoria', question: '¿Has seleccionado la categoría correcta para tu negocio?', recommendation: 'Ve a Ajustes > Herramientas para la empresa > Perfil y elige la categoría adecuada.', category: 'Información Básica' },
        { id: 'horario', question: '¿Tienes configurado tu horario comercial?', recommendation: 'Establece tu horario para que los clientes sepan cuándo estás disponible.', category: 'Información Básica' },
        { id: 'direccion', question: '¿Has añadido tu dirección o área de servicio?', recommendation: 'Si tienes un local físico, añade la dirección. Si no, define tu área de servicio.', category: 'Información Básica' },
        { id: 'emailweb', question: '¿Has incluido tu email y página web?', recommendation: 'Añade tu correo y sitio web para dar más credibilidad y puntos de contacto.', category: 'Información Básica' },
        { id: 'catalogo', question: '¿Has creado un catálogo con tus productos o servicios?', recommendation: 'Crea un catálogo con fotos, nombres, precios y descripciones. Es tu tienda virtual.', category: 'Ventas' },
        { id: 'saludo', question: '¿Tienes un mensaje de bienvenida automático?', recommendation: 'Configura un saludo automático para causar una buena primera impresión al instante.', category: 'Automatización' },
        { id: 'ausencia', question: '¿Tienes un mensaje de ausencia para fuera del horario?', recommendation: 'Informa a los clientes que has recibido su mensaje y cuándo responderás.', category: 'Automatización' },
        { id: 'respuestas', question: '¿Usas las respuestas rápidas para preguntas frecuentes?', recommendation: 'Crea respuestas rápidas para ahorrar tiempo. Ej: "/gracias", "/horario", "/precios".', category: 'Eficiencia' },
        { id: 'etiquetas', question: '¿Usas etiquetas para organizar tus chats?', recommendation: 'Organiza tus chats con etiquetas como "Nuevo Cliente", "Pago Pendiente", "Pedido Finalizado".', category: 'Eficiencia' },
        { id: 'enlace', question: '¿Compartes tu enlace corto o código QR de WhatsApp?', recommendation: 'Usa el enlace corto en tus redes sociales para que la gente te contacte con un solo clic.', category: 'Marketing' },
    ];

    const checklistContainer = document.getElementById('checklist-container');
    const progressBar = document.getElementById('progress-bar');
    const scoreDisplay = document.getElementById('score-display');
    const taskList = document.getElementById('task-list');
    const aiAssistantSection = document.getElementById('ai-assistant-section');
    const getAiAdviceBtn = document.getElementById('get-ai-advice-btn');
    const aiResponseContainer = document.getElementById('ai-response-container');
    const aiLoader = document.getElementById('ai-loader');
    const aiResponseContent = document.getElementById('ai-response-content');

    function renderChecklist() {
        checklistContainer.innerHTML = checklistData.map(item => {
            const formattedQuestion = item.question.charAt(0).toUpperCase() + item.question.slice(1);
            return `
                <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center border-b border-gray-200 py-3 gap-3">
                    <p class="font-semibold text-lg text-[var(--color-primary)]">${formattedQuestion}</p>
                    <div class="flex items-center flex-shrink-0 space-x-3 self-end sm:self-center">
                        <span class="text-gray-500 text-sm">No</span>
                        <label class="toggle-label">
                            <input type="checkbox" name="${item.id}" class="toggle-switch">
                            <span class="toggle-slider"></span>
                        </label>
                        <span class="font-bold text-[var(--color-primary)] text-sm">Sí</span>
                    </div>
                </div>
            `;
        }).join('');
    }

    function updateProgressAndTasks() {
        const totalQuestions = checklistData.length;
        const yesAnswers = document.querySelectorAll('input.toggle-switch:checked').length;
        
        const percentage = totalQuestions > 0 ? Math.round((yesAnswers / totalQuestions) * 100) : 0;
        progressBar.style.width = `${percentage}%`;
        scoreDisplay.textContent = `${percentage}%`;

        taskList.innerHTML = ''; // Limpiar la lista de tareas antes de actualizar
        let tasksAdded = false;
        let allTasksCompleted = true;

        checklistData.forEach(item => {
            const checkbox = document.querySelector(`input[name="${item.id}"]`);
            if (checkbox && !checkbox.checked) {
                const taskHTML = `
                    <div class="bg-gray-50 p-4 rounded-lg shadow-sm border-l-4 border-[var(--color-secondary)] flex items-start space-x-4">
                        <div class="flex-shrink-0 pt-1">
                            <i class="fas fa-exclamation-triangle text-[var(--color-secondary)] text-xl"></i>
                        </div>
                        <div class="flex-grow">
                            <span class="text-xs font-bold uppercase text-[var(--color-secondary)] tracking-wider">${item.category}</span>
                            <p class="text-gray-700 font-medium mt-1">${item.recommendation}</p>
                        </div>
                    </div>
                `;
                taskList.innerHTML += taskHTML;
                tasksAdded = true;
                allTasksCompleted = false;
            }
        });

        if (allTasksCompleted) {
             taskList.innerHTML = `
                <div class="bg-green-100 p-4 rounded-lg border-l-4 border-green-500 flex items-center space-x-4">
                    <i class="fas fa-trophy text-green-600 text-2xl"></i>
                    <div>
                        <h4 class="font-bold text-green-800">¡Excelente trabajo!</h4>
                        <p class="text-green-700">Has cubierto todos los puntos clave de tu perfil.</p>
                    </div>
                </div>
            `;
        } else if (!tasksAdded) {
            taskList.innerHTML = '<p class="text-gray-500">Tus tareas pendientes aparecerán aquí...</p>';
        }

        // Mostrar u ocultar la sección de IA
        if (percentage < 100) { // Solo mostrar si hay tareas pendientes (porcentaje < 100)
            aiAssistantSection.classList.remove('hidden');
        } else {
            aiAssistantSection.classList.add('hidden');
        }
    }
    
    async function getAIAdvice() {
        const pendingTasks = checklistData
            .filter(item => {
                const checkbox = document.querySelector(`input[name="${item.id}"]`);
                return checkbox && !checkbox.checked;
            })
            .map(item => `- **${item.category}:** ${item.recommendation}`);

        if (pendingTasks.length === 0) return; // No generar si no hay tareas pendientes

        aiLoader.style.display = 'flex';
        aiResponseContent.innerHTML = '';
        aiResponseContainer.classList.remove('hidden');
        getAiAdviceBtn.disabled = true;
        getAiAdviceBtn.querySelector('span').textContent = 'Generando...';

        try {
            const payload = { pending_tasks: pendingTasks };
            
            // Llama a tu nuevo archivo PHP de backend
            const response = await fetch('API-Optimizador-De-WhatsApp-Business.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload)
            });

            if (!response.ok) {
                const errorData = await response.json();
                throw new Error(errorData.error || `Error del servidor: ${response.status}`);
            }

            const data = await response.json();
            
            if (data.error) { // Si el backend envía un error específico
                throw new Error(data.error);
            }
            if (data.generated_content) { // El contenido generado está en 'generated_content'
                aiResponseContent.innerHTML = marked.parse(data.generated_content);
            } else {
                throw new Error("La respuesta de la IA no tuvo el formato esperado.");
            }

        } catch (error) {
            console.error("Error del Asistente IA:", error);
            aiResponseContent.innerHTML = `<div class="bg-red-100 text-center p-4 text-red-700 rounded-lg border border-red-300"><p><strong>Error:</strong> No se pudo generar la estrategia.</p><p class="mt-2 text-sm">${error.message || 'Error desconocido.'}</p></div>`;
        } finally {
            aiLoader.style.display = 'none';
            getAiAdviceBtn.disabled = false;
            getAiAdviceBtn.querySelector('span').textContent = 'Generar Mi Estrategia';
            // Desplazarse hacia la sección de resultados
            aiResponseContainer.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
    }

    renderChecklist();
    updateProgressAndTasks();

    checklistContainer.addEventListener('input', (e) => {
        if (e.target.classList.contains('toggle-switch')) {
            updateProgressAndTasks();
        }
    });
    getAiAdviceBtn.addEventListener('click', getAIAdvice);
});
</script>
</body>
</html>