<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que los datos requeridos estén presentes
$required_fields = ['businessName', 'businessContact', 'businessWeb', 'offerObjective', 'mainService', 'discountType', 'discountValue'];
foreach ($required_fields as $field) {
    if (!isset($data[$field]) || trim($data[$field]) === '') {
        http_response_code(400);
        echo json_encode(['error' => "Falta el campo requerido: '{$field}'. Asegúrate de completar todos los datos."]);
        exit;
    }
}

$businessName = $data['businessName'];
$businessContact = $data['businessContact'];
$businessWeb = $data['businessWeb'];
$offerObjective = $data['offerObjective'];
$mainService = $data['mainService'];
$discountType = $data['discountType'];
$discountValue = $data['discountValue'];

// Mapeo de objetivos de oferta a descripciones para el prompt
$objective_descriptions = [
    'referrals' => 'una promoción atractiva diseñada para conseguir referidos/recomendaciones de clientes existentes.',
    'neighborhood' => 'una oferta especial dirigida a nuevos clientes en un vecindario o zona específica.',
    'marketplace' => 'una oferta optimizada para plataformas de marketplace online (ej. Facebook Marketplace) para captar interés rápidamente.',
    'service_bundle' => 'un paquete de servicios que combine múltiples ofertas o un servicio principal con un extra.',
    'seasonal' => 'una oferta temática o de temporada, aprovechando una época específica del año o un evento.'
];
$offer_description_for_ai = $objective_descriptions[$offerObjective] ?? 'una oferta general para atraer nuevos clientes.';

// Mapeo de tipos de descuento a descripciones para el prompt
$discount_type_for_ai = '';
switch ($discountType) {
    case 'percentage':
        $discount_type_for_ai = "un descuento del {$discountValue}%";
        break;
    case 'amount':
        $discount_type_for_ai = "un descuento de \${$discountValue} (monto fijo)";
        break;
    case 'free_service':
        $discount_type_for_ai = "un servicio/producto gratis: {$discountValue}";
        break;
}

// --- PROMPT MAESTRO para el Asistente de Ofertas y Promociones ---
$prompt = "
Actúa como un experto en marketing y diseño de ofertas para negocios locales de servicios en USA.
Tu tarea es generar DOS ideas de ofertas promocionales creativas y efectivas, junto con sus textos para redes sociales.

Aquí están los detalles del negocio y la oferta deseada:
- Nombre del Negocio: \"{$businessName}\"
- Contacto (Teléfono/WhatsApp): \"{$businessContact}\"
- Web/Red Social: \"{$businessWeb}\"
- Objetivo de la Oferta: \"{$offer_description_for_ai}\"
- Servicio a Promocionar: \"{$mainService}\"
- Tipo de Descuento: \"{$discount_type_for_ai}\"

Para cada una de las DOS ideas de oferta, debes generar:
1.  Un \"offer_name\": Un nombre pegadizo para la oferta (ej. \"Pack Bienvenida Impecable\").
2.  Un \"offer_description\": Una descripción breve y clara de la oferta.
3.  Un \"promo_text_en\": El texto promocional completo en inglés, listo para redes sociales.
4.  Un \"promo_text_es\": El texto promocional completo en español, listo para redes sociales.

Directrices para los textos promocionales:
- El tono debe ser profesional, entusiasta y persuasivo.
- Formatea los textos para redes sociales con una estructura clara (gancho, detalles de la oferta, beneficio, llamada a la acción).
- Utiliza saltos de línea (\\n) para facilitar la lectura y asteriscos para negritas (*palabra*).
- **CRÍTICO:** Al final de cada texto promocional, incluye un bloque de Llamada a la Acción (CTA) CLARO y bien estructurado que incorpore el contacto del negocio. Ejemplo:
    \"¡Listo para transformar tu espacio? ¡Agenda hoy mismo!\\n📞 Llámanos o envíanos un WhatsApp: {$businessContact}\\n🌐 Visita nuestra página: {$businessWeb}\"
- Asegúrate de que las dos ideas de ofertas sean genuinamente diferentes en su enfoque o creatividad.
- No incluyas ningún otro texto o explicación fuera del objeto JSON principal.
- **PROHIBIDO ESTRICTAMENTE:** No utilices NINGÚN marcador de posición con corchetes `[]` o `{}`, como `[Business Name]`, `[Service]`, etc. en la salida. Usa los VALORES que te he dado.

Asegúrate de que la salida sea un objeto JSON válido que contenga un array llamado \"offers\". Cada objeto en el array representa una idea de oferta y contiene las cuatro claves: \"offer_name\", \"offer_description\", \"promo_text_en\", y \"promo_text_es\".
";

$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

$payload = [
    'contents' => [['parts' => [['text' => $prompt]]]],
    'generationConfig' => [
        'response_mime_type' => 'application/json',
        'response_schema' => [
            'type' => 'OBJECT',
            'properties' => [
                'offers' => [
                    'type' => 'ARRAY',
                    'items' => [
                        'type' => 'OBJECT',
                        'properties' => [
                            'offer_name' => ['type' => 'STRING'],
                            'offer_description' => ['type' => 'STRING'],
                            'promo_text_en' => ['type' => 'STRING'],
                            'promo_text_es' => ['type' => 'STRING']
                        ],
                        'required' => ['offer_name', 'offer_description', 'promo_text_en', 'promo_text_es']
                    ]
                ]
            ],
            'required' => ['offers']
        ]
    ]
];

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

if ($response === false || $http_code !== 200) {
    http_response_code(500);
    $error_details = $curl_error ?: ($response ? json_decode($response, true) : 'Respuesta de la API vacía o ilegible.');
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response_from_ai' => $response,
        'details' => $error_details
    ]);
    exit;
}

$result = json_decode($response, true);
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? '';

$generated_text = str_replace(['```json', '```'], '', $generated_text);
$final_data = json_decode(trim($generated_text), true);

if ($final_data === null || !isset($final_data['offers']) || !is_array($final_data['offers']) || count($final_data['offers']) < 2) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o no contiene las dos ofertas esperadas.',
        'raw_ai_response_after_trim' => trim($generated_text),
        'decoded_data_debug' => $final_data
    ]);
    exit;
}

echo json_encode($final_data);
?>