<?php
header('Content-Type: application/json');

// --- DEFINE TU API KEY DIRECTAMENTE AQUÍ (FUSIONADO DESDE config.php) ---
define('GEMINI_API_KEY', 'AIzaSyBohJvh2smaa0zW8VdyGpXpJEg269fJXJw');

// Verifica que la API Key no esté vacía.
if (empty(GEMINI_API_KEY)) {
    http_response_code(500);
    echo json_encode(['error' => 'La API Key de Gemini está vacía. Por favor, asegúrate de que el valor de GEMINI_API_KEY es correcto.']);
    exit;
}

$apiKey = GEMINI_API_KEY;

// Solo permitir solicitudes POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

// Obtener y decodificar los datos JSON de la solicitud
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que los datos requeridos estén presentes
if (!$data || !isset($data['service']) || !isset($data['ideal_client_summary'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos en la solicitud (service o ideal_client_summary).']);
    exit;
}

// --- PROMPT MAESTRO (v1.0 - GENERADOR DE HOOKS) ---
$prompt = "Actúa como un copywriter publicitario experto en crear 'hooks' (ganchos) potentes y cortos para anuncios en redes sociales.

--- FILOSOFÍA ---
Los hooks para imágenes o videos deben ser extremadamente cortos y directos para captar la atención en menos de 2 segundos. Deben atacar un un problema o evocar una transformación.

--- TU TAREA ESPECÍFICA ---
Un dueño de negocio necesita títulos para las imágenes/videos de sus anuncios. Analiza la información que te proporciona y genera lo siguiente:

--- DATOS DEL NEGOCIO ---
- Servicio que Ofrece: {$data['service']}
- Resumen del Cliente Ideal (su problema y deseo): {$data['ideal_client_summary']}

--- FORMATO DE RESPUESTA REQUERIDO ---
Genera un objeto JSON válido con la siguiente estructura y claves exactas:
- 'problem_hooks': Un array de 3 objetos. Cada objeto debe tener una clave 'es' y 'en' con un hook ENFOCADO EN EL PROBLEMA.
- 'result_hooks': Un array de 3 objetos. Cada objeto debe tener una clave 'es' y 'en' con un hook ENFOCADO EN LA TRANSFORMACIÓN O RESULTADO.
- 'image_ideas': Un array de 2 o 3 strings. Cada string es una idea creativa para la imagen del anuncio, descrita en español.

--- REGLAS ESTRICTAS ---
- **TODOS los hooks (tanto 'es' como 'en') DEBEN tener un máximo de 100 caracteres.** Esta regla es innegociable.
- Los hooks deben ser ganchos, no frases completas. Son para poner sobre una imagen.
- Las 'image_ideas' deben estar en español.";

// URL de la API de Google Gemini
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
$payload = ['contents' => [['parts' => [['text' => $prompt]]]], 'generationConfig' => ['response_mime_type' => 'application/json']];

// Inicializar cURL
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Devuelve la respuesta como string en lugar de imprimirla
curl_setopt($ch, CURLOPT_POST, true);           // Método POST
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload)); // Datos a enviar en formato JSON
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']); // Cabecera Content-Type

// Ejecutar la solicitud cURL y obtener la respuesta
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Obtener el código HTTP
$curl_error = curl_error($ch); // Obtener cualquier error de cURL
curl_close($ch); // Cerrar la sesión cURL

// Manejo de errores de la solicitud cURL o respuesta HTTP
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response' => $response // Incluir respuesta cruda para depuración
    ]);
    exit;
}

// Decodificar la respuesta de la IA
$result = json_decode($response, true);

// Extraer el texto generado. Esto asume una estructura específica de la respuesta de la API de Gemini.
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? null;

// Limpiar el texto de posibles bloques de código Markdown
if ($generated_text) {
    $generated_text = str_replace(['```json', '```'], '', $generated_text);
}

// Intentar decodificar el JSON final.
$final_data = json_decode(trim($generated_text), true);

// Validar el formato del JSON final
if ($final_data === null) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA devolvió un formato de JSON inválido o la respuesta estaba vacía.',
        'raw_ai_response_after_trim' => trim($generated_text) // Mostrar lo que se intentó decodificar
    ]);
    exit;
}

// Validar que la estructura esperada esté presente (ej. 'problem_hooks')
if (!isset($final_data['problem_hooks'])) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA no devolvió la estructura de datos esperada (falta problem_hooks).',
        'generated_data' => $final_data // Mostrar los datos parciales recibidos de la IA
    ]);
    exit;
}

// Si todo es correcto, devolver los datos generados
echo json_encode($final_data);
?>