<?php
header('Content-Type: application/json');

// Incluye el archivo de configuración con la API Key.
require_once 'config.php';

// Ahora, la API Key se toma de la constante definida en config.php
$apiKey = GEMINI_API_KEY;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido. Utiliza POST.']);
    exit;
}

// Obtener y decodificar los datos JSON de la solicitud
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Validar que los datos requeridos estén presentes
if (!isset($data['pending_tasks']) || !is_array($data['pending_tasks'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Faltan datos de tareas pendientes en la solicitud o el formato es incorrecto.']);
    exit;
}

$pendingTasks = $data['pending_tasks'];

// Si no hay tareas pendientes, no hay necesidad de llamar a la IA
if (empty($pendingTasks)) {
    echo json_encode(['generated_content' => "¡Excelente! Has completado todas las tareas de optimización básica. ¡Tu perfil de WhatsApp Business está en óptimas condiciones!"]);
    exit;
}

$pendingTasksFormatted = implode("\n", $pendingTasks);

// --- PROMPT MAESTRO para la IA ---
$prompt = "Actúa como un experto en marketing digital y WhatsApp Business. He realizado un diagnóstico de mi perfil y tengo las siguientes áreas de mejora pendientes:

{$pendingTasksFormatted}

Basado en estas tareas pendientes, genera un plan de acción estratégico y personalizado para mí. El plan debe estar en formato Markdown y organizado en tres secciones principales con los siguientes títulos exactos y en este orden:

### 💡 Ideas y Estrategias Clave
### ⚙️ Plan de Implementación Paso a Paso
### 🚀 Próximos Pasos y Consejos Adicionales

En la primera sección, 'Ideas y Estrategias Clave', proporciona una visión general de alto nivel y la importancia de abordar los puntos débiles.

En la segunda sección, 'Plan de Implementación Paso a Paso', detalla las acciones específicas que debo tomar para cada tarea pendiente, ofreciendo ejemplos prácticos y redacciones sugeridas si es aplicable (por ejemplo, un borrador para el mensaje de bienvenida o la descripción del negocio).

En la tercera sección, 'Próximos Pasos y Consejos Adicionales', ofrece consejos para ir más allá de lo básico, como estrategias de contenido para estados de WhatsApp, cómo promocionar mi enlace de WhatsApp y cómo medir el éxito.

Asegúrate de que la respuesta sea práctica, motivadora y fácil de entender para alguien que no es un experto técnico. La respuesta final debe ser únicamente el texto en formato Markdown, sin ninguna introducción o saludo previo.";

// URL de la API de Google Gemini
// Usamos el modelo 1.5-flash por su rapidez y rentabilidad, ideal para este tipo de respuesta.
$apiUrl = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

$payload = [
    'contents' => [['parts' => [['text' => $prompt]]]],
    'generationConfig' => [
        'response_mime_type' => 'text/plain', // Esperamos texto Markdown, no JSON estructurado por la IA
    ]
];

// Inicializar cURL
$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Devuelve la respuesta como string en lugar de imprimirla
curl_setopt($ch, CURLOPT_POST, true);           // Método POST
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload)); // Datos a enviar en formato JSON
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']); // Cabecera Content-Type

// Ejecutar la solicitud cURL y obtener la respuesta
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Obtener el código HTTP
$curl_error = curl_error($ch); // Obtener cualquier error de cURL
curl_close($ch); // Cerrar la sesión cURL

// Manejo de errores de la solicitud cURL o respuesta HTTP
if ($response === false || $http_code !== 200) {
    http_response_code(500);
    echo json_encode([
        'error' => 'No se pudo obtener una respuesta de la IA. Posiblemente un problema de conexión o API Key.',
        'http_code' => $http_code,
        'curl_error' => $curl_error,
        'raw_response' => $response // Incluir respuesta cruda para depuración
    ]);
    exit;
}

// Decodificar la respuesta de la IA
$result = json_decode($response, true);

// Extraer el texto generado. Esto asume una estructura específica de la respuesta de la API de Gemini.
$generated_text = $result['candidates'][0]['content']['parts'][0]['text'] ?? null;

if ($generated_text === null) {
    http_response_code(500);
    echo json_encode([
        'error' => 'La IA no devolvió contenido de texto. Intenta de nuevo.',
        'raw_ai_response' => $result
    ]);
    exit;
}

// Si todo es correcto, devolver los datos generados
echo json_encode(['generated_content' => $generated_text]);
?>